#include <NDS.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "DSGraph.h"
#include "font5x6.h"

char * fontbin = NULL;
char * fontbin_zen = NULL;

int clsColor8[2]  = { 0x00, 0x00 };
int clsColor16[2] = { 0x8000, 0x8000 };

extern void LOG( char * str , ... );

void memcpy8( u8 * dst,u8 * src, int cnt ){
	int c;
	for( c=0;c<cnt;c++ ) *dst++ = *src++;
}
void memcpy16( u16 * dst,u16 * src, int cnt ){
	int c;
	for( c=0;c<cnt;c++ ) *dst++ = *src++;
}

void line8( uint8 * gfx , int x, int y, int w, int h, uint8 col )
{
	int E;
	int dx,dy,sx,sy,i;

	sx = ( w>0 ) ? 1 : -1;
	dx = ( w>0 ) ? w-1 : (-w)-1 ;
	sy = ( h>0 ) ? 1 : -1;
	dy = ( h>0 ) ? h-1 : (-h)-1 ;

	if( dx >= dy ) {
		E = -dx;
		for( i = 0; i <= dx; i++ ) {
			pset8(gfx, x, y, col );
			x += sx;
			E += 2 * dy;
			if( E >= 0 ) {
				y += sy;
				E -= 2 * dx;
			}
		}
	} else {
		E = -dy;
		for( i = 0; i <= dy; i++ ) {
			pset8(gfx, x, y, col );
			y += sy;
			E += 2 * dx;
			if( E >= 0 ) {
				x += sx;
				E -= 2 * dy;
			}
		}
	}
}

void line16( uint16 * gfx , int x, int y, int w, int h, uint16 col )
{
	int E;
	int dx,dy,sx,sy,i;

	sx = ( w>0 ) ? 1 : -1;
	dx = ( w>0 ) ? w-1 : (-w)-1 ;
	sy = ( h>0 ) ? 1 : -1;
	dy = ( h>0 ) ? h-1 : (-h)-1 ;

	if( dx >= dy ) {
		E = -dx;
		for( i = 0; i <= dx; i++ ) {
			pset16(gfx, x, y, col );
			x += sx;
			E += 2 * dy;
			if( E >= 0 ) {
				y += sy;
				E -= 2 * dx;
			}
		}
	} else {
		E = -dy;
		for( i = 0; i <= dy; i++ ) {
			pset16(gfx, x, y, col );
			y += sy;
			E += 2 * dx;
			if( E >= 0 ) {
				x += sx;
				E -= 2 * dy;
			}
		}
	}
}

void box8( uint8 * gfx, int x,int y,int w,int h, uint8 col )
{
	line8( gfx,x    ,y,w,0,col );
	line8( gfx,x,y+h-1,w,0,col );
	line8( gfx,x,y    ,0,h,col );
	line8( gfx,x+w-1,y,0,h,col );
}

void box16( uint16 * gfx, int x,int y,int w,int h,uint16 col )
{
	line16( gfx,x    ,y,w,0,col );
	line16( gfx,x,y+h-1,w,0,col );
	line16( gfx,x,y    ,0,h,col );
	line16( gfx,x+w-1,y,0,h,col );
}

void fill8( uint8 * gfx, int x,int y,int w,int h,uint8 col )
{
	int i;
	for( i=y;i<y+h;i++ ){
		line8( gfx,x,i,w,0,col );
	}
}

void fill16( uint16 * gfx, int x,int y,int w,int h,uint16 col )
{
	int i;
	for( i=y;i<y+h;i++ ){
		line16( gfx,x,i,w,0,col );
	}
}

void cls8(int g){
	if(g&1)fill8( (uint8*)BG_GFX,     0,0,256,256, clsColor8[0] );
	if(g&2)fill8( (uint8*)BG_GFX_SUB, 0,0,256,256, clsColor8[1] );
}

void cls16(int g){
	if(g&1)fill16( BG_GFX,     0,0,256,256, clsColor16[0] );
	if(g&2)fill16( BG_GFX_SUB, 0,0,256,256, clsColor16[1] );
}

void drawWindow8( uint8 * gfx, int x, int y , int w, int h )
{
	line8( gfx,x    ,y    ,w,0 ,0xFE );
	line8( gfx,x    ,y+h-1,w,0 ,0xF2 );
	line8( gfx,x    ,y    ,0,h ,0xFE );
	line8( gfx,x+w-1,y    ,0,h ,0xF2 );

	line8( gfx,x+1  ,y+1  ,w-2,0  ,0xFF );
	line8( gfx,x+1  ,y+h-2,w-2,0  ,0xF3 );
	line8( gfx,x+1  ,y+1  ,0  ,h-2,0xFF );
	line8( gfx,x+w-2,y+1  ,0  ,h-2,0xF3 );

	fill8( gfx, x+2,y+2,w-4,h-4, 0xFE );
}

void drawWindow16( uint16 * gfx, int x, int y , int w, int h )
{
	line16( gfx,x    ,y    ,w,0 ,RGB16(1,26,26,26) );
	line16( gfx,x    ,y+h-1,w,0 ,RGB16(1, 8, 8, 8) );
	line16( gfx,x    ,y    ,0,h ,RGB16(1,26,26,26) );
	line16( gfx,x+w-1,y    ,0,h ,RGB16(1, 8, 8, 8) );

	line16( gfx,x+1  ,y+1  ,w-2,0  ,RGB16(1,31,31,31) );
	line16( gfx,x+1  ,y+h-2,w-2,0  ,RGB16(1,16,16,16) );
	line16( gfx,x+1  ,y+1  ,0  ,h-2,RGB16(1,31,31,31) );
	line16( gfx,x+w-2,y+1  ,0  ,h-2,RGB16(1,16,16,16) );

	fill16( gfx, x+2,y+2,w-4,h-4, RGB16(1,26,26,26) );
}

void drawButton8( uint8 * gfx, int x, int y , int w, int h, u8 * buf )
{
	box8( gfx, x, y, w, h, 0xF0 );
	drawWindow8(gfx, x+1,y+1, w-2,h-2 );
	int len = strlen( (char*)buf );
	drawText8( gfx, x + w/2 - len*5/2, y + h/2 - 3, buf, 0xF0 , 0 );
}

void drawButton16( uint16 * gfx, int x, int y , int w, int h, u8 * buf )
{
	box16( gfx, x, y, w, h, RGB16(1,0,0,0) );
	drawWindow16(gfx, x+1,y+1, w-2,h-2 );
	int len = strlen( (char*)buf );
	drawText16( gfx, x + w/2 - len*5/2, y + h/2 - 3, buf, RGB16(1,0,0,0) , 0 );
}

void drawFont8( uint8 * gfx, u16 fx, u16 fy, u8 chr, u8 col, u8 bcol )
{
	int i;
	if( (chr>=0x20) && (chr<=0x82) ){
		u8 * f=(u8*)font5x6 +(int)(chr-0x20)*6;
		uint8 * g = gfx + fy * 256 + fx;
		for( i=0;i<6;i++ ){
			*g = *f&0x80?col:bcol;g++;
			*g = *f&0x40?col:bcol;g++;
			*g = *f&0x20?col:bcol;g++;
			*g = *f&0x10?col:bcol;g++;
			*g = *f&0x08?col:bcol;
			if( fy+i > 255 ){
				fy=0;
				g = gfx + fx;
			}else{
				g+=256-4;
			}
			f++;
		}
	}
}

void drawFont8trans( uint8 * gfx, u16 fx, u16 fy, u8 chr, u8 col )
{
	int i;
	if( (chr>=0x20) && (chr<=0x82) ){
		u8 * f=(u8*)font5x6 +(int)(chr-0x20)*6;
		uint8 * g = gfx + fy * 256 + fx;
		for( i=0;i<6;i++ ){
			*g = *f&0x80?col:*g;g++;
			*g = *f&0x40?col:*g;g++;
			*g = *f&0x20?col:*g;g++;
			*g = *f&0x10?col:*g;g++;
			*g = *f&0x08?col:*g;
			if( fy+i > 255 ){
				fy=0;
				g = gfx + fx;
			}else{
				g+=256-4;
			}
			f++;
		}
	}
}

void drawFont16( uint16 * gfx, u16 fx, u16 fy, u8 chr, u16 col, u16 bcol )
{
	int i;
	if( (chr>=0x20) && (chr<=0x82) ){
		u8 * f=(u8*)font5x6 +(int)(chr-0x20)*6;
		uint16 o;
		uint16 * g = gfx + fy * 256 + fx;
		for( i=0;i<6;i++ ){
			o = *g; *g = *f&0x80?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x40?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x20?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x10?col:(bcol?bcol:o);g++;
			o = *g; *g = *f&0x08?col:(bcol?bcol:o);
			if( fy+i > 255 ){
				fy=0;
				g = gfx + fx;
			}else{
				g+=256-4;
			}
			f++;
		}
	}
}

void drawText8( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col, u8 bcol )
{
	int x = fx;
	int i=0;
	while( buf[i] )
	{
		drawFont8( gfx, x, fy, buf[i], col, bcol );
		x +=5;
		i++;
	}
}

void drawText8trans( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col )
{
	int x = fx;
	int i=0;
	while( buf[i] )
	{
		drawFont8trans( gfx, x, fy, buf[i], col );
		x +=5;
		i++;
	}
}

void drawText16( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol )
{
	int x = fx;
	int i=0;
	while( buf[i] )
	{
		drawFont16( gfx, x, fy, buf[i], col, bcol );
		x +=5;
		i++;
	}
}


int font_height = 8;
int font_width_han = 4;
int font_width_zen = 8;
int font_width_han_byte = 1;
int font_width_zen_byte = 1;
int font_zen_line = 188 * ( 1 * 8 );

int loadFont(char * fn, int h, int wh, int wz )
{
	size_t siz;
	FILE * fp;
	fp = fopen(fn, "rb");
	if( fp != NULL ){
		fseek(fp,0,SEEK_END);
		siz = ftell(fp);
		fseek(fp,0,SEEK_SET);
		LOG( "loadfont siz:%d", siz );
		if( siz == 0 ){
			LOG( "File size zero?" );
			return false;
		}
		if( fontbin != NULL ) free(fontbin);
		fontbin = (char *)malloc( siz );
		if( fread(fontbin, 1, siz, fp ) != siz ){
			LOG( "font load error" );
			fclose( fp );
			free( fontbin );
			fontbin = NULL;
			return false;
		}
		fclose( fp );
	}else{
		LOG( "wrong font filename" );
		return false;
	}

	font_height = h;
	font_width_han = wh;
	font_width_zen = wz;
	font_width_han_byte = (wh%8)?wh/8+1:wh/8;
	font_width_zen_byte = (wz%8)?wz/8+1:wz/8;
	font_zen_line = 188 * ( font_width_zen_byte * font_height );	   /* 188 */
	fontbin_zen = fontbin + 256 * font_width_han_byte * font_height;   /* p256 */
	return true;
}

void drawFontExt8( uint8 * gfx, u16 fx, u16 fy, u16 chr, u8 col, u8 bcol )
{
	if( fontbin == NULL ) return;
	int i;
	u8 nochr[32] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

	u8 * f;
	u8 * g;
	u8 * ng;
	u16 fw;

	if( chr<=0x00FF ){
//		LOG( "HAN:%x",chr );
		f=(u8*)fontbin + (int)chr * font_width_han_byte * font_height;
		g = gfx + fy * 256 + fx;
		fw = font_width_han;
	}else{
//		LOG( "ZEN:%x",chr );
		int c1 = (chr>>8);
		if( c1>0xDF) c1 -= 0x40;
		c1 -= 0x81;
		int c2 = chr&0xFF;
		f=(u8*)fontbin_zen + c1 * font_zen_line;
		if( c2<0x40 || c2==0x7F || c2>0xFC ){ 
			f = nochr;
		}else {
			if( c2>0x7F ) c2--;
			c2 -= 0x40;
			f += c2 * font_width_zen_byte * font_height;
		}
		g = gfx + fy * 256 + fx;
		fw = font_width_zen;
	}

	for( i=0;i<font_height;i++ ){
		u16 w = fw;
		ng = g + 256;
		while( w > 0 ){
			*g = *f&0x80?col:bcol;g++;w--;if(w==0)break;
			*g = *f&0x40?col:bcol;g++;w--;if(w==0)break;
			*g = *f&0x20?col:bcol;g++;w--;if(w==0)break;
			*g = *f&0x10?col:bcol;g++;w--;if(w==0)break;
			*g = *f&0x08?col:bcol;g++;w--;if(w==0)break;
			*g = *f&0x04?col:bcol;g++;w--;if(w==0)break;
			*g = *f&0x02?col:bcol;g++;w--;if(w==0)break;
			*g = *f&0x01?col:bcol;g++;w--;if(w==0)break;
			f++;
		}
		f++;
		g = ng;
	}
}

void drawFontExt8trans( uint8 * gfx, u16 fx, u16 fy, u16 chr, u8 col )
{
	if( fontbin == NULL ) return;
	int i;
	u8 nochr[32] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

	u8 * f;
	u8 * g;
	u8 * ng;
	u16 fw;

	if( chr<=0x00FF ){
//		LOG( "HAN:%x",chr );
		f=(u8*)fontbin + (int)chr * font_width_han_byte * font_height;
		g = gfx + fy * 256 + fx;
		fw = font_width_han;
	}else{
//		LOG( "ZEN:%x",chr );
		int c1 = (chr>>8);
		if( c1>0xDF) c1 -= 0x40;
		c1 -= 0x81;
		int c2 = chr&0xFF;
		f=(u8*)fontbin_zen + c1 * font_zen_line;
		if( c2<0x40 || c2==0x7F || c2>0xFC ){ 
			f = nochr;
		}else {
			if( c2>0x7F ) c2--;
			c2 -= 0x40;
			f += c2 * font_width_zen_byte * font_height;
		}
		g = gfx + fy * 256 + fx;
		fw = font_width_zen;
	}

	for( i=0;i<font_height;i++ ){
		u16 w = fw;
		ng = g + 256;
		while( w > 0 ){
			*g = *f&0x80?col:*g;g++;w--;if(w==0)break;
			*g = *f&0x40?col:*g;g++;w--;if(w==0)break;
			*g = *f&0x20?col:*g;g++;w--;if(w==0)break;
			*g = *f&0x10?col:*g;g++;w--;if(w==0)break;
			*g = *f&0x08?col:*g;g++;w--;if(w==0)break;
			*g = *f&0x04?col:*g;g++;w--;if(w==0)break;
			*g = *f&0x02?col:*g;g++;w--;if(w==0)break;
			*g = *f&0x01?col:*g;g++;w--;if(w==0)break;
			f++;
		}
		f++;
		g = ng;
	}
}

void drawFontExt16( uint16 * gfx, u16 fx, u16 fy, u16 chr, u16 col, u16 bcol )
{
	if( fontbin == NULL ) return;
	int i;
	u8 nochr[32] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

	u8 * f;
	u16 o;
	u16 * g;
	u16 * ng;
	u16 fw;

	if( chr<=0x00FF ){
//		LOG( "HAN:%x",chr );
		f=(u8*)fontbin + (int)chr * font_width_han_byte * font_height;
		g = gfx + fy * 256 + fx;
		fw = font_width_han;
	}else{
//		LOG( "ZEN:%x",chr );
		int c1 = (chr>>8);
		if( c1>0xDF) c1 -= 0x40;
		c1 -= 0x81;
		int c2 = chr&0xFF;
		f=(u8*)fontbin_zen + c1 * font_zen_line;
		if( c2<0x40 || c2==0x7F || c2>0xFC ){ 
			f = nochr;
		}else {
			if( c2>0x7F ) c2--;
			c2 -= 0x40;
			f += c2 * font_width_zen_byte * font_height;
		}
		g = gfx + fy * 256 + fx;
		fw = font_width_zen;
	}

	for( i=0;i<font_height;i++ ){
		u16 w = fw;
		ng = g + 256;
		while( w > 0 ){
			o = *g; *g = *f&0x80?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			o = *g; *g = *f&0x40?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			o = *g; *g = *f&0x20?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			o = *g; *g = *f&0x10?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			o = *g; *g = *f&0x08?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			o = *g; *g = *f&0x04?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			o = *g; *g = *f&0x02?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			o = *g; *g = *f&0x01?col:(bcol?bcol:o);g++;w--;if(w==0)break;
			f++;
		}
		f++;
		g = ng;
	}
}

int isleadbyte( u8 c )
{
	if((c>0x80 && c<0xa0)|| (c>0xdf && c<0xfd)) return true;
	return false;
}

void drawTextExt8( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col, u8 bcol )
{
	int x = fx;
	int i=0;
	int c;
	int n;
	
	while( buf[i] )
	{
		if( isleadbyte( buf[i] ) ) {
			c = (int)buf[i]<<8 | buf[i+1];
			n = font_width_zen;
			i+=2;
		}else{
			c = buf[i];
			n = font_width_han;
			i++;
		}
		drawFontExt8( gfx, x, fy, c, col, bcol );
		x += n;
	}
}

void drawTextExt8trans( uint8 * gfx, u16 fx, u16 fy, u8 * buf, u8 col )
{
	int x = fx;
	int i=0;
	int c;
	int n;
	
	while( buf[i] )
	{
		if( isleadbyte( buf[i] ) ) {
			c = (int)buf[i]<<8 | buf[i+1];
			n = font_width_zen;
			i+=2;
		}else{
			c = buf[i];
			n = font_width_han;
			i++;
		}
		drawFontExt8trans( gfx, x, fy, c, col );
		x += n;
	}
}

void drawTextExt16( uint16 * gfx, u16 fx, u16 fy, u8 * buf, u16 col, u16 bcol )
{
	int x = fx;
	int i=0;
	int c;
	int n;
	
	while( buf[i] )
	{
		if( isleadbyte( buf[i] ) ) {
			c = (int)buf[i]<<8 | buf[i+1];
			n = font_width_zen;
			i+=2;
		}else{
			c = buf[i];
			n = font_width_han;
			i++;
		}
		drawFontExt16( gfx, x, fy, c, col, bcol );
		x += n;
	}
}

void copyGraph8( uint8 * dgfx, u16 dx, u16 dy, uint8 * sgfx, u16 sx, u16 sy, u16 width, u16 height )
{
	int i;
	for( i=sy;i<sy+height;i++ ){
		memcpy8( dgfx + 256 * dy + dx, sgfx + 256*i+sx, width );
		dy++;
	}
}

void copyGraph16( uint16 * dgfx, u16 dx, u16 dy, uint16 * sgfx, u16 sx, u16 sy, u16 width, u16 height )
{
	int i;
	for( i=sy;i<sy+height;i++ ){
		memcpy16( dgfx + 256 * dy + dx, sgfx + 256*i+sx, width );
		dy++;
	}
}

void drawIcon8( uint8 * gfx, int x, int y, int w, int h, u8 * buf )
{
	int i,j;
	gfx += y*256+x;

	for(i=0;i<h;i++){
		for(j=0;j<w;j++) *gfx++ = *buf++;
		gfx += (256-w);
	}
}

void drawIcon16( uint16 * gfx, int x, int y, int w, int h, u16 * buf )
{
	int i,j;
	gfx += y*256+x;

	for(i=0;i<h;i++){
		for(j=0;j<w;j++) *gfx++ = *buf++;
		gfx += (256-w);
	}
}

void die(char *fmt, ...)
{
	va_list ap;
	char buf[256];

	va_start(ap, fmt);
	vsprintf(buf,fmt, ap);
	va_end(ap);
	LOG( buf );
	LOG( "died..." );
	while(1) swiWaitForVBlank();
}

#define LOG_CHR_NUM  50
void LOG( char * str , ... )
{
	static int sy = 0;
	static int fy = 192 - 6;
	va_list args;
	char buf[256];
	char a[LOG_CHR_NUM+1];
	char * n;
	int l;
	va_start(args,str);
	vsnprintf(buf,255,str,args);
	va_end(args);
	l = strlen( buf );
	n = buf;
	while(l){
		if( l > LOG_CHR_NUM ){
			strncpy(a, n,LOG_CHR_NUM);
			n+=LOG_CHR_NUM;
			l=strlen(n);
		}else{
			sprintf( a, "%-50s", n );
			l=0;
		}
//		copyGraph( BG_GFX_SUB, 0, 160, BG_GFX_SUB, 0, 168, 256, 24 );
//		fill( BG_GFX_SUB, 0, 184, 256, 8, 0x8000 );
		line8( (uint8 *)BG_GFX_SUB, 0, fy-1, 256, 0x00, 0x00 );
		drawText8( (uint8 *)BG_GFX_SUB, 0, fy, (u8*)a, 0xFF, 0x00 );
//		BACKGROUND_SUB.scroll[0].y = sy;
		BACKGROUND_SUB.bg2_rotation.dy = sy * 256;
		fy += 7;
		sy += 7;
		if( fy > 255 ) fy -= 256;
		if( sy > 255 ) sy -= 256;
	}
}

void iDeasMessage(char * str, ... )
{
	int siz = 1023;
	char *buf;
	va_list args;
	buf = malloc( siz + 1 );
	memset(buf, 0, siz+1 );
	va_start(args,str);
	vsnprintf(buf,siz,str,args);
	va_end(args);

	asm volatile( 
		"	mov 	r0,%0					@ r0 = buf		\r\n"
		"	swi 	#0xFC000 				@ swi			\r\n"
		: :"r"(buf) :"r0"
	);
}

void iDeasDebug()
{
	asm volatile( 
		"	swi 	#0xFD000 				@ swi			\r\n"
	);
}
