#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "defs.h"
#include "regs.h"
#include "mem.h"
#include "hw.h"
#include "rtc.h"
#include "lcd.h"
#include "sound.h"
#include "save.h"
#include "rc.h"
#include "stdfnc.h"
#include "sys_gfx.h"
#include "sys_winCE.h"
#include "getromname.h"

static int mbc_table[256] =
{
	0, 1, 1, 1, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 3,
	3, 3, 3, 3, 0, 0, 0, 0, 0, 5, 5, 5, MBC_RUMBLE, MBC_RUMBLE, MBC_RUMBLE, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MBC_HUC3, MBC_HUC1
};

static int rtc_table[256] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0
};

static int batt_table[256] =
{
	0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0,
	1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0,
	0
};

static int romsize_table[256] =
{
	2, 4, 8, 16, 32, 64, 128, 256, 512,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 128, 128, 128
	/* 0, 0, 72, 80, 96  -- actual values but bad to use these! */
};

static int ramsize_table[256] =
{
	1, 1, 1, 4, 16,
	4 /* FIXME - what value should this be?! */
};


static char *romfile    = NULL;
static char *savename   = NULL;
/*
static char *sramfile   = NULL;
static char *rtcfile    = NULL;
static char *statefile  = NULL;
*/

char *savedir  = NULL;
char *statedir = NULL;

int saveslot = 0;

int forcebatt = 0;
int nobatt    = 0;
int forcedmg  = 0;
int gbamode   = 0;

int memfill = -1;
int memrand = -1;


static void initmem(void *mem, int size)
{
	char *p = (char *) mem;
	if (memrand >= 0)
	{
		srand(memrand ? memrand : time(0));
		while(size--) *(p++) = rand();
	}
	else if (memfill >= 0)
		memset(p, memfill, size);
}

byte ** get_sram( int * siz )
{
	if( !siz ) *siz = 8192 * mbc.ramsize;
	return (byte **)ram.sbank;
}

void set_sram(byte * sram )
{
	memcpy( ram.sbank, sram, 8192 * mbc.ramsize );
}

static byte *loadfile(FILE *f, int *len)
{
	int c, l = 0, p = 0;
	byte *d = 0;

	l = ppp_GetFileSize(f);
	if( l > 0 ){
		d = (byte*)malloc( l );
		c = fread(d, 1, l, f);
	}
	*len = l;
	return d;
}

static byte *inf_buf;
static int inf_pos, inf_len;

int rom_load()
{
	FILE *f;
	byte c, *data, *header;
	int len = 0, rlen;

	f = fopen(romfile, "rb");
	if (!f) die("cannot open rom file: %s\n", romfile);

	data = loadfile(f, &len);
	header = data;

    memcpy(rom.name, header+0x0134, 16);
	if (rom.name[14] & 0x80) rom.name[14] = 0;
	if (rom.name[15] & 0x80) rom.name[15] = 0;
	rom.name[16] = 0;

	c = header[0x0147];
	mbc.type = mbc_table[c];
	mbc.batt = (batt_table[c] && !nobatt) || forcebatt;
	rtc.batt = rtc_table[c];
	mbc.romsize = romsize_table[header[0x0148]];
	mbc.ramsize = ramsize_table[header[0x0149]];

	if (!mbc.romsize) die("unknown ROM size %02X\n", header[0x0148]);
	if (!mbc.ramsize) die("unknown SRAM size %02X\n", header[0x0149]);

	rlen = 16384 * mbc.romsize;
	rom.bank = (byte(*)[16384])realloc(data, rlen);
    header = (byte *)rom.bank[0];
    if (rlen > len) memset(rom.bank[0]+len, 0xff, rlen - len);
	
    ram.sbank = (byte(*)[8192])malloc(8192 * mbc.ramsize);

	initmem(ram.sbank, 8192 * mbc.ramsize);
	initmem(ram.ibank, 4096 * 8);

	mbc.rombank = 1;
	mbc.rambank = 0;

	c = header[0x0143];
	hw.cgb = ((c == 0x80) || (c == 0xc0)) && !forcedmg;
	hw.gba = (hw.cgb && gbamode);

	if (strcmp(romfile, "-")) fclose(f);

	return 0;
}


int sram_load()
{
	FILE *f;
	char sramfile[256];

	if (!mbc.batt || !savename ) return -1;

	/* Consider sram loaded at this point, even if file doesn't exist */
	ram.loaded = 1;

	sprintf(sramfile, "%s\\%s.sav", GetFullPath(savedir), savename);
	f = fopen(sramfile, "rb");
	if (!f) return -1;
	fread(ram.sbank, 8192, mbc.ramsize, f);
	fclose(f);
	
	return 0;
}


int sram_save()
{
	FILE *f;
	char sramfile[256];

	/* If we crash before we ever loaded sram, DO NOT SAVE! */
	if (!mbc.batt || !savename || !ram.loaded || !mbc.ramsize) return -1;

	sprintf(sramfile, "%s\\%s.sav", GetFullPath(savedir), savename);
	f = fopen(sramfile, "wb");
	if (!f) return -1;
	fwrite(ram.sbank, 8192, mbc.ramsize, f);
	fclose(f);
	
	return 0;
}


void state_save(int n)
{
	FILE *f;
	char name[256];

	if( savename == NULL ) return;

	if (n < 0) n = saveslot;
	if (n < 0) n = 0;
	sprintf(name, "%s\\%s.%03d", GetFullPath(statedir), savename, n);
	if ((f = fopen(name, "wb")))
	{
		savestate(f);
		fclose(f);
	}
}


void state_load(int n)
{
	FILE *f;
	char name[256];

	if( savename == NULL ) return;

	if (n < 0) n = saveslot;
	if (n < 0) n = 0;
	sprintf(name, "%s\\%s.%03d", GetFullPath(statedir), savename, n);
	if ((f = fopen(name, "rb")))
	{
		loadstate(f);
		fclose(f);
		vram_dirty();
		pal_dirty();
		sound_dirty();
		mem_updatemap();
	}
}

void rtc_save()
{
	FILE *f;
	char rtcfile[256];
	if (!rtc.batt) return;
	sprintf(rtcfile , "%s\\%s.rtc", GetFullPath(savedir), savename);
	if (!(f = fopen(rtcfile, "wb"))) return;
	rtc_save_internal(f);
	fclose(f);
}

void rtc_load()
{
	FILE *f;
	char rtcfile[256];
	if (!rtc.batt) return;
	sprintf(rtcfile , "%s\\%s.rtc", GetFullPath(savedir), savename);
	if (!(f = fopen(rtcfile, "r"))) return;
	rtc_load_internal(f);
	fclose(f);
}


void loader_unload()
{
	sram_save();
	if (romfile) free(romfile);
/*	if (sramfile) free(sramfile);
	if (statefile) free(statefile);
*/	if (savedir) free(savedir);
	if (rom.bank) free(rom.bank);
	if (ram.sbank) free(ram.sbank);
//	romfile = sramfile = 0;
	rom.bank = 0;
	ram.sbank = 0;
	mbc.type = mbc.romsize = mbc.ramsize = mbc.batt = 0;
}

static char *base(char *s)
{
	char *p;
	p = strrchr(s, '\\');
	if (p) return p+1;
	return s;
}

static char *ldup(char *s)
{
	int i;
	char *n, *p;
	p = n = (char* )malloc(strlen(s));
	for (i = 0; s[i]; i++) if (isalnum(s[i])) *(p++) = tolower(s[i]);
	*p = 0;
	return n;
}

static void cleanup()
{
	sram_save();
	rtc_save();
	/* IDEA - if error, write emergency savestate..? */
}

void loader_init(char *s)
{
	char *p;

//	sys_checkdir(savedir, 1); /* needs to be writable */

	romfile = s;
	rom_load();
	vid_settitle(rom.name);

	savename = strdup(base(romfile));
	if( p = strchr(savename, '.') ) *p = 0; 
/*
	sramfile = (char *)malloc(256);
	rtcfile  = (char *)malloc(256);
	statefile= (char *)malloc(256);
	sprintf(sramfile, "%s\\%s.sav", GetFullPath(savedir), name);
	sprintf(rtcfile , "%s\\%s.rtc", GetFullPath(savedir), name);
	sprintf(statefile,"%s\\%s", GetFullPath(statedir), name);
*/

	sram_load();
	rtc_load();

}

rcvar_t loader_exports[] =
{
	RCV_STRING("savedir", &savedir),
	RCV_STRING("savename", &savename),
	RCV_INT("saveslot", &saveslot),
	RCV_BOOL("forcebatt", &forcebatt),
	RCV_BOOL("nobatt", &nobatt),
	RCV_BOOL("forcedmg", &forcedmg),
	RCV_BOOL("gbamode", &gbamode),
	RCV_INT("memfill", &memfill),
	RCV_INT("memrand", &memrand),
	RCV_END
};









