


#include "defs.h"
#include "regs.h"
#include "hw.h"
#include "cpu.h"
#include "mem.h"
#include "lcd.h"
#include "sound.h"
#include "loader.h"
#include "rtc.h"
#include "rc.h"
#include "input.h"
#include "sys_gfx.h"
#include "sys_sound.h"
#include "sys_winCE.h"

int framelen = 16743;
static int loopflg = true;

void emu_init()
{
}

/*
 * emu_reset is called to initialize the state of the emulated
 * system. It should set cpu registers, hardware registers, etc. to
 * their appropriate values at powerup time.
 */

void emu_reset()
{
	hw_reset();
	lcd_reset();
	cpu_reset();
	mbc_reset();
	sound_reset();
}

void emu_step()
{
	cpu_emulate(cpu.lcdc);
}

void doevents()
{
//	event_t ev;
//	int st;

	joy_poll();
/*
	while (ev_getevent(&ev))
	{
		if (ev.type != EV_PRESS && ev.type != EV_RELEASE)
			continue;
		st = (ev.type != EV_RELEASE);
		rc_dokey(ev.code, st);
	}
*/
}

void emu_tick()
{

    cpu_emulate(2280);
	while (R_LY > 0 && R_LY < 144)
		emu_step();
	
	vid_end();
	rtc_tick();
	sound_mix();
/*
	if (!pcm_submit())
	{
		delay = framelen - sys_elapsed(timer);
		sys_sleep(delay);
		sys_elapsed(timer);
	}
*/
	pcm_submit();
	doevents();
	vid_begin();
	if (!(R_LCDC & 0x80))
		cpu_emulate(32832);
	
	while (R_LY > 0) /* wait for next frame */
		emu_step();
}








