#ifndef __STDFNC__
#define __STDFNC__

#include <stdio.h>

#ifndef ZeroMemory
#define ZeroMemory(_AA,_BB)     memset(_AA,0,_BB)
#endif

#define fopen(_AA,_BB)          ppp_fopen(_AA,_BB)
#define fclose(_AA)             ppp_fclose(_AA)
#define fread(_AA,_BB,_CC,_DD)  ppp_fread(_AA,_BB,_CC,_DD)
#define fwrite(_AA,_BB,_CC,_DD) ppp_fwrite(_AA,_BB,_CC,_DD)
#define fseek(_AA,_BB,_CC)      ppp_fseek(_AA,_BB,_CC)
#define rewind(_AA)             ppp_rewind(_AA)
#define fgetc(_AA)              ppp_fgetc(_AA)
#define fgets(_AA,_BB,_CC)      ppp_fgets(_AA,_BB,_CC)
#define fputc(_AA,_BB)          ppp_fputc(_AA,_BB)
#define feof(_AA)               ppp_feof(_AA)
#define ferror(_AA)             ppp_ferror(_AA)
#define ftell(_AA)              ppp_ftell(_AA)
#define fscanf                  ppp_fscanf
#define fprintf                 ppp_fprintf
#define calloc(_AA,_BB)         ppp_calloc(_AA,_BB)
#define strrchr(_AA,_BB)        ppp_strrchr(_AA,_BB)
#define atoi(_AA)               ppp_atoi(_AA)
#ifndef islower
#define islower(_AA)            ppp_islower(_AA)
#endif
#ifndef isupper
#define isupper(_AA)            ppp_isupper(_AA)
#endif
#ifndef isdigit
#define isdigit(_AA)            ppp_isdigit(_AA)
#endif
#ifndef isalpha
#define isalpha(_AA)            ppp_isalpha(_AA)
#endif
#ifndef isgraph
#define isgraph(_AA)            ppp_isgraph(_AA)
#endif
#ifndef isalnum
#define isalnum(_AA)            ppp_isalnum(_AA)
#endif

#define _stricmp(_AA,_BB)       ppp_stricmp(_AA,_BB)
#define strcasecmp(_AA,_BB)     ppp_strcasecmp(_AA,_BB)

#ifndef time
#define time(_AA)               ppp_time(_AA)
#endif
#ifndef strdup
#define strdup(_AA)             ppp_strdup(_AA)
#endif
#ifndef _strlwr
#define _strlwr(_AA)            ppp_strlwr(_AA)
#endif
#ifndef strpbrk
#define strpbrk(_AA,_BB)        ppp_strpbrk(_AA,_BB)
#endif
#ifndef _vprintf
#define _vprintf(_AA,_BB)       ppp_vprintf(_AA,_BB)
#endif
#ifndef printf
#define printf                  ppp_printf
#endif


void   DEBUGLOG(char *,...);
void   LOG( char * str , ... );

FILE * ppp_fopen( const char * , const char * );
int    ppp_fclose( FILE * );
size_t ppp_fread( void * , size_t , size_t , FILE * );
size_t ppp_fwrite( const void * , size_t , size_t , FILE * );
int    ppp_fseek( FILE * , long , int );
int    ppp_rewind( FILE *stream );

int    ppp_fscanf(FILE *, const char *, ...);
int    ppp_fprintf(FILE *, const char *, ...);
int    ppp_fgetc( FILE * );
int    ppp_fputc( int , FILE * );
char * ppp_fgets( char * , int , FILE * );
int    ppp_feof( FILE * );
int    ppp_ferror( FILE * );
int    ppp_ftell( FILE * );
int    ppp_GetFileSize( FILE * );

void * ppp_calloc( size_t num, size_t siz);
char * ppp_strrchr(const char * buf, int chr);
int    ppp_atoi(const char *s);
int    ppp_islower(int a );
int    ppp_upper(int a );
int    ppp_isdigit(int a );
int    ppp_isalpha(int a );
int    ppp_isgraph(int a );
int    ppp_isalnum( int a );

int    ppp_stricmp(char *, char *);
int    ppp_strcasecmp(const char *a, const char *b);

time_t ppp_time(time_t* t);
char * ppp_strdup(const char *src);
char * ppp_strlwr( char * a );
char * ppp_strpbrk(char * line, char * str );
int    ppp_vprintf(const char *fmt, va_list ap);
int    ppp_printf(const char *fmt, ...);

#endif
