#include <windows.h>

#include "defs.h"
#include "pcm.h"
#include "rc.h"

void die(char *fmt, ...);
void DEBUGLOG( char * str , ... );

#define N_BUFS 8
//#define BUF_SIZ 768
#define BUF_SIZ 512

struct pcm pcm;

int sound = 1;
int stereo = 1;
int samplerate = 44100 / 2;
int samplebit = 8;
int wavbufsiz = BUF_SIZ;


rcvar_t pcm_exports[] =
{
	RCV_BOOL("sound", &sound),
	RCV_INT("stereo", &stereo),
	RCV_INT("samplerate", &samplerate),
//	RCV_INT("samplebit", &samplebit),
	RCV_INT("wavbufsiz", &wavbufsiz),
	RCV_END
};


static HANDLE semaph;
static HWAVEOUT wout;
static byte *buf;
static WAVEHDR hdr[N_BUFS];
static int curbuf;

static void CALLBACK woutcallback(HANDLE wout, UINT msg,
								  DWORD user, DWORD dw1, DWORD dw2)
{
//	if (msg == WOM_DONE)
//		ReleaseSemaphore((HANDLE) user, 1, NULL);
}

void pcm_init()
{
	WAVEFORMATEX format;
	int i;

	if (!sound) {
		pcm.hz = 11025;
		pcm.len = 4096;
		buf = (byte *) malloc(pcm.len);
		pcm.buf = buf;
		pcm.pos = 0;
	}

//	semaph = CreateSemaphore(NULL, N_BUFS, N_BUFS, NULL);

	format.wFormatTag = WAVE_FORMAT_PCM;
	format.nChannels = stereo ? 2 : 1;
	format.nSamplesPerSec = samplerate;
	format.wBitsPerSample = 8;
	format.nBlockAlign = format.nChannels * format.wBitsPerSample / 8; 
	format.nAvgBytesPerSec = format.nSamplesPerSec * format.nBlockAlign;
	format.cbSize = 0;
	Sleep(1000);
/*	if (waveOutOpen(&wout, WAVE_MAPPER, &format,
					(DWORD) woutcallback, NULL , CALLBACK_FUNCTION)
		!= MMSYSERR_NOERROR)
		die("cannot open wave out device\n");
*/
	if (waveOutOpen(&wout, WAVE_MAPPER, &format,
					(DWORD) 0, (DWORD) 0, CALLBACK_NULL)
		!= MMSYSERR_NOERROR)
		die("cannot open wave out device\n");

	waveOutSetVolume(wout, 0xFFFF );

	pcm.stereo = stereo;
	pcm.hz = samplerate;
	pcm.len = wavbufsiz;
	buf = (byte *) malloc(pcm.len * N_BUFS);
	pcm.buf = buf;
	pcm.pos = 0;

	for (i = 0; i < N_BUFS; i++) {
		hdr[i].lpData = (LPSTR) (buf + pcm.len * i);
		hdr[i].dwBufferLength = pcm.len;
		hdr[i].dwBytesRecorded = 0;
		hdr[i].dwUser = 0;
		hdr[i].dwFlags = 0;
		hdr[i].dwLoops = 0;
		hdr[i].lpNext = NULL;
		hdr[i].reserved = 0;
		waveOutPrepareHeader(wout, &hdr[i], sizeof WAVEHDR);
	}

	curbuf = 0;
}

void pcm_close()
{
	int i;
	DEBUGLOG( "pcm_close start\n" );

	waveOutReset(wout);
	for (i = 0; i < N_BUFS; i++)
		waveOutUnprepareHeader(wout, &hdr[i], sizeof WAVEHDR);
	waveOutClose(wout);

	if (buf) free(buf);
	memset(&pcm, 0, sizeof pcm);

	DEBUGLOG( "pcm_close end\n" );
}

int pcm_submit()
{
	if (!sound || !wout) {
		pcm.pos = 0;
		return 0;
	}

	if (pcm.pos >= pcm.len) {
		waveOutWrite(wout, &hdr[curbuf], sizeof WAVEHDR);
		
		curbuf = (curbuf + 1) % N_BUFS;
		pcm.buf = buf + pcm.len * curbuf;
		pcm.pos = pcm.pos - pcm.len;
//		WaitForSingleObject(semaph, INFINITE);
	}

	return 1;
}

void pcm_pause()
{
	waveOutPause(wout);
}

void pcm_restart()
{
	waveOutRestart(wout);
}