

#ifndef __LOADER_H__
#define __LOADER_H__


typedef struct loader_s
{
	char *rom;
	char *base;
	char *sram;
	char *state;
	int ramloaded;
} loader_t;


extern loader_t loader;

extern char *savedir;
extern char *statedir;
extern int saveslot;
extern int forcebatt;
extern int nobatt;
extern int forcedmg;
extern int gbamode;
extern int memfill;
extern int memrand;

void loader_init(char *s);
void loader_unload();
int rom_load();
int sram_load();
int sram_save();
void state_save(int n);
void state_load(int n);

#endif


