#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <commctrl.h>
#include <commdlg.h>

#include "resource.h"

#include "defs.h"
#include "emu.h"
#include "cpuregs.h"
#include "debug.h"
#include "regs.h"
#include "lcd.h"

#include "sys_gfx.h"
#include "sys_sound.h"
#include "sys_winCE.h"
#include "sys_setting.h"
#include "sys_debug.h"

#define STR_LEN 256

TCHAR * IOSTR[256] = { 
//00H
_T("P1    "),_T("SB    "),_T("SC    "),_T("      "),_T("DIV   "),_T("TIMA  "),_T("TMA   "),_T("TAC   "),
_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("IF    "),
//10H
_T("NR 10 "),_T("NR 11 "),_T("NR 12 "),_T("NR 13 "),_T("NR 14 "),_T("      "),_T("NR 21 "),_T("NR 22 "),
_T("NR 23 "),_T("NR 24 "),_T("NR 30 "),_T("NR 31 "),_T("NR 32 "),_T("NR 33 "),_T("NR 34 "),_T("      "),
//20H
_T("NR 41 "),_T("NR 42 "),_T("NR 43 "),_T("NR 44 "),_T("NR 50 "),_T("NR 51 "),_T("NR 52 "),_T("      "),
_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),
//30H
_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),
_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),
//40H
_T("LCDC  "),_T("STAT  "),_T("SCY   "),_T("SCX   "),_T("LY    "),_T("LYC   "),_T("DMA   "),_T("BGP   "),
_T("OBP0  "),_T("OBP1  "),_T("WY    "),_T("WX    "),_T("      "),_T("KEY1  "),_T("      "),_T("VBK   "),
//50H
_T("      "),_T("HDMA1 "),_T("HDMA2 "),_T("HDMA3 "),_T("HDMA4 "),_T("HDMA5 "),_T("RP    "),_T("      "),
_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),
//60H
_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),
_T("BCPS  "),_T("BCPD  "),_T("OCPS  "),_T("OCPD  "),_T("      "),_T("      "),_T("      "),_T("      "),
//70H
_T("SVBK  "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),
_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),_T("      "),
//80H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
//90H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
//A0H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
//B0H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
//C0H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
//D0H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
//E0H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
//F0H
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),
_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("STACK "),_T("IE    ")
};

HWND g_dlg;
int ViewBGType = 0;

void dump(void)
{
	int i,j;
	TCHAR wbuf[4096*71];
	TCHAR w[71];
	w[0]=wbuf[0]=0;
	for(i=0;i<4096;i++){
		j = i*16;
		wsprintf( w,_T("%04X:%02X %02X %02X %02X %02X %02X %02X %02X-%02X %02X %02X %02X %02X %02X %02X %02X\r\n"),
						  i*16,mem_read(j++),mem_read(j++),mem_read(j++),mem_read(j++),
						       mem_read(j++),mem_read(j++),mem_read(j++),mem_read(j++),
							   mem_read(j++),mem_read(j++),mem_read(j++),mem_read(j++),
							   mem_read(j++),mem_read(j++),mem_read(j++),mem_read(j++) ); 
		wcscat( wbuf,w );
	}
	SetWindowText(GetDlgItem(g_dlg,IDC_DUMP), wbuf);
}

void disasm(void)
{
	char buf[1024];
	TCHAR wbuf[1024];
	debug_disassemble( PC,22,buf );
//	mbstowcs(wbuf,buf,1024);
	MultiByteToWideChar(932,0,buf,-1,wbuf,1024 );   
	SetWindowText(GetDlgItem(g_dlg,IDC_DISASM), wbuf);
}

void viewreg(void)
{
	char buf[1024];
	TCHAR wbuf[1024];
	disp_reg( buf );
	MultiByteToWideChar(932,0,buf,-1,wbuf,1024 );   
	SetWindowText(GetDlgItem(g_dlg,IDC_REGLIST), wbuf);
}

void viewIO(void)
{
	int i;
	TCHAR wbuf[8192];
	TCHAR w[64];
	w[0]=wbuf[0]=0;
	for(i=0;i<256;i++){
		wsprintf( w,_T("%04X:%6s:%02X\r\n"),0xFF00+i,IOSTR[i],REG(i) ); 
		wcscat( wbuf,w );
	}
	SetWindowText(GetDlgItem(g_dlg,IDC_IOLIST), wbuf);
}

void viewBG(HWND wnd)
{
	int x, y,j,i,c,cnt=0;
	HDC dc = GetDC(GetDlgItem(wnd, IDC_BG));	
	byte *vram = lcd.vbank[0];
	byte *attr = lcd.vbank[1];

	switch(ViewBGType){
		case 0:
			for(y=0;y<24;y++){
				for(x=0;x<16;x++){
					for(j=0;j<8;j++){
						for(i=7;i>=0;i--){
							c = vram[cnt++] & (1<<i) ? 1 : 0;
							c |= vram[cnt++] & (1<<i) ? 2 : 0;
							SetPixel(dc,x*8+(7-i),y*8+j,c*500);
						}
					}
				}
			}
		case 1:
		case 2:
		case 3:
			break;
	}
	ReleaseDC(wnd,dc);
}


LRESULT CALLBACK debugproc(HWND dlg, UINT message, WPARAM wpar, LPARAM lpar)
{
#ifdef POCKETPC
	SHINITDLGINFO info;
#endif
	PAINTSTRUCT ps;
	HDC hdc;

	char version[STR_LEN];
	wchar_t version2[STR_LEN];

	switch (message) {
	case WM_INITDIALOG:
		SendMessage(GetDlgItem(dlg, IDC_RDGB1),BM_SETCHECK,1,0);
		SetDlgItemInt(dlg, IDC_STEPCNT, 1, false );
/*
		sprintf(version, "Version %s", VERSION);
		mbstowcs(version2, version, strlen(version) + 1);
		SetWindowText(GetDlgItem(dlg, IDC_VERSION), version2);
*/
		g_dlg = dlg;
//		disasm();
//		viewreg();
		return 1; 
	case WM_COMMAND:
		switch (LOWORD(wpar)) {
		case IDCANCEL :
			EndDialog(dlg, LOWORD(wpar));
			debug_trace = 0;
			return 1;
		case IDC_DBG_NEXT :
			{
				BOOL res;
				step_count = GetDlgItemInt(dlg, IDC_STEPCNT, &res, false );
				if( !res ) step_count = 1;
			}
			InvalidateRect( dlg, NULL, false );
			break;
		case IDC_DBG_EXEC :
			step_count = -1;
			break;
		case IDC_DBG_STOP :
			step_count = 0;
			InvalidateRect( dlg, NULL, false );
			break;
		case IDC_RDGB1:
		case IDC_RDGB2:
		case IDC_RDPAT1:
		case IDC_RDPAT2:
		case IDC_RDSPR:
			ViewBGType = LOWORD(wpar) - IDC_RDGB1;
			InvalidateRect( dlg, NULL, false );
			break;
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(dlg, &ps);
		disasm();
		viewreg();
		viewIO();
//		dump();
		viewBG(dlg);		
		EndPaint(dlg, &ps);
		break;
	}

    return 0;
}
