#include <windows.h>
#include <tchar.h>
#ifdef POCKETPC
#include <gx.h>
#endif
#include "defs.h"
#include "fb.h"
#include "lcd.h"
#include "hw.h"
#include "debug.h"
#include "keymap.h"
#include "rc.h"
#include "input.h"

#include "sys_gfx.h"
#include "sys_winCE.h"
#include "stdfnc.h"

void joy_init();
void joy_close();
void joy_poll();

#define landscapemode(screenmode) (screenmode & 0x1)

void create_video_buffer();
void DebugPrint( int x, int y,wchar_t * buf );
void ScrollDebugPrint( int x,int w, wchar_t * buf );

static void paint240x216(word *vram, int landscape);
static void paint240x216s(word *vram, int landscape);
static void paint320x216();
//extern int scale;
//extern int density;

/*
 * process graphics
 */

int screenmode = 0;
int frameskip = 3;

int scr_x[5] = { 160,120, 80, 80, 0 };
int scr_y[5] = { 232,194,184,160,64 };

struct fb fb;

static int initok = 0;

keys joy_code[256] = { 
	{0x26,PAD_UP	},
	{0x28,PAD_DOWN	},
	{0x25,PAD_LEFT	},
	{0x27,PAD_RIGHT	},
	{0xC1,PAD_A		},
	{0xC2,PAD_B		},
	{0xC3,PAD_START	},
	{0xC4,PAD_SELECT},
	{0x00,0x00      }
 };

void vid_preinit()
{
//	GXOpenDisplay( getSelfHWND(), GX_FULLSCREEN );
}

HBITMAP	fb_hbitmap;
HANDLE	fb_hDIB;

void setfb(int scr)
{
//	char buf[128];
	int fbw[5] = {160,160,320,320,480};
	int fbh[5] = {144,144,288,288,432};
	int scl[5] = {  1,  1,  2,  2,  3};
	int pth[5] = {960,960,960,960,960};
	int den[5] = {  1,  1,  2,  2,  3};

	fb.pelsize = 2;
	fb.w  = fbw[scr];
	fb.h  = fbh[scr];
	fb.pitch = pth[scr];
//	sprintf( buf, "set scale %d",scl[scr] );
//	rc_command( buf );
	scale = scl[scr];	
//	sprintf( buf, "set density %d",den[scr] );
//	rc_command( buf );
	density = den[scr];
}


void vid_init()
{

	BITMAPINFOHEADER bi;
	BITMAPINFOHEADER * lpbi;
	DWORD * lpQuad;
	word * vram;

	if (initok) return;
	
	joy_init();

	setfb(screenmode);
	fb.indexed = 0;
	fb.cc[0].r = 3;
	fb.cc[0].l = 11;
	fb.cc[1].r = 2;
	fb.cc[1].l = 5;
	fb.cc[2].r = 3;
	fb.cc[2].l = 0;
	fb.cc[3].r = 0;
	fb.cc[3].l = 0;
	fb.yuv = 0;
	fb.dirty = 0;
	fb.enabled = 1;
	
	bi.biSize			= sizeof( BITMAPINFOHEADER );
	bi.biWidth			= 480;
	bi.biHeight			= -432;
	bi.biPlanes			= 1;
	bi.biBitCount		= 16;
	bi.biCompression	= BI_BITFIELDS;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

#if _WIN32_WCE >= 300
	fb_hDIB = GlobalAlloc( GHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)GlobalLock( fb_hDIB );
#else
	fb_hDIB = LocalAlloc( LHND, sizeof(BITMAPINFOHEADER) + 3 * sizeof(RGBQUAD) ); 
	lpbi = (BITMAPINFOHEADER *)LocalLock( fb_hDIB );
#endif
	*lpbi = bi;

	lpQuad = (DWORD*)&((LPBITMAPINFO)lpbi)->bmiColors[0];
	lpQuad[0]=0xF800;
	lpQuad[1]=0x07E0;
	lpQuad[2]=0x001F;

	fb_hbitmap = CreateDIBSection( NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS, (void**)&vram, NULL, 0 );

#if _WIN32_WCE >= 300
	GlobalUnlock( fb_hDIB );
	GlobalFree( fb_hDIB );
#else
	LocalUnlock( fb_hDIB );
	LocalFree( fb_hDIB );
#endif

	if (vram == NULL)
		die("CreateDIBSection failed\n");

	fb.ptr =(unsigned char *) vram;

	initok = 1;
}

void vid_close()
{
	DEBUGLOG( "vid_close start\n" );
	if (!initok) return;

	DeleteObject( fb_hbitmap );

	joy_close();

//	GXCloseDisplay();

	initok = 0;
	DEBUGLOG( "vid_close end\n" );
}

void vid_settitle(char *title)
{
	int len;
	wchar_t *title2;

	len = strlen(title);
	title2 = (wchar_t *) malloc(sizeof(wchar_t) * (len + 1));
	mbstowcs(title2, title, len + 1);
	SetWindowText(g_wnd, title2);
	free(title2);
}

void vid_setpal(int i, int r, int g, int b)
{
}

void vid_begin()
{
	static int skip = 0;
	skip = (skip + 1) % (frameskip > 0 ? frameskip + 1 : 1);
    fb.enabled = skip == 0;
	setfb(screenmode);
}

void vid_end()
{
	HDC	hDC;
	HDC	hbDC;
	if (!fb.enabled) return;
	hDC = GetDC(g_wnd);
	hbDC = CreateCompatibleDC(hDC);
	SelectObject( hbDC, fb_hbitmap );
	int s = screenmode;
	switch (s) {
		case 0: BitBlt    ( hDC, scr_x[s],scr_y[s], 160, 144, hbDC,0,0,        SRCCOPY ); break;
		case 1: StretchBlt( hDC, scr_x[s],scr_y[s], 240, 216, hbDC,0,0,160,144,SRCCOPY ); break;
		case 2: StretchBlt( hDC, scr_x[s],scr_y[s], 320, 240, hbDC,0,0,320,288,SRCCOPY ); break;
		case 3: BitBlt    ( hDC, scr_x[s],scr_y[s], 320, 288, hbDC,0,0,        SRCCOPY ); break;
		case 4: BitBlt    ( hDC, scr_x[s],scr_y[s], 480, 432, hbDC,0,0,        SRCCOPY ); break;
	}
	ReleaseDC( g_wnd, hDC );
	DeleteDC( hbDC );
}

void vid_setscreenmode(int mode)
{
	screenmode = mode;
}

void vid_setframeskip(int skip)
{
	frameskip = skip;
}
#if 0
static void paint160x144(word *vram, int landscape)
{
	word *fbptr;
	word *pixel;
//	int x;
	int y;

	pixel = vram;
	fbptr = (word *) fb.ptr;
/*
	for (y = 0; y < 144; y++) {
		for (x = 0; x < 160; x++) {
			*pixel++ = *fbptr++;
		}
		pixel+=80;
		fbptr++;
	}
*/
	for(y = 0; y < 144; y++ ) {
		memcpy( pixel, fbptr , 160*2 );
		pixel+=240;
		fbptr+=161;
	}
}

static void paint240x216(word *vram, int landscape)
{
	word *fbptr,*fbptr1,*fbptr2;
//	int fbpitch;
	word *line1,*line2,*line3,*pixel;
	int x, y;
//	word *p;

	pixel = vram;
	fbptr = (word *) fb.ptr;

/*
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;
		}
		pixel+=720;
		fbptr+=322;
	}
*/
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			// line1
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;
			// line2
			*line2++ = *fbptr2++;
			*line2++ = *fbptr2;
			*line2++ = *fbptr2++;
		}
		// line3
		memcpy( line3,pixel+240, 240*2 );
		pixel+=720;
		fbptr+=322;
	}
}

static void paint240x216s(word *vram, int landscape)
{
	word *fbptr,*fbptr1,*fbptr2;
//	int fbpitch;
	word *line1,*line2,*line3,*pixel;
	int x, y;
//	word *p;

	pixel = vram;
	fbptr = (word *) fb.ptr;

/*
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2;

			*line2++ = *fbptr2;
			*line3++ = *fbptr2++;
		}
		pixel+=720;
		fbptr+=322;
	}
*/
	for (y = 0; y < 72; y++) {
		line1 = pixel;
		line2 = pixel+240;
		line3 = pixel+480;
		fbptr1= fbptr;
		fbptr2= fbptr + 161;
		for (x = 0; x < 80; x++) {
			// line1
			*line1++ = *fbptr1++;
			*line1++ = *fbptr1;
			*line1++ = *fbptr1++;
			// line2
			*line2++ = *fbptr2++;
			*line2++ = *fbptr2;
			*line2++ = *fbptr2++;
		}
		// line3
//		memcpy( line3,pixel+240, 240*2 );
		pixel+=720;
		fbptr+=322;
	}
}
#endif
void vid_suspend()
{
//	GXSuspend();
}

void vid_resume()
{
//	GXResume();
}

/*
 * process hardware keys
 */

void joy_init()
{

//	setkeymap();
/*
	if (!joy_code[0]) {
		joy_code[0] = 0x26;	// UP
		joy_code[1] = 0x28;	// DOWN
		joy_code[2] = 0x25;	// LEFT
		joy_code[3] = 0x27;	// RIGHT
		joy_code[4] = 0xC1;	// X     ... A Button
		joy_code[5] = 0xC2;	// Z     ... B Button
		joy_code[6] = 0xC3;	// S     ... Start
		joy_code[7] = 0xC4; // A     ... C ?
		joy_code[8] = 0x1B; // ESC
	}
*/
}

int check_key( int num )
{
    return ( GetAsyncKeyState(num)&0x8000 ); 
}
 
void joy_poll()
{
	int i;
//	int num = soft_pad;
	int num = 0;
	for( i =0;joy_code[i].code!=0x00;i++ ){
		if( check_key( joy_code[i].code ) ){
			num |= joy_code[i].pad;
		}		
	}
	pad_set(num);
}

void joy_close()
{
//	GXCloseInput();
}



void DebugPrint( int x, int y,wchar_t * buf )
{
	HDC		hdc;
	RECT	rect;
	hdc = GetDC(g_wnd);

	SetBkColor(hdc, RGB(0, 0, 0));
	SetTextColor(hdc, RGB(255, 255, 255));
	GetClientRect(g_wnd, &rect);
	rect.left = x;
	rect.top  = y;
	DrawText(hdc, buf, _tcslen(buf), &rect, DT_SINGLELINE | DT_TOP | DT_LEFT);

	ReleaseDC( g_wnd, hdc );
}

void ScrollDebugPrint( int x,int w, wchar_t * buf )
{
	HDC		hdc;
	hdc = GetDC(g_wnd);
	BitBlt( hdc, x, 0, w, 240, hdc,x,15,SRCCOPY ); 
	ReleaseDC( g_wnd, hdc );
	DebugPrint( x,225, buf );
}
