#include <windows.h>
#include <string.h>

#include "loader.h"
#include "emu.h"
#include "lcd.h"
#include "rtc.h"
#include "debug.h"
#include "sound.h"
#include "pcm.h"
#include "getromname.h"
#include "sys_gfx.h"
#include "sys_sound.h"
#include "sys_wince.h"

/*************************************************************/
/*************************************************************/
void CheckBool( char * key, char * buf, int * flg )
{
	if( !strncmp(key,buf,10) ){
		if( buf[11] == 't' || buf[11] == 'T' ) *flg = TRUE;
										else   *flg = FALSE;
	}
}
void CheckInt( char * key, char * buf, int * flg )
{
	if( !strncmp(key,buf,10) )	*flg =  atoi( &buf[11] );
}
void CheckByte( char * key, char * buf, unsigned char * flg )
{
	if( !strncmp(key,buf,10) )	*flg =  atoi( &buf[11] );
}
void CheckStr( char * key, char * buf, char ** str )
{
	if( !strncmp(key,buf,10) ){
		if( strlen(&buf[11])!=0 ){
			*str = _strdup( &buf[11] );
		}
	}
}
void CheckIntD( char * key, char * buf, int * num, int cnt )
{
	char seps[]   = " ,\t\n";
	char * tok;
	int i;
	if( !strncmp(key,buf,10) ){
		tok = strtok( &buf[11], seps );
		for(i=0;i<cnt;i++){
			if( tok != NULL ){
				num[i] =  atoi( tok );
			}else{
				num[i] = 0;
			}
			tok = strtok( NULL, seps );
		}
	}
}
/*************************************************************/
/*************************************************************/
void load_setting()
{
	FILE * fp;
	char buf[256];
	char * bp;
	char cod[32];

	strcpy(buf, GetModuleName());
	ChangeFileExt(buf,".cfg");

	fp = fopen( buf,"r" );
	if( fp == NULL ) return;
	while( fgets(buf,255,fp) ){
	    if ((bp = strchr( buf, '\r' )) != NULL ) *bp = '\0';
	    if ((bp = strchr( buf, '\n' )) != NULL ) *bp = '\0';
		// loader
		CheckStr ( "SAVEDIR   ",buf,&savedir  );
		CheckStr ( "STATEDIR  ",buf,&statedir );
		CheckInt ( "SAVESLOT  ",buf,&saveslot );
		CheckBool( "FORCEBATT ",buf,&forcebatt);
		CheckBool( "NOBATT    ",buf,&nobatt   );
		CheckBool( "FORCEDMG  ",buf,&forcedmg );
		CheckBool( "GBAMODE   ",buf,&gbamode  );
		CheckInt ( "MEMFILL   ",buf,&memfill  );
		CheckInt ( "MEMRAND   ",buf,&memrand  );
		// emu
		CheckInt ( "FRAMELEN  ",buf,&framelen );
		// LCD
		CheckInt ( "SCALE     ",buf,&scale    );
		CheckInt ( "DENSITY   ",buf,&density  );
		CheckBool( "RGB332    ",buf,&rgb332   );
		CheckIntD( "DMG_BGP   ",buf,dmg_pal[0],4);
		CheckIntD( "DMG_WNDP  ",buf,dmg_pal[1],4);
		CheckIntD( "DMG_OBP0  ",buf,dmg_pal[2],4);
		CheckIntD( "DMG_OBP1  ",buf,dmg_pal[3],4);
		CheckBool( "SPRSORT   ",buf,&sprsort);
		CheckBool( "SPRDEBUG  ",buf,&sprdebug);
		CheckBool( "COLORFILTR",buf,&usefilter);
		CheckBool( "FILTERDMG ",buf,&filterdmg);
		CheckIntD( "RED       ",buf,filter[0],4);
		CheckIntD( "GREEN     ",buf,filter[1],4);
		CheckIntD( "BLUE      ",buf,filter[2],4);
		// rtc
		CheckBool( "SYNCRTC   ",buf,&syncrtc);
		// debug
		CheckBool( "TRACE     ",buf,&debug_trace);
		// sound
		// video
		CheckInt ( "SCREENMODE",buf,&screenmode);
		CheckInt ( "FRAMESKIP ",buf,&frameskip);
		CheckIntD( "SCR_X     ",buf,scr_x,5 );
		CheckIntD( "SCR_Y     ",buf,scr_y,5 );
		// joy
		int i;
		for(i=0;i<256;i++){
			sprintf (cod,"JOYCODE%03d",i);
			CheckInt(cod,buf,&(joy_code[i].code));
			sprintf (cod,"JOY_PAD%03d",i);
			CheckInt(cod,buf,(int*)&(joy_code[i].pad) );
		}
		// pcm
		CheckBool( "SOUND     ",buf,&sound);
		CheckInt ( "STEREO    ",buf,&stereo);
		CheckInt ( "SAMPLERATE",buf,&samplerate);
		CheckInt ( "SAMPLEBIT ",buf,&samplebit);
		CheckInt ( "WAVBUFSIZ ",buf,&wavbufsiz);
		// wce
		CheckStr ( "SKINDIR   ",buf,&skindir  );
		CheckStr ( "ROMDIR    ",buf,&romdir   );
    }
    fclose(fp);
}

#define WriteStr( NAME, BUF )		\
	fprintf( fp,"%s=",NAME );				\
	if( (BUF)!=NULL ) fprintf( fp,"%s",BUF );	\
	fprintf( fp,"\n" )

#define WriteBool( NAME, FLG )		\
	fprintf( fp,"%s=",NAME );				\
	fprintf( fp,"%s\n",((FLG) ?"True":"False") )

#define WriteInt( NAME, NUM )		\
	fprintf( fp,"%s=",NAME );				\
	fprintf( fp,"%d\n",(NUM) )

#define WriteIntD( NAME, NUM, CNT )		\
	fprintf( fp,"%s=",NAME );			\
	for(i=0;i<(CNT);i++){				\
		if(i!=0) fprintf( fp,"," );		\
		fprintf( fp,"%d",(NUM[i]) );	\
	}									\
	fprintf( fp,"\n" )

/*************************************************************/
/*************************************************************/
void save_setting()
{
	FILE * fp;
	char buf[256];
	int i;
	char  cod[32];
	strcpy(buf, GetModuleName());
	ChangeFileExt(buf,".cfg");
    
	fp = fopen( buf,"w" );
	WriteStr ( "SAVEDIR   ",savedir  );
	WriteStr ( "STATEDIR  ",statedir );
	WriteInt ( "SAVESLOT  ",saveslot );
	WriteBool( "FORCEBATT ",forcebatt);
	WriteBool( "NOBATT    ",nobatt   );
	WriteBool( "FORCEDMG  ",forcedmg );
	WriteBool( "GBAMODE   ",gbamode  );
	WriteInt ( "MEMFILL   ",memfill  );
	WriteInt ( "MEMRAND   ",memrand   );
	// emu
	WriteInt ( "FRAMELEN  ",framelen );
	// LCD
	WriteInt ( "SCALE     ",scale    );
	WriteInt ( "DENSITY   ",density  );
	WriteBool( "RGB332    ",rgb332   );
	WriteIntD( "DMG_BGP   ",dmg_pal[0],4);
	WriteIntD( "DMG_WNDP  ",dmg_pal[1],4);
	WriteIntD( "DMG_OBP0  ",dmg_pal[2],4);
	WriteIntD( "DMG_OBP1  ",dmg_pal[3],4);
	WriteBool( "SPRSORT   ",sprsort);
	WriteBool( "SPRDEBUG  ",sprdebug);
	WriteBool( "COLORFILTR",usefilter);
	WriteBool( "FILTERDMG ",filterdmg);
	WriteIntD( "RED       ",filter[0],4);
	WriteIntD( "GREEN     ",filter[1],4);
	WriteIntD( "BLUE      ",filter[2],4);
	// rtc
	WriteBool( "SYNCRTC   ",syncrtc);
	// debug
	WriteBool( "TRACE     ",debug_trace);
	// sound
	// video
	WriteInt ( "SCREENMODE",screenmode);
	WriteInt ( "FRAMESKIP ",frameskip);
	WriteIntD( "SCR_X     ",scr_x,5 );
	WriteIntD( "SCR_Y     ",scr_y,5 );
	// joy
	for(i=0;i<256;i++){
		if( joy_code[i].code == 0 ) break;
		sprintf( cod,"JOYCODE%03d",i);
		WriteInt(cod, joy_code[i].code);
		sprintf( cod,"JOY_PAD%03d",i);
		WriteInt(cod, joy_code[i].pad);
	}
	// pcm
	WriteBool( "SOUND     ",sound);
	WriteInt ( "STEREO    ",stereo);
	WriteInt ( "SAMPLERATE",samplerate);
	WriteInt ( "SAMPLEBIT ",samplebit);
	WriteInt ( "WAVBUFSIZ ",wavbufsiz);
	// wce
	WriteStr ( "SKINDIR   ",skindir  );
	WriteStr ( "ROMDIR    ",romdir   );
    fclose(fp);
}
