#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#define PROFILE_MAX 32

typedef struct tag_PROFILE {
	char * name;
	long time;
	long cnt;
	long tick;
	int  flag;
} PROFILE;

PROFILE pf[PROFILE_MAX];

void Profile_Init()
{
	int i;
	for(i=0;i<PROFILE_MAX;i++){
		if( !pf[i].name ) free( pf[i].name );
		pf[i].name = 0;
		pf[i].time = 0;
		pf[i].cnt  = 0;
		pf[i].tick = 0;
		pf[i].flag = -1;
	}
}

void Profile( char * pfname )
{
	int cnt=-1;
	int i;

	for(i=0;i<PROFILE_MAX;i++){
		if( pf[i].flag == -1 ) break;
		if( strcmp( pf[i].name, pfname )==0 ){
			cnt = i;
			break;
		}
	}
	if( cnt == -1 ){
		cnt = i;
		pf[cnt].name = strdup( pfname );
		pf[cnt].flag = 0;
	}

	if( pf[cnt].flag == 0 ){
		pf[cnt].cnt  ++;
		pf[cnt].tick = GetTickCount();
		pf[cnt].flag = 1;
	}else{
		pf[cnt].time += GetTickCount() - pf[cnt].tick;
		pf[cnt].flag = 0;
	}
}

void Profile_Output()
{
	int i;
	int noend = false; 
	FILE * fp = fopen( "c:\\Profile.log","w" );

	if( fp == NULL ) return;

	for(i=0;i<PROFILE_MAX;i++){
		noend = false; 
		if( pf[i].flag == -1 ) break;
		if( pf[i].flag == 1 ) noend = true;

		fprintf(fp,"NAME[%20s] TIME[%10d] COUNT[%10d] %s\n" ,
			pf[i].name, pf[i].time, pf[i].cnt, (noend?"NO END":"") );
	}
	fclose(fp);
}

