#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <tchar.h>

#include "stdfnc.h"
#include "sys_winCE.h"
#include "rc.h"

#include "getromname.h"

static char ProgDir[256];

char * GetModuleName(void)
{
    TCHAR cmd[512];
//    char * bufptr;
    int ret;

    ret = GetModuleFileName(g_inst,cmd,256);
    ret = wcstombs(ProgDir,cmd,256); 
//    if ((bufptr=strrchr( ProgDir, '\\' )) != NULL )*bufptr = '\0';
    return ProgDir;
}

static char FullPath[256];
char * GetFullPath( char * path )
{
	if( path == NULL ){
		strncpy( FullPath, ExtractFilePath(GetModuleName()), 256 );
	}else if( path[0] == '\\' ){
		strncpy( FullPath, path, 256 ); 
	}else{
		sprintf( FullPath, "%s\\%s", ExtractFilePath(GetModuleName()), path );
	}
	return FullPath;
}

char * ExtractFilePath(char * fname )
{
	char * bp;
    if ((bp = strrchr( fname, '\\' )) != NULL ) *bp = '\0';
	return fname;
}

char * ChangeFileExt(char * fname, char * ext)
{
	char * bp;
    if ((bp = strrchr( fname, '.' )) != NULL ) *bp = '\0';
	if ( ext != NULL ){
		strcat( fname, ext );
	}
	return fname;
}

char * ExtractFileName( char * fname )
{
	char * bp;
    if ((bp = strrchr( fname, '\\' )) != NULL ){
		return bp + 1;
	}
	return fname;
}

int OpenFileDlg(HWND hWnd, char * fname)
{
	char path[256];
	TCHAR szFileName[256];
	TCHAR szDir[256];
	TCHAR filter[] = _T("GB Files\0*.gb;*.gbc;*.zip\0All files\0*.*\0"); 

	int ret;
	OPENFILENAME ofn;

	DEBUGLOG( "OpenFileDlg Start\n" );

	szFileName[0] = 0;
	szDir[0] = 0;
	if( romdir==NULL ){
		strcpy( path, GetModuleName() );
		mbstowcs( szDir, ExtractFilePath(path) ,256 );	
	}else{
		mbstowcs( szDir, GetFullPath(romdir) ,256 );	
	}				
	memset(&ofn,0,sizeof(ofn));

    DEBUGLOG( "OpenFileDlg 1\n" );

    ofn.lpstrFilter	= filter;
    ofn.hwndOwner   = hWnd;
    ofn.lStructSize	= sizeof(ofn);
    ofn.lpstrFile	= szFileName;
    ofn.nMaxFile	= 256;
    ofn.Flags		= OFN_EXPLORER /*| OFN_ENABLETEMPLATE */;
	if(szDir[0]) ofn.lpstrInitialDir = szDir;

    DEBUGLOG( "OpenFileDlg 2\n" );
	// display a open file dialog

    HINSTANCE hInst = LoadLibrary(_T("gsgetfile.dll"));
	if (hInst) {
		BOOL (*gsGetOpenFileName)(OPENFILENAME* );
#ifdef POCKETPC
		(FARPROC&)gsGetOpenFileName = GetProcAddress(hInst, _T("gsGetOpenFileName"));
#else
		(FARPROC&)gsGetOpenFileName = GetProcAddress(hInst, "gsGetOpenFileName");
#endif
		if (gsGetOpenFileName) {
			ret = gsGetOpenFileName(&ofn);
		}
		FreeLibrary(hInst);
    }else{
        ret = GetOpenFileName(&ofn);
		if( ret == 0 ){
			DWORD lErrMsg;
			lErrMsg = CommDlgExtendedError();
		}
    }
    DEBUGLOG( "OpenFileDlg 3\n" );

	if( !ret ){
        fname = NULL;
      	DEBUGLOG( "OpenFileDlg Cancel END\n" );
        return 0;
    }

	DEBUGLOG( "OpenFileDlg 4\n" );
	memset(fname, 0, 256 );
//    wcstombs(fname, szFileName,256 );
	BOOL flg;
	WideCharToMultiByte(932,0,szFileName,-1,fname,256,NULL,&flg );   
    DEBUGLOG( "OpenFileDlg OK END\n" );
    return 1;
}
