#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <commctrl.h>
#include <commdlg.h>
//#include <afx.h>
#ifdef POCKETPC
#include <sipapi.h>
#include <Aygshell.h>
#include <gx.h>
#endif

#include "resource.h"

#include "Version"
#include "defs.h"
#include "emu.h"
#include "input.h"
#include "loader.h"
#include "getromname.h"
#include "rc.h"
#include "input.h"
#include "exports.h"
#include "keymap.h"
#include "lcd.h"
#include "hw.h"
#include "debug.h"

#include "sys_gfx.h"
#include "sys_sound.h"
#include "sys_winCE.h"
#include "sys_setting.h"
#include "sys_debug.h"

#include "Profiler.h"

#include "stdfnc.h"

#define STR_LEN 256
#define DOTDIR "\\My Documents\\gnuboy"
#define MENU_HEIGHT 26

HINSTANCE g_inst = NULL;
HWND      g_wnd  = NULL;
HWND      hwnd_debug = NULL;
static HWND cbar = NULL;
static HACCEL accel = NULL;
static HBITMAP skin = NULL;

char * skindir = NULL;
char * romdir  = NULL;

static char * rom = 0;

static int paused = 1;
int slot = 0;
int g_bLoop = true;
int CommandBarVis = false;
#ifdef POCKETPC
GXKeyList g_gxkl;
#endif
typedef struct tagPAD {
	int cod;
	TCHAR * name;
}PAD;

PAD pad[] = { 
	{ PAD_UP     ,_T("UP"    ) },
	{ PAD_DOWN   ,_T("DOWN"  ) },
	{ PAD_LEFT   ,_T("LEFT"  ) },
	{ PAD_RIGHT  ,_T("RIGHT" ) },
	{ PAD_A      ,_T("A"     ) },
	{ PAD_B      ,_T("B"     ) },
	{ PAD_SELECT ,_T("SELECT") },
	{ PAD_START  ,_T("START" ) },
	{ 0x00       ,NULL         }
};

/*
 * emulator code
 */

static void checksaveslot(int n)
{
	HMENU menu;

#ifdef POCKETPC
	menu = (HMENU)SendMessage( cbar, SHCMBM_GETMENU, 0, 0 );
#else
#ifdef HPC
	menu = CommandBar_GetMenu(cbar,0);
#else
	menu = GetMenu(cbar);
#endif
#endif
	CheckMenuRadioItem(menu, IDM_SAVE_SLOT_0, IDM_SAVE_SLOT_9,
					   IDM_SAVE_SLOT_0 + n, MF_BYCOMMAND);
	slot = n;
}

static void checkscreenmode(int n)
{
	HMENU menu;

#ifdef POCKETPC
	menu = (HMENU)SendMessage( cbar, SHCMBM_GETMENU, 0, 0 );
#else
#ifdef HPC
	menu = CommandBar_GetMenu(cbar,0);
#else
	menu = GetMenu(cbar);
#endif
#endif
	CheckMenuRadioItem(menu, IDM_SCREEN_MODE_160X144,IDM_SCREEN_MODE_480X432,
					   IDM_SCREEN_MODE_160X144 + n, MF_BYCOMMAND);
	screenmode = n;
}

static void checkframeskip(int n)
{
	HMENU menu;

#ifdef POCKETPC
	menu = (HMENU)SendMessage( cbar, SHCMBM_GETMENU, 0, 0 );
#else
#ifdef HPC
	menu = CommandBar_GetMenu(cbar,0);
#else
	menu = GetMenu(cbar);
#endif
#endif
	CheckMenuRadioItem(menu, IDM_FRAME_RATE_60, IDM_FRAME_RATE_10,
					   IDM_FRAME_RATE_60 + n, MF_BYCOMMAND);
	frameskip = n;
}

void *sys_timer()
{
	ULARGE_INTEGER *tm;
	SYSTEMTIME st;

	GetSystemTime(&st);
	tm = (ULARGE_INTEGER *) malloc(sizeof(ULARGE_INTEGER));
	SystemTimeToFileTime(&st, (FILETIME *) tm);

	return tm;
}

int sys_elapsed(void *prev)
{
	int usecs;

	SYSTEMTIME st;
	ULARGE_INTEGER tm, *pr;

	GetSystemTime(&st);
	SystemTimeToFileTime(&st, (FILETIME *) &tm);
	pr = (ULARGE_INTEGER *) prev;
	usecs = (int) (tm.QuadPart - pr->QuadPart) / 10;
	*pr = tm;

	return usecs;
}

void sys_quit()
{
	state_save(999);			
	save_setting();
	loader_unload();
	pcm_close();
	vid_close();
//    CommandBar_Destroy(cbar);
//	DestroyWindow(wnd);
//	exit(0);
}

void sys_checkdir(char *path, int flg)
{
	wchar_t path2[MAX_PATH];
	DWORD attr;
	char *p;
	DEBUGLOG( "sys_checkdir start [%s]\n" , path );	
	mbstowcs(path2, path, strlen(path) + 1);
	attr = GetFileAttributes(path2);
    if (attr == 0xFFFFFFFF) {
		p = strrchr(path, '\\');
		if (!p) die("descended to root trying to create dirs\n");
		*p = 0;
		sys_checkdir(path, flg);
		*p = '\\';
		if (!CreateDirectory(path2, NULL))
			die("cannot create %s: %lu\n", path, GetLastError());
	}
	DEBUGLOG( "sys_checkdir end\n" , path );	
}

void sys_initpath(char *exe)
{
/*
	char *var[1];
	char *rcpath;
	char *exepath;
	char *end;
	int len;

	exepath = (char *) malloc(sizeof(char) * strlen(exe));
	if ((end = strrchr(exe, '\\')) == NULL)
		rcpath = DOTDIR;
	else {
		len = end - exe;
		if( len > 0 ) {
			strncpy(exepath, exe, len);
			exepath[len] = '\0';
		}else{
			len = 1;
			strcpy( exepath, "\\" );
		}
		rcpath = (char *) malloc(sizeof(char) * (strlen(DOTDIR) + len + 2));
		sprintf(rcpath, "%s;" DOTDIR, exepath);
	}

	var[0] = DOTDIR;
	savedir = strdup( var[0] );

	free( rcpath );
	free( exepath );
*/
}

void sys_sanitize(char *s)
{
}

void die(char *fmt, ...)
{
    FILE * fp;
    va_list ap;
    fp = fopen( "\\gnuboy.log","w");
	va_start(ap, fmt);
	vfprintf(fp,fmt, ap);
	va_end(ap);
	fclose(fp);
	exit(1);
}

DWORD   g_pOriginalWndProc = NULL;
bool    g_bSetButtonMode   = false;
int     g_iSetButton;

TCHAR * GetBtnStr(TCHAR * buf, int btn )
{
	bool flg = false;
	wcscpy( buf,_T("") );
	if( btn & PAD_UP    ){ wcscpy( buf, _T("Up") ); flg = true; }
	if( btn & PAD_DOWN  ){ if(flg)wcscat( buf, _T("+") );wcscat( buf, _T("Down") ); flg = true; }
	if( btn & PAD_LEFT  ){ if(flg)wcscat( buf, _T("+") );wcscat( buf, _T("Left") ); flg = true; }
	if( btn & PAD_RIGHT ){ if(flg)wcscat( buf, _T("+") );wcscat( buf, _T("Right") ); flg = true; }
	if( btn & PAD_A     ){ if(flg)wcscat( buf, _T("+") );wcscat( buf, _T("A") ); flg = true; }
	if( btn & PAD_B     ){ if(flg)wcscat( buf, _T("+") );wcscat( buf, _T("B") ); flg = true; }
	if( btn & PAD_START ){ if(flg)wcscat( buf, _T("+") );wcscat( buf, _T("Start") ); flg = true; }
	if( btn & PAD_SELECT){ if(flg)wcscat( buf, _T("+") );wcscat( buf, _T("Select") ); flg = true; }
	return buf;
}

#ifndef ListView_SetCheckState
#define ListView_SetCheckState(hwndLV, i, fCheck) \
	ListView_SetItemState( hwndLV, i, \
		INDEXTOSTATEIMAGEMASK((fCheck)+1), LVIS_STATEIMAGEMASK)
#endif

void SetChk( HWND wnd, int num )
{
	int i;
	bool flg;
	for(i=0;pad[i].cod != 0;i++){
		if( num & pad[i].cod ) flg = true;
		else flg = false;
		ListView_SetCheckState(wnd,i,flg);
	}
}

int GetChk( HWND wnd )
{
	int i;
	int num = 0;
	for(i=0;i<ListView_GetItemCount(wnd);i++){
		if( ListView_GetCheckState(wnd,i) ){
			num |= pad[i].cod; 
		}
	}
	return num;
}

LRESULT CALLBACK ButtonProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	TCHAR buf[64];
	LVFINDINFOW lvfi;
	int cnt,num;
    switch (message)
    {
        case WM_GETDLGCODE:
            return DLGC_WANTARROWS|DLGC_WANTALLKEYS;
        case WM_KEYDOWN:
            if (g_bSetButtonMode)
            {
                short vkKey = (short) wParam;
                if (vkKey == VK_LWIN) return TRUE;

				SetDlgItemInt(GetParent(hWnd), IDC_VKEY, vkKey, false);   // L[R[hZbg
				// L[ꗗɊɂ邩`FbN
				wsprintf(buf,_T("%d"),GetDlgItemInt(GetParent(hWnd),IDC_VKEY ,false,false));
				lvfi.flags = LVFI_STRING;
				lvfi.psz   = buf;
				cnt = ListView_FindItem(GetDlgItem(GetParent(hWnd),IDC_LSTKEY), -1, &lvfi);
				if( cnt != -1 ){
					// {^XgXV
//					ListView_SetItemState(GetDlgItem( GetParent(hWnd), IDC_LSTKEY), cnt, 
//																LVIS_SELECTED | LVIS_FOCUSED ,
//																LVIS_SELECTED | LVIS_FOCUSED );
					ListView_GetItemText(GetDlgItem(GetParent(hWnd),IDC_LSTKEY),cnt,2,buf,sizeof(buf));
					num = _ttoi(buf);
				}else{
					num = 0;
				}
				SetChk(GetDlgItem(GetParent(hWnd),IDC_LSTPAD),num);

                g_bSetButtonMode = false;
                return TRUE;
            }
            break;
        default:
            break;
    }
#if _WIN32_WCE_EMULATION
    return CallWindowProc((WNDPROC)g_pOriginalWndProc, hWnd, message, wParam, lParam);
#else
#if _WIN32_WCE >= 300
    return CallWindowProc((WNDPROC)g_pOriginalWndProc, hWnd, message, wParam, lParam);
#else
    return CallWindowProc((WNDPROC)g_pOriginalWndProc, hWnd, message, wParam, lParam);
#endif
#endif
}

void InsCol( HWND w, int i, TCHAR * str , int width )
{
	LV_COLUMN LvColumn;
	LvColumn.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT;
	LvColumn.fmt = LVCFMT_LEFT;
	LvColumn.pszText = str;
	LvColumn.iSubItem = 0;
	LvColumn.cchTextMax= wcslen(LvColumn.pszText);
	ListView_InsertColumn(w, i, &LvColumn);
	ListView_SetColumnWidth(w, i, width);
}

int InsItm( HWND w,int i, int cnt, TCHAR * str  )
{
	LV_ITEM LvItem;

	LvItem.pszText = str;
	LvItem.iItem = i;
	LvItem.mask = LVIF_TEXT | LVIF_STATE;
	LvItem.stateMask = LVIS_FOCUSED | LVIS_SELECTED;
	LvItem.state = 0;
	LvItem.iSubItem = cnt;
	LvItem.cchTextMax = wcslen(LvItem.pszText);
	return ListView_InsertItem(w, &LvItem); 
}

int InsItmInt( HWND w,int i, int cnt, int num )
{
	TCHAR buf[64];
	wsprintf( buf,_T("%d"),num );
	return InsItm( w,i,cnt, buf );
}

int SetItm( HWND w,int i, int cnt, TCHAR * str  )
{
	LV_ITEM LvItem;

	LvItem.pszText = str;
	LvItem.iItem = i;
	LvItem.mask = LVIF_TEXT | LVIF_STATE;
	LvItem.stateMask = LVIS_FOCUSED | LVIS_SELECTED;
	LvItem.state = 0;
	LvItem.iSubItem = cnt;
	LvItem.cchTextMax = wcslen(LvItem.pszText);
	return ListView_SetItem(w, &LvItem); 
}

int SetItmInt( HWND w,int i, int cnt, int num )
{
	TCHAR buf[64];
	wsprintf( buf,_T("%d"),num );
	return SetItm( w,i,cnt, buf );
}

static LRESULT CALLBACK keysetting(HWND hDlg, UINT message, WPARAM wpar, LPARAM lpar)
{
#ifdef POCKETPC
	SHINITDLGINFO info;
#endif
	TCHAR buf[64];
	LVFINDINFOW lvfi;
	HWND lstWnd;
	int cnt;
	int i;
	int num;

	switch (message)
	{
		case WM_INITDIALOG:
#ifdef POCKETPC
			info.dwMask = SHIDIM_FLAGS;
			info.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN |	SHIDIF_SIZEDLGFULLSCREEN;
			info.hDlg = hDlg;
			SHInitDialog(&info);
#endif
			// keyset Xg
			lstWnd = GetDlgItem(hDlg,IDC_LSTKEY);
			ListView_SetExtendedListViewStyleEx(lstWnd,
												LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE,
												LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE );
			InsCol( lstWnd, 0, _T("KEY"), 70 );
			InsCol( lstWnd, 1, _T("PAD"), 300 );
			InsCol( lstWnd, 2, _T("PADNUM"),0 );

			for( i=0;joy_code[i].code!=0;i++ ){ 
				InsItmInt( lstWnd,i, 0, joy_code[i].code );
				SetItm   ( lstWnd,i, 1, GetBtnStr(buf,joy_code[i].pad) );
				SetItmInt( lstWnd,i, 2, joy_code[i].pad );
			}

			// PADXg
			lstWnd = GetDlgItem(hDlg,IDC_LSTPAD);
			ListView_SetExtendedListViewStyleEx(lstWnd,
						LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE,
						LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE );

			InsCol( lstWnd, 0, _T("PAD"),150 );
			for(i=0;i<8;i++){
				InsItm( GetDlgItem(hDlg,IDC_LSTPAD),i, 0, pad[i].name );
			}			

			g_pOriginalWndProc = SetWindowLong(GetDlgItem(hDlg, IDC_BTNSETKEY),GWL_WNDPROC, (DWORD) ButtonProc);
			return 1; 
			break;
		case WM_COMMAND:
            switch( LOWORD(wpar) ){
                case IDC_BTNSETKEY:
                    if (!g_bSetButtonMode)
                    {
                        g_bSetButtonMode = true;
                    } else {
                        g_bSetButtonMode = false;
                    }
                    break;
				case IDC_BTNSET:
					wsprintf(buf,_T("%d"),GetDlgItemInt(hDlg,IDC_VKEY ,false,false));
					lvfi.flags = LVFI_STRING;
					lvfi.psz   = buf;
					cnt = ListView_FindItem(GetDlgItem(hDlg,IDC_LSTKEY), -1, &lvfi);
					if( cnt == -1 ){
						cnt = ListView_GetItemCount(GetDlgItem(hDlg,IDC_LSTKEY));
						cnt = InsItmInt(GetDlgItem(hDlg,IDC_LSTKEY),cnt, 0, GetDlgItemInt(hDlg,IDC_VKEY ,false,false) );
					}
					num = GetChk(GetDlgItem(hDlg,IDC_LSTPAD));
					SetItm(GetDlgItem(hDlg,IDC_LSTKEY),cnt, 1, GetBtnStr(buf,num) );
					SetItmInt(GetDlgItem(hDlg,IDC_LSTKEY),cnt, 2, num );
					break;										
				case IDC_BTNDEL:
					for(i=0;i<ListView_GetItemCount(GetDlgItem(hDlg,IDC_LSTKEY));i++ ){ 
						if( ListView_GetItemState(GetDlgItem(hDlg,IDC_LSTKEY),i,LVIS_SELECTED) & LVIS_SELECTED ){
							ListView_DeleteItem(GetDlgItem(hDlg,IDC_LSTKEY),i);
							break;
						}
					}                
					break;										
				case IDOK:
					for(i=0;i<ListView_GetItemCount(GetDlgItem(hDlg,IDC_LSTKEY));i++ ){
						ListView_GetItemText(GetDlgItem(hDlg,IDC_LSTKEY),i,0,buf,sizeof(buf));
						joy_code[i].code = _ttoi(buf);
						ListView_GetItemText(GetDlgItem(hDlg,IDC_LSTKEY),i,2,buf,sizeof(buf));
						joy_code[i].pad = (unsigned char)_ttoi(buf);
					}						
					joy_code[i].code = 0;
					joy_code[i].pad  = 0;
					EndDialog(hDlg, LOWORD(wpar));
				    return TRUE;
                case IDCANCEL:
    				EndDialog(hDlg, LOWORD(wpar));
    				return TRUE;
			}
			break;
		case WM_NOTIFY:
			LPNMHDR pNotifyHeader;
			pNotifyHeader= (LPNMHDR)lpar;
            switch( LOWORD(wpar) ){
                case IDC_LSTKEY:
					switch (pNotifyHeader->code)
					{
					case NM_CLICK:
						for(i=0;i<ListView_GetItemCount(GetDlgItem(hDlg,IDC_LSTKEY));i++ ){ 
							if( ListView_GetItemState(GetDlgItem(hDlg,IDC_LSTKEY),i,LVIS_SELECTED) & LVIS_SELECTED ){
								ListView_GetItemText(GetDlgItem(hDlg,IDC_LSTKEY),i,0,buf,sizeof(buf));
								SetDlgItemText(hDlg, IDC_VKEY, buf);   // L[R[hZbg
								ListView_GetItemText(GetDlgItem(hDlg,IDC_LSTKEY),i,2,buf,sizeof(buf));
								num = _ttoi(buf);
								SetChk(GetDlgItem(hDlg,IDC_LSTPAD),num);
								break;
							}
						}				
					}
			}
			break;
		default:
			return DefWindowProc(hDlg, message, wpar, lpar);
	}
    return 0;
}

static LRESULT CALLBACK dirsetting(HWND dlg, UINT message, WPARAM wpar, LPARAM lpar)
{
#ifdef POCKETPC
	SHINITDLGINFO info;
#endif
	//	char buf[STR_LEN];
	WCHAR wbuf[STR_LEN];

	switch (message) {
	case WM_INITDIALOG:
#ifdef POCKETPC
		info.dwMask = SHIDIM_FLAGS;
		info.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
		info.hDlg = dlg;
		SHInitDialog(&info);
#endif
		if( romdir != NULL ){
			mbstowcs(wbuf,romdir,STR_LEN);
			SetWindowText(GetDlgItem(dlg, IDC_ROMDIR), wbuf);
		}
		if( savedir != NULL ){
			mbstowcs(wbuf,savedir,STR_LEN);
			SetWindowText(GetDlgItem(dlg, IDC_SAVDIR), wbuf);
		}
		if( statedir != NULL ){
			mbstowcs(wbuf,statedir,STR_LEN);
			SetWindowText(GetDlgItem(dlg, IDC_STATEDIR), wbuf);
		}
		return 1; 
	case WM_COMMAND:
		if (LOWORD(wpar) == IDOK) {
			int cnt;
			free(romdir);
			free(savedir);
			free(statedir);
			romdir   = NULL;
			savedir  = NULL;
			statedir = NULL;
			if( cnt = GetWindowText(GetDlgItem(dlg, IDC_ROMDIR),wbuf,STR_LEN) ){
				romdir =(char*)malloc( cnt + 1 );
				wcstombs(romdir,wbuf,cnt);
			}
			if( cnt = GetWindowText(GetDlgItem(dlg, IDC_SAVDIR),wbuf,STR_LEN) ){
				savedir =(char*)malloc( cnt + 1 );
				wcstombs(savedir,wbuf,cnt);
			}
			if(	cnt = GetWindowText(GetDlgItem(dlg, IDC_STATEDIR),wbuf,STR_LEN) ){
				statedir =(char*)malloc( cnt + 1 );
				wcstombs(statedir,wbuf,cnt);
			}
			EndDialog(dlg, LOWORD(wpar));
			return 1;
		}
		break;
	}

    return 0;
}

static LRESULT CALLBACK aboutbox(HWND dlg, UINT message, WPARAM wpar, LPARAM lpar)
{
#ifdef POCKETPC
	SHINITDLGINFO info;
#endif
	char version[STR_LEN];
	wchar_t version2[STR_LEN];

	switch (message) {
	case WM_INITDIALOG:
		sprintf(version, "Version %s", VERSION);
		mbstowcs(version2, version, strlen(version) + 1);
		SetWindowText(GetDlgItem(dlg, IDC_VERSION), version2);
#ifdef POCKETPC
		info.dwMask = SHIDIM_FLAGS;
		info.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN |
			SHIDIF_SIZEDLGFULLSCREEN;
		info.hDlg = dlg;
		SHInitDialog(&info);
#endif
		return 1; 
	case WM_COMMAND:
		if (LOWORD(wpar) == IDOK) {
			EndDialog(dlg, LOWORD(wpar));
			return 1;
		}
		break;
	}

    return 0;
}

static HWND createcommandbar(HWND wnd)
{
#ifdef POCKETPC
	SHMENUBARINFO mbi;
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = wnd;
	mbi.nToolBarId = IDM_MENU;
	mbi.hInstRes   = g_inst;
	mbi.nBmpId     = 0;
	mbi.cBmpImages = 0;
	if (!SHCreateMenuBar(&mbi)) return NULL;
	return mbi.hwndMB;
#else
#ifdef HPC
	HWND hcb;
	BOOL res;
	hcb = CommandBar_Create( g_inst, wnd, 1 );
	res = CommandBar_InsertMenubar( hcb, g_inst, IDM_MENU, 0 );	
	return hcb;
#else
//	HWND hcb;
//	BOOL res;
//	hcb = CreateMenu( g_inst, wnd, 1 );
//	res = InsertMenu( hcb, FALSE, IDM_MENU, 0 );	
//	SetMenu( wnd, hcb ); 
	return wnd;
#endif
#endif
}

static LRESULT CALLBACK windowproc(HWND wnd, UINT message,
								   WPARAM wpar, LPARAM lpar)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rect;

	switch (message) {
	case WM_COMMAND:
		switch (LOWORD(wpar)) {	
		case IDM_ABOUT:
			DialogBox(g_inst, (LPCTSTR) IDD_ABOUTBOX, wnd, (DLGPROC) aboutbox);
			break;
		case IDM_KEYSET:
			DialogBox(g_inst, (LPCTSTR) IDD_KEYSET, wnd, (DLGPROC) keysetting);
			break;
		case IDM_DIRSET:
			DialogBox(g_inst, (LPCTSTR) IDD_DIRSET, wnd, (DLGPROC) dirsetting);
			break;
		case IDM_DEBUG:
			hwnd_debug = CreateDialog(g_inst,(LPCTSTR) IDD_DEBUG, wnd, (DLGPROC) debugproc);
			debug_trace = 1;
			break;
		case IDM_SAVE_SLOT_0:
		case IDM_SAVE_SLOT_1:
		case IDM_SAVE_SLOT_2:
		case IDM_SAVE_SLOT_3:
		case IDM_SAVE_SLOT_4:
		case IDM_SAVE_SLOT_5:
		case IDM_SAVE_SLOT_6:
		case IDM_SAVE_SLOT_7:
		case IDM_SAVE_SLOT_8:
		case IDM_SAVE_SLOT_9:
            {
                int arg = LOWORD(wpar) - IDM_SAVE_SLOT_0;
			    checksaveslot(arg);
            }
            break;
		case IDM_SAVE:
			state_save(slot);
			break;
		case IDM_LOAD:
			state_load(slot);
			break;
		case IDM_GAMELOAD:
			rom = (char*)malloc( 256 ); 
			if( OpenFileDlg(wnd,rom) != 0 ){
/*
				char * r;
				char * sep;
				r = strdup(rom);
    			sep = strchr(r, '.');
    			if (sep) *sep = '\0';
    			strcat(r, ".rc");
				rc_sourcefile(r);
				free(r);
*/
//				vid_init();
//				pcm_init();

//				sys_sanitize(rom);
				loader_init(rom);
				emu_reset();
				vid_begin();
				lcd_begin();
//				state_load(999);
	            paused = 0;
			}
			break;
		case IDM_EXIT:
			SendMessage (wnd, WM_CLOSE, 0, 0);
			break;
		case IDM_SCREEN_MODE_160X144:
		case IDM_SCREEN_MODE_240X216:
		case IDM_SCREEN_MODE_320X240:
		case IDM_SCREEN_MODE_320X288:
		case IDM_SCREEN_MODE_480X432:
            {
                int arg = LOWORD(wpar) - IDM_SCREEN_MODE_160X144;
			    checkscreenmode(arg);
			    vid_setscreenmode(arg);
            }
			InvalidateRect( wnd, NULL, false );
            break;
		case IDM_FRAME_RATE_60:
		case IDM_FRAME_RATE_30:
		case IDM_FRAME_RATE_20:
		case IDM_FRAME_RATE_15:
		case IDM_FRAME_RATE_12:
		case IDM_FRAME_RATE_10:
            {
                int arg = LOWORD(wpar) - IDM_FRAME_RATE_60;
			    checkframeskip(arg);
			    vid_setframeskip(arg);
            }
			InvalidateRect( wnd, NULL, false );
            break;
		default:
			return DefWindowProc(wnd, message, wpar, lpar);
		}
		break;
	case WM_CREATE:
		cbar = createcommandbar(wnd);
		checksaveslot(slot);
	    checkscreenmode(screenmode);
	    checkframeskip(frameskip);
//		CommandBar_Show(cbar,true);
		break;
//	case WM_CLOSE:
//		break;
	case WM_DESTROY:
		sys_quit();
        g_bLoop = false;
#ifdef HPC
		CommandBar_Destroy(cbar);
#endif
/*		{
			HWND hwndTBar = FindWindow(_T("HHTaskBar"),NULL);
			ShowWindow(hwndTBar, SW_SHOW);
		}
*/
		Profile_Output();
		PostQuitMessage(0);
        break;
    case WM_PAINT: 
		hdc = BeginPaint(wnd, &ps);
		if (paused) {
			wchar_t str[STR_LEN];
			GetClientRect(wnd, &rect);
			HBRUSH hbrush = CreateSolidBrush(RGB(0, 0, 0));
			FillRect(hdc,&rect,hbrush);
			DeleteObject( hbrush );
			LoadString(g_inst, IDS_PAUSE, str, STR_LEN);
			SetBkColor(hdc, RGB(0, 0, 0));
			SetTextColor(hdc, RGB(255, 255, 255));
			GetClientRect(wnd, &rect);
			DrawText(hdc, str, _tcslen(str), &rect, 
					 DT_SINGLELINE | DT_VCENTER | DT_CENTER);
		}else{
			HBRUSH hbrush = CreateSolidBrush(RGB(0, 0, 0));
			FillRect(hdc,&rect,hbrush);
			DeleteObject( hbrush );
			if( skin != NULL ){
				HDC hBuffer = CreateCompatibleDC(hdc);
				SelectObject(hBuffer , skin);
				BitBlt(hdc , 0 , 0 , 300 , 480 , hBuffer , 0 , 0 , SRCCOPY);
				DeleteDC(hBuffer);
			}
		}
		EndPaint(wnd, &ps);
		break; 
	case WM_LBUTTONDOWN:
        if( paused == 0 ){ 
//			RECT rt;
            vid_suspend();
//            CommandBar_Show(cbar,true);
            paused = 1;
//            GetClientRect(wnd, &rt);
//            InvalidateRect(wnd, &rt, 1);
//            UpdateWindow(wnd);
//            checksaveslot(rc_getint("saveslot"));
//            checkscreenmode(rc_getint("screenmode"));
//            checkframeskip(rc_getint("frameskip"));
			pcm_pause();
			InvalidateRect( wnd, NULL, false );
        }else{
            paused = 0;
//            CommandBar_Show(cbar,false);
			InvalidateRect( wnd, NULL, false );
			pcm_restart();
        }
        break;
    case WM_KEYDOWN:
#if 0
        {
			event_t ev;
            ev.type = EV_PRESS;
		    ev.code = keymap[wpar];
//#ifdef DEBUG
			{
			    LPTSTR buf;
                buf = (LPTSTR)malloc(256);
			    wsprintf( buf, _T("key [%.4X]\n"), wpar );
			    OutputDebugString( buf );
			    free(buf);
		    }
//#endif
			ev_postevent(&ev);
        }
#endif
//		joy_poll();
        break; 
    case WM_KEYUP:
#if 0
        {
   	        event_t ev;
		    ev.type = EV_RELEASE;
		    ev.code = keymap[wpar];
    	    ev_postevent(&ev);
        }
#endif
//		joy_poll();
        break;
/*
	case WM_KILLFOCUS:
        paused = 1;
		break;

	case WM_SETFOCUS:
		paused = 0;
		break;
*/
    case WM_SETTINGCHANGE:
//		SHHandleWMSettingChange(wnd, wpar, lpar, &actinfo);
		break;
	default:
		return DefWindowProc(wnd, message, wpar, lpar);
   }

   return 0;
}

static ATOM registerclass(HINSTANCE inst, LPTSTR szWindowClass)
{
	WNDCLASS wclass;

    wclass.style = CS_HREDRAW | CS_VREDRAW ;
    wclass.lpfnWndProc = (WNDPROC) windowproc;
    wclass.cbClsExtra = 0;
    wclass.cbWndExtra = 0;
    wclass.hInstance = inst;
    wclass.hIcon = LoadIcon(inst, MAKEINTRESOURCE(IDI_GNUBOY));
    wclass.hCursor = 0;
    wclass.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);
    wclass.lpszMenuName = MAKEINTRESOURCE(IDM_MENU);
    wclass.lpszClassName = szWindowClass;

	return RegisterClass(&wclass);
}

static int initinstance(HINSTANCE inst, int show)
{
	wchar_t	title[STR_LEN];
	wchar_t	wclass[STR_LEN];
//	RECT rect;

	g_inst = inst;
	LoadString(inst, IDC_GNUBOY, wclass, STR_LEN);
	LoadString(inst, IDS_APP_TITLE, title, STR_LEN);

//	skin = SHLoadImageFile(_T("\\skin.bmp"));

	if (g_wnd = FindWindow(wclass, title)) {
		SetForegroundWindow((HWND) (((DWORD) g_wnd) | 0x01));    
		return 0;
	} 
	
	registerclass(inst, wclass);
#ifdef POCKETPC
	if (!(g_wnd = CreateWindow(wclass, title, WS_VISIBLE | WS_NONAVDONEBUTTON /*| WS_EX_TOPMOST*/,
							 CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
							 CW_USEDEFAULT, NULL, NULL, inst, NULL)))
#else
	if (!(g_wnd = CreateWindow(wclass, title, WS_VISIBLE  ,
							 CW_USEDEFAULT, CW_USEDEFAULT, 300,
							 300, NULL, NULL, inst, NULL)))
#endif
	 return 0;

	

#if 0
	GetWindowRect(g_wnd, &rect);
	if (cbar)
		MoveWindow(wnd, rect.left, rect.top, rect.right, rect.bottom, 0);
#endif

/*
	if (cbar)
    {
		RECT rc;
        RECT rcMenuBar;

		GetWindowRect(g_wnd, &rc);
        GetWindowRect(cbar, &rcMenuBar);
		rc.bottom -= (rcMenuBar.bottom - rcMenuBar.top);
		
		MoveWindow(g_wnd, rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top, FALSE);
	}
*/
	ShowWindow(g_wnd, show);
	UpdateWindow(g_wnd);

	return 1;
}
#ifdef WINCE  
int WINAPI WinMain(HINSTANCE inst, HINSTANCE previnst, 
										LPTSTR cmdline, int show)
#else
int WINAPI WinMain(HINSTANCE inst, HINSTANCE previnst, 
										LPSTR cmdline, int show)
#endif
{
	MSG msg;
	int ret;
	char *cmd = 0;
    char *exename;
//    int i;

	load_setting();

	if (!initinstance(inst, show))
		return 0;
	accel = LoadAccelerators(inst, (LPCTSTR)IDC_GNUBOY);


    { // W[擾
        LPTSTR s;
        s =(LPTSTR) malloc(256);
    	exename = (char*)malloc(256);
    	ret = GetModuleFileName(inst,s,256);
    	ret = wcstombs(exename,s,256); 
    	free(s);
    }
/*
	if( wcslen(cmdline) ){
	    cmd = (char*)malloc(256);
		ret = wcstombs(cmd,cmdline,256); 
		DEBUGLOG( "cmdline = %s \n", cmd ); 
	}
*/
#ifdef POCKETPC
	GXOpenInput();	
	g_gxkl = GXGetDefaultKeys( GX_NORMALKEYS );
#endif

	sys_sanitize(exename);
	sys_initpath(exename);

//	for (i = 0; defaultconfig[i]; i++)
//		rc_command(defaultconfig[i]);
	
	// Rom OpenDialog
#if 0
	if( cmd == NULL ){
        rom = (char *) malloc( 256 );
        if( OpenFileDlg(wnd,rom) == 0 ) return 0;
	}else{
		rom = strdup( cmd );
	}

    {
        char * r;
        char * sep;
        r = strdup(rom);
    	sep = strchr(r, '.');
    	if (sep) *sep = '\0';
    	strcat(r, ".rc");
//        rc_sourcefile(r);
        free(r);
    }
#endif	

	vid_init();
	pcm_init();

	Profile_Init();

#if 0
    if( rom != NULL ){
	    sys_sanitize(rom);
	    loader_init(rom);
	    emu_reset();
        vid_begin();
	    lcd_begin();
	    state_load(999);
    }
#endif	

	while (g_bLoop) 
	{
        if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
        {
//			if (!GetMessage (&msg,NULL,0,0)) /* bZ[W */
//				return msg.wParam ;
			if( msg.message == WM_QUIT ) break;

			if (!TranslateAccelerator(msg.hwnd, accel, &msg)) 
		    {
			    TranslateMessage(&msg);
			    DispatchMessage(&msg);
		    }
		}else{
			if(g_bLoop && (!paused) && rom ) 
				if( debug_trace ){
					emu_tick_debug();
				}else{
					emu_tick();
				}
		}
	}

#ifdef POCKETPC
	GXCloseInput();	
#endif
	return msg.wParam;

}
