/***************************************************************************

    M.A.M.E.CE  -  Multiple Arcade Machine Emulator for WinCE
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
	WinCE Portions Copyright (C) 1999 Benjamin Cooley
    
    This file is part of MAMECE, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  CESound.c

 ***************************************************************************/
#include "stdafx.h"
#include "mmSystem.h"
#include "CESound.h"
#include "fceu\driver.h"

/***************************************************************************
    Internal structures
 ***************************************************************************/

#define NUM_WAVEHDRS  32

struct tSound_private {
	WAVEOUTCAPS		m_Caps;
	HWAVEOUT		m_hWaveOut;
	WAVEHDR			m_WaveHdrs[NUM_WAVEHDRS];

	int				m_nSampleRate;
	int				m_nSampleBits;
	int				m_nChannels;
	int				m_nVolume;		// -32 to 0 attenuation value
};


/***************************************************************************
    Internal variables
 ***************************************************************************/

static struct tSound_private      This;

int CESound_init(int SampleRate, int SampleBit)
{
	MMRESULT res;
	WAVEFORMATEX wf;
	int i;

	This.m_hWaveOut = NULL;

	This.m_nSampleRate = SampleRate;		/* 11025Hz 22050Hz 44100Hz */
	This.m_nSampleBits = SampleBit;
	This.m_nChannels   = 1;

	wf.wFormatTag      = WAVE_FORMAT_PCM;
	wf.nChannels       = This.m_nChannels; 
	wf.nSamplesPerSec  = This.m_nSampleRate; 
	wf.nAvgBytesPerSec = (This.m_nSampleBits/8) * This.m_nChannels * This.m_nSampleRate; 
	wf.nBlockAlign     = (This.m_nSampleBits/8) * This.m_nChannels ;
	wf.wBitsPerSample  = This.m_nSampleBits; 
	wf.cbSize          = 0;

	res = waveOutOpen(
		&This.m_hWaveOut,	// Handle
		0,					// ID (0 for wave mapper)
		&wf,				// Wave format
		0,					// Callback
		0,					// Instance data
		CALLBACK_NULL);

	if (res != MMSYSERR_NOERROR)
		return 1;

	memset(&This.m_WaveHdrs, 0, sizeof(WAVEHDR) * NUM_WAVEHDRS);

	// Wave buffer allocate
	for( i=0;i< NUM_WAVEHDRS ;i++ ){
		This.m_WaveHdrs[i].lpData = (LPSTR)malloc(2048*(This.m_nSampleBits==8?1:2));
	}		

	This.m_nVolume = 0;

	return 0;
}

void CESound_exit(void)
{
	BOOL done;
	int i, ticks;

	ticks = GetTickCount();
	done = FALSE;
	while (!done && GetTickCount() - ticks < 500)
	{
		done = TRUE;
		for (i = 0; i < NUM_WAVEHDRS; i++)
		{
			if (This.m_WaveHdrs[i].dwFlags & WHDR_DONE)
			{
				waveOutUnprepareHeader(This.m_hWaveOut, &This.m_WaveHdrs[i], sizeof(WAVEHDR));
				This.m_WaveHdrs[i].lpData = NULL;
				This.m_WaveHdrs[i].dwBufferLength = 0;
				This.m_WaveHdrs[i].dwFlags = 0;
			}
			else if (This.m_WaveHdrs[i].dwFlags)
				done = FALSE;
		}
	}

	waveOutClose(This.m_hWaveOut);
}

void CESound_set_volume(unsigned short left, unsigned short right)
{
	DWORD nVolume;

	nVolume = (DWORD)left | (DWORD)right << 16;

	waveOutSetVolume(This.m_hWaveOut, nVolume);
}

#define WRITEBUFCNT 16

int curwavbuf=0;
int16 * wavdatbuf;

/*
void FCEUD_WriteSoundData(int32 *data, int len, int check)
{
	int i;
	int16  *d;
	int8   *dd;
	int P;

	curwavbuf = (curwavbuf+1) % NUM_WAVEHDRS;
	if ((This.m_WaveHdrs[curwavbuf].dwFlags != 0) && ((This.m_WaveHdrs[curwavbuf].dwFlags & WHDR_DONE)==0) ) return;
	waveOutUnprepareHeader(This.m_hWaveOut, &This.m_WaveHdrs[curwavbuf], sizeof(WAVEHDR));

	This.m_WaveHdrs[curwavbuf].dwFlags =0;   //WHDR_BEGINLOOP | WHDR_ENDLOOP;
	if( This.m_nSampleBits==16 ){
		This.m_WaveHdrs[curwavbuf].dwBufferLength = len*2;
	}else{
		This.m_WaveHdrs[curwavbuf].dwBufferLength = len;
	}
	wavdatbuf =(int16 *)(This.m_WaveHdrs[curwavbuf].lpData);
	waveOutPrepareHeader(This.m_hWaveOut, &This.m_WaveHdrs[curwavbuf], sizeof(WAVEHDR));


	if(This.m_nSampleBits==16){
		d = wavdatbuf;
		if(check){
			for(P=0;P<len;P++){
				int32 mixer;
				mixer=data[P];
				if(mixer>32767) mixer=32767;
				if(mixer<-32768) mixer=-32768;
				d[P]=mixer;
				data[P]=0;
			}
		} else {
			for(P=0;P<len;P++)
			{
				d[P]=data[P];
				data[P]=0;
			}
		}
	}else{
		dd = (int8*)wavdatbuf;
		if(check){
			for(P=0;P<len;P++){
				int32 mixer;
				mixer=data[P]>>7;
				if(mixer> 127) mixer=127;
				if(mixer<-128) mixer=-128;
				data[P]=0;
				dd[P]=((int8)mixer)^128;
			}
		} else {
			for(P=0;P<len;P++){
				dd[P]=((int8)(data[P]>>7))^128;
				data[P]=0;
			}
		}
	}

	waveOutWrite(This.m_hWaveOut, &This.m_WaveHdrs[curwavbuf], sizeof(WAVEHDR));

}
*/

void FCEUD_WriteSoundData(int32 *data, int len, int check)
{
	int i;
	int16  *d;
	int8   *dd;
	int P;

	curwavbuf = (curwavbuf+1) % NUM_WAVEHDRS;
	if ((This.m_WaveHdrs[curwavbuf].dwFlags != 0) && ((This.m_WaveHdrs[curwavbuf].dwFlags & WHDR_DONE)==0) ) return;
	waveOutUnprepareHeader(This.m_hWaveOut, &This.m_WaveHdrs[curwavbuf], sizeof(WAVEHDR));

	This.m_WaveHdrs[curwavbuf].dwFlags =0;   //WHDR_BEGINLOOP | WHDR_ENDLOOP;
	if( This.m_nSampleBits==16 ){
		This.m_WaveHdrs[curwavbuf].dwBufferLength = len*2;
	}else{
		This.m_WaveHdrs[curwavbuf].dwBufferLength = len;
	}
	wavdatbuf =(int16 *)(This.m_WaveHdrs[curwavbuf].lpData);

	if(This.m_nSampleBits==16){
		d = wavdatbuf;
		if(check){
			for(P=0;P<len;P++){
				int32 mixer;
				mixer=data[P];
				if(mixer> 32767) mixer= 32767;
				if(mixer<-32768) mixer=-32768;
				d[P]=mixer;
				data[P]=0;
			}
		} else {
			for(P=0;P<len;P++){
				d[P]=data[P];
				data[P]=0;
			}
		}
	}else{
		dd = (int8*)wavdatbuf;
		if(check){
			for(P=0;P<len;P++){
				int32 mixer;
				mixer=data[P]>>7;
				if(mixer> 127) mixer= 127;
				if(mixer<-128) mixer=-128;
				data[P]=0;
				dd[P]=((int8)mixer)^128;
			}
		} else {
			for(P=0;P<len;P++){
				dd[P]=((int8)(data[P]>>7))^128;
				data[P]=0;
			}
		}
	}

	waveOutPrepareHeader(This.m_hWaveOut, &This.m_WaveHdrs[curwavbuf], sizeof(WAVEHDR));
	waveOutWrite(This.m_hWaveOut, &This.m_WaveHdrs[curwavbuf], sizeof(WAVEHDR));

}