#include "mapinc.h"

DECLFW(MWrite)
{
 (GameMemBlock-0x7000)[A]=V;
}

static void MALEEReset(void)
{
  setprg2r(0x10,0x7000,0);
  SetReadHandler(0x8000,0xFFFF,(void *)CartBR);
  SetReadHandler(0x6000,0x67ff,(void *)CartBR);
  SetReadHandler(0x7000,0x77FF,(void *)CartBR);
  SetWriteHandler(0x7000,0x77FF,(void *)MWrite);
  setprg2r(1,0x6000,0);
  setprg32(0x8000,0);
  setchr8(0);
}

void MALEE_Init(void)
{
  AddExState(GameMemBlock, 2048, 0,"RAM");
  SetupCartPRGMapping(0x10,GameMemBlock,2048,1);
  BoardPower=(void *)MALEEReset;
}
