#include "mapinc.h"

static void DoNovel(void)
{
 setprg32(0x8000,GameMemBlock[0]&3);
 setchr8(GameMemBlock[0]&7);
}

static DECLFW(NovelWrite)
{
 GameMemBlock[0]=A&0xFF;
 DoNovel();
}

static void NovelReset(void)
{
  SetWriteHandler(0x8000,0xFFFF,(void *)NovelWrite);
  SetReadHandler(0x8000,0xFFFF,(void *)CartBR);  
  setprg32(0x8000,0);
  setchr8(0);
}

static void NovelRestore(int version)
{
 DoNovel();
}

void Novel_Init(void)
{
  AddExState(&GameMemBlock[0], 1, 0,"L1");
  BoardPower=(void *)NovelReset;
  GameStateRestore=(void *)NovelRestore;
}
