#include "mapinc.h"

#define CHRRAM (GameMemBlock)
static uint8 latche;

DECLFW(CPROMWrite)
{
 latche=V&3;
 setvram4(0x1000,CHRRAM+((V&3)<<12));
}

static void CPROMReset(void)
{
 setprg32(0x8000,0);
 setvram8(0);
 SetReadHandler(0x8000,0xFFFF,(void *)CartBR);
 SetWriteHandler(0x8000,0xffff,(void *)CPROMWrite);
}

static void CPROMRestore(int version)
{
 setvram4(0x1000,CHRRAM+((latche)<<12));
}

void CPROM_Init(void)
{
 BoardPower=(void *)CPROMReset;
 GameStateRestore=(void *)CPROMRestore;
 AddExState(&latche, 1, 0, "LATC");
}

DECLFW(CNROMWrite)
{
 latche=V&3;
 setchr8(V&3);
}

static void CNROMReset(void)
{
  setprg16(0x8000,0);
  setprg16(0xC000,1);
  SetReadHandler(0x8000,0xFFFF,(void *)CartBR);
  SetWriteHandler(0x8000,0xffff,(void *)CNROMWrite);
}

static void CNROMRestore(int version)
{
 setchr8(latche);
}

void CNROM_Init(void)
{
 BoardPower=(void *)CNROMReset;
 GameStateRestore=(void *)CNROMRestore;
 AddExState(&latche, 1, 0, "LATC");
}

static void NROM128Reset(void)
{
  setprg16(0x8000,0);
  setprg16(0xC000,0);
  setchr8(0);
  SetReadHandler(0x8000,0xFFFF,(void *)CartBR);
}

static void NROM256Reset(void)
{
  setprg16(0x8000,0);
  setprg16(0xC000,1);
  setchr8(0);
  SetReadHandler(0x8000,0xFFFF,(void *)CartBR);
}
void NROM128_Init(void)
{
  BoardPower=(void *)NROM128Reset;
}

void NROM256_Init(void)
{
  BoardPower=(void *)NROM256Reset;
}

static DECLFW(MHROMWrite)
{
 setprg32(0x8000,V>>4);
 setchr8(V);
 latche=V;
}

static void MHROMReset(void)
{
 setprg32(0x8000,0);
 setchr8(0);
 latche=0;
 SetReadHandler(0x8000,0xFFFF,(void *)CartBR);
}

static void MHROMRestore(int version)
{
 setprg32(0x8000,latche);
 setchr8(latche);
 SetWriteHandler(0x8000,0xffff,(void *)MHROMWrite);
}

void MHROM_Init(void)
{ 
 BoardPower=(void *)MHROMReset;
 AddExState(&latche, 1, 0,"LATC");
 PRGmask32[0]&=1;
 CHRmask8[0]&=1;
 GameStateRestore=(void *)MHROMRestore;
}

static void UNROMRestore(int version)
{
 setprg16(0x8000,latche);
}

static DECLFW(UNROMWrite)
{
 setprg16(0x8000,V);
 latche=V;
}

static void UNROMReset(void)
{
 setprg16(0x8000,0);
 setprg16(0xc000,~0);
 setvram8(CHRRAM);
 SetWriteHandler(0x8000,0xffff,(void *)UNROMWrite);
 SetReadHandler(0x8000,0xFFFF,(void *)CartBR);
 latche=0;
}

void UNROM_Init(void)
{
 BoardPower=(void *)UNROMReset;
 PRGmask16[0]&=7;
 AddExState(&latche, 1, 0, "LATC");
 AddExState(CHRRAM, 8192, 0, "CHRR");
 GameStateRestore=(void *)UNROMRestore;
}
