#include "mapinc.h"

#define CHRRAM (GameMemBlock+16)

static void DoSuper(void)
{
 setprg8r((GameMemBlock[0]&0xC)>>2,0x6000,((GameMemBlock[0]&0x3)<<4)|0xF);
 if(GameMemBlock[0]&0x10)
 {
  setprg16r((GameMemBlock[0]&0xC)>>2,0x8000,((GameMemBlock[0]&0x3)<<3)|(GameMemBlock[1]&7));
  setprg16r((GameMemBlock[0]&0xC)>>2,0xc000,((GameMemBlock[0]&0x3)<<3)|7);
 }
 else
  setprg32r(4,0x8000,0);

 setmirror(((GameMemBlock[0]&0x20)>>5)^1);
}

static DECLFW(SuperWrite)
{
 if(!(GameMemBlock[0]&0x10))
 {
  GameMemBlock[0]=V;
  DoSuper();
 }
}

static DECLFW(SuperHi)
{
 GameMemBlock[1]=V; 
 DoSuper();
}

static void SuperReset(void)
{
  SetWriteHandler(0x6000,0x7FFF,(void *)SuperWrite);
  SetWriteHandler(0x8000,0xFFFF,(void *)SuperHi);
  SetReadHandler(0x6000,0xFFFF,(void *)CartBR);  
  GameMemBlock[0]=GameMemBlock[1]=0;
  setprg32r(4,0x8000,0);
  setvram8(CHRRAM);
}

static void SuperRestore(int version)
{
 DoSuper();
}

void Supervision16_Init(void)
{
  AddExState(&GameMemBlock[0], 1, 0,"L1");
  AddExState(&GameMemBlock[1], 1, 0,"L2");
  AddExState(CHRRAM, 8192, 0, "CHRR");
  BoardPower=(void *)SuperReset;
  GameStateRestore=(void *)SuperRestore;
}
