#include "types.h"
/* Prototypes for platform interface functions follow: */

void FCEUD_SendMessage(int msg);
void FCEUD_UpdateInput(void);

/* These messages will only be sent when a new game is loaded. */

#define DSM_SPECIALCONTROLTYPE_ZAPPER1	1
#define DSM_SPECIALCONTROLTYPE_ZAPPER2	2
#define DSM_SPECIALSYSTEM_VSUNISYSTEM	4
#define DSM_SPECIALSYSTEM_NSF		8
#define DSM_SPECIALSYSTEM_FDS		16
#define DSM_RESETSPECIAL		0x1000

/* Video interface */
void FCEUD_SetPalette(uint8 index, uint8 r, uint8 g, uint8 b);
void FCEUD_GetPalette(uint8 i,uint8 *r, unsigned char *g, unsigned char *b);
void FCEUD_BlitScreen(unsigned char *XBuf);

/* Sound interface */
void FCEUD_WriteSoundData(int32 *Buffer, int Count, int Check);

/* Displays an error.  Can block or not. */
void FCEUD_PrintError(char *s);

#ifdef NETWORK
/* Network interface */

int FCEUD_NetworkConnect(void);
int FCEUD_NetworkRecvByte(unsigned char *Value);
int FCEUD_NetworkSendByte(unsigned char *Value);
void FCEUD_NetworkClose(void);

#endif

#define DES_NTSCCOL     2

#define DES_RESET       0x10
#define DES_POWER       0x11

#define DES_GETNTSCHUE  0x20
#define DES_GETNTSCTINT  0x21
#define DES_SETNTSCHUE  0x22
#define DES_SETNTSCTINT  0x23
#define DES_GETDESIREDFPS 0x24

#define DES_DISPMESSAGE	0x40
#define DES_SAVESNAP	0x41
#define DES_NSFINC	0x50
#define DES_NSFDEC	0x51
#define DES_NSFRES	0x52
#define DES_LOADSTATE	0x60
#define DES_SAVESTATE	0x61
#define DES_SELECTSTATE 0x62
#define DES_VSUNIDIPSET 0x70
#define DES_VSUNITOGGLEDIPVIEW	0x71
#define	DES_VSUNICOIN	0x72
#define DES_FDSINSERT	0x80
#define DES_FDSEJECT	0x81
#define DES_FDSSELECT	0x82

#define DES_NTSCSELHUE	0x90
#define DES_NTSCSELTINT	0x91
#define DES_NTSCDEC	0x92
#define DES_NTSCINC	0x93

void DriverInterface(int w, void *d);
void DriverInputInterface(int w, int n, int arg, void *ptr);

#include "version.h"
#define DII_SETCONTROL         1
#define DII_SETCONTROLATTRIB   0x10
#define DII_SETMULTI	       0x20

#define DII_SETCONTROL_NONE     0
#define DII_SETCONTROL_GAMEPAD  1
#define DII_SETCONTROL_ZAPPER   2
#define DII_SETCONTROL_POWERPAD 3


/* New interface functions */

/* 0 to keep 8-sprites limitation, 1 to remove it */
void FCEUI_DisableSpriteLimitation(int a);

/* 0 to save extra game data(*.sav) in same dir as game, 1 to save under base dir */
void FCEUI_SaveExtraDataUnderBase(int a);

/* name=path and file to load.  returns 0 on failure, 1 on success */
int FCEUI_LoadGame(char *name);

/* allocates memory.  0 on failure, 1 on success. */
int FCEUI_Initialize(void);

/* begins emulation.  Returns after FCEUI_CloseGame() is called */
void FCEUI_Emulate(void);

/* Closes currently loaded game, causes FCEUI_Emulate to return */
void FCEUI_CloseGame(void);

/* Enable/Disable game genie. a=0 disable, a=1 enable */
void FCEUI_SetGameGenie(int a);

/* Set video system a=0 NTSC, a=1 PAL */
void FCEUI_SetVidSystem(int a);

/* To use frameskip, PutImage() calls FCEUI_FrameSkip() with
   the number of frames to skip before the next call. */
void FCEUI_FrameSkip(int skip);

/* Sets the first scanline to be rendered.  Should be from 0 through 239. */
void FCEUI_SetFirstRenderedLine(int a);

/* Sets the last scanline to be rendered.  Should be from 0 through 239. */
void FCEUI_SetLastRenderedLine(int a);

/* Sets the base directory(save states, snapshots, etc. are saved in directories
   below this directory. */
void FCEUI_SetBaseDirectory(char *dir);

/* Tells FCE Ultra to copy the palette data pointed to by pal and use it.
   Data pointed to by pal needs to be 64*3 bytes in length.
*/
void FCEUI_SetPaletteArray(uint8 *pal);

/* Sets up sound code to render sound at the specified rate, in samples
   per second.  The sample rate should be as close to 44100 hz as possible.
   Sample rates from 8192 through 65535 are ok, though if the sample rate
   is too low, some sound channels(noise) won't sound right.
   If "Rate" equals 0, sound is disabled.
*/
void FCEUI_Sound(int Rate);

#ifdef NETWORK
/* Set network play stuff. type=1 for server, type=2 for client.
   skip is only used for server */
void FCEUI_SetNetworkPlay(int type, int skip);
#endif

int FCEUI_AddCheat(char *name, uint16 addr, uint8 val);
int FCEUI_DelCheat(uint32 which);

int32 FCEUI_CheatSearchGetCount(void);
void FCEUI_CheatSearchGetRange(int first, int last, void (*callb)(uint16 a, int last, int current));
void FCEUI_CheatSearchGet(void (*callb)(uint16 a, int last, int current));
void FCEUI_CheatSearchBegin(void);
void FCEUI_CheatSearchEnd(int type, int v1, int v2);
void FCEUI_ListCheats(void (*callb)(char *name, uint16 a, uint8 v));

int FCEUI_GetCheat(uint32 which, char **name, int32 *a, int32 *v, int *s);
int FCEUI_SetCheat(uint32 which, char *name, int32 a, int32 v, int s);
void FCEUI_CheatSearchShowExcluded(void);
void FCEUI_CheatSearchSetCurrentAsOriginal(void);
