/****************************************************************/
/*			FCE Ultra				*/
/*								*/
/*	This file contains routines for reading/writing the     */
/*	configuration file.					*/
/*								*/
/****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../../types.h"
#include "config.h"

static int FReadString(FILE *fp, char *str, int n)
{
 int x=0,z;
 for(;;)
 {
  z=fgetc(fp);
  str[x]=z;
  x++;  
  if(z<=0) break;
  if(x>=n) return 0;
 }
 if(z<0) return 0;
 return 1;
}

static void GetValueR(FILE *fp, char *str, void *v, int c)
{
 char buf[256];
 int s;

 while(FReadString(fp,buf,256))
 {
  fread(&s,1,4,fp);
  if(!strcmp(str, buf))
  {
   if(c<0)
   {
    c=0-c;
    if(s>c)
     goto gogl;
    goto rodo;
   }
   else
    if(s>c || c<s)
    {
     gogl:
     fseek(fp,s,SEEK_CUR);
     continue;
    }
   rodo:
   fread((uint8*)v,1,c,fp);
  }
  else
   fseek(fp,s,SEEK_CUR);
 }
 fseek(fp,4,SEEK_SET);
}

static void SetValueR(FILE *fp, char *str, void *v, int c)
{
 fwrite(str,1,strlen(str)+1,fp);
 fwrite((uint8*)&c,1,4,fp);
 fwrite((uint8*)v,1,c,fp);
}

void SaveFCEUConfig(char *filename, CFGSTRUCT *cfgst, int n)
{
	FILE *fp;
	int x;

        fp=fopen(filename,"wb");
        if(fp==NULL) return;

	for(x=0;x<n;x++)
	{
	 switch(cfgst[x].type)
	 {
	  case 0:SetValueR(fp,cfgst[x].name,cfgst[x].ptr,cfgst[x].len);break;
	  case 1:SetValueR(fp,cfgst[x].name,cfgst[x].ptr,strlen(cfgst[x].ptr)+1);
		 break;
	  case 2:SetValueR(fp,cfgst[x].name,cfgst[x].ptr,cfgst[x].len);break;
	 }
	}
	fclose(fp);
}

void LoadFCEUConfig(char *filename, CFGSTRUCT *cfgst, int n)
{
        FILE *fp;
        int x;

        fp=fopen(filename,"rb");
        if(fp==NULL) return;

        for(x=0;x<n;x++)
        {
         switch(cfgst[x].type)
         {	
          case 0:GetValueR(fp,cfgst[x].name,cfgst[x].ptr,cfgst[x].len);break;
          case 1:GetValueR(fp,cfgst[x].name,cfgst[x].ptr,0-cfgst[x].len);break;
          case 2:GetValueR(fp,cfgst[x].name,cfgst[x].ptr,cfgst[x].len);break;
         }
        }
        fclose(fp);
}
