#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sched.h>
#include <sys/soundcard.h>

#include "../../types.h"

static int format;
static int dspfd;

// fsize is in samples, not bytes(gets translated before ioctl())
int InitUNIXDSPSound(int *rate, int bits, int fsize, int nfrags)
{
 int x;

 printf("  Opening /dev/dsp...");
 dspfd=open("/dev/dsp",O_WRONLY);
 if(dspfd==-1) goto __disperror;

 if(!bits) goto skip16check;
 x=AFMT_S16_LE;
 format=0;
 printf("\n   Setting format to 16-bit, signed, LSB first...");
 if(ioctl(dspfd,SNDCTL_DSP_SETFMT,&x)==-1)
 {
  skip16check:
  x=AFMT_U8;
  printf("\n   Setting format to 8-bit, unsigned...");
  if(ioctl(dspfd,SNDCTL_DSP_SETFMT,&x)==-1) goto __disperror;
  format=1;
 }

 printf("\n   Setting fragment size to %d samples and number of fragments to %d...",1<<fsize,nfrags);

 if(!format)
  fsize++;
 x=fsize|(nfrags<<16);

 if(ioctl(dspfd,SNDCTL_DSP_SETFRAGMENT,&x)==-1)
  printf("ERROR (continuing anyway)\n");
 x=0;
 printf("\n   Setting mono sound...");  
 if(ioctl(dspfd,SNDCTL_DSP_STEREO,&x)==-1) goto __disperror;
 printf("\n   Setting playback rate of %d hz...",*rate);
 if(ioctl(dspfd,SNDCTL_DSP_SPEED,rate)==-1) goto __disperror;
 printf("Set to %d hz\n",*rate);
 if(*rate<8192 || *rate>65535)
 {
  printf("    Sample rate is out of the acceptable range(8192-65535).\n");
  close(dspfd);
 }
 return 1;
 __disperror:
 printf("ERROR\n");
 return 0;
}

void KillUNIXDSPSound(void)
{
  close(dspfd);
}

static int16 MBuffer[2048];
void WriteUNIXDSPSound(int32 *Buffer, int Count, int Check, int noblocking)
{
 int P,c;
 int32 *src=Buffer;

 if(format)
 {
  uint8 *dest=(uint8 *)MBuffer;

  if(Check)
   for(P=Count;P;P--,dest++,src++)
    {
     int32 mixer;
     mixer=*src>>7;
     if(mixer>127) mixer=127;
     if(mixer<-128) mixer=-128;
     *src=0;
     *dest=((uint8)mixer)^128;
    }
  else
   for(P=Count;P;P--,dest++,src++)
    {
     *dest=(uint8)((*src)>>7)^128;
     *src=0;
    }
   c=Count;
 }
 else
 {
  int16 *dest=MBuffer;

  if(Check)
  {
   for(P=Count;P;P--,dest++,src++)
   {
    int32 mixer;
    mixer=*src;
    if(mixer>32767) mixer=32767;
    if(mixer<-32768) mixer=-32768;
    *src=0;
    *dest=mixer;
   }
  }
  else
  {
   for(P=Count;P;P--,dest++,src++)
   {
    *dest=*src;
    *src=0;
   }
  }
  c=Count<<1;
 }

 //noblocking=!noblocking; // speed testing
 if(noblocking)
 {
  struct audio_buf_info ai;
  if(!ioctl(dspfd,SNDCTL_DSP_GETOSPACE,&ai))
   if(ai.bytes<c)
    return;
 }
 write(dspfd,(uint8 *)MBuffer,c);
}
