#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <assert.h>

#include <crt0.h>
#include <pc.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/farptr.h>

#include "../../driver.h"

#include "main.h"
#include "video.h"
#include "input.h"
#include "joystick.h"
#include "sb.h"

#include "../common/config.h"
#include "../common/args.h"
#include "../common/cheat.h"

/* _CRT0_FLAG_LOCK_MEMORY might not always result in all memory being locked.
   Bummer.  I'll add code to explicitly lock the data touched by the sound
   interrupt handler(and the handler itself), if necessary(though that might
   be tricky...).
*/

int _crt0_startup_flags = _CRT0_FLAG_FILL_SBRK_MEMORY | _CRT0_FLAG_LOCK_MEMORY | _CRT0_FLAG_USE_DOS_SLASHES;
static int ntsccol=0,ntschue=-1,ntsctint=-1;

static int f8bit=0;
static char BaseDirectory[2048];
#define EMO_NO8LIM      1
#define EMO_SUBASE      2

int FCEUDemuloptions=0;

static int keyinit=0;
static char TempArray[2048];

static void DriverKill(void);
static int DriverInitialize(void);

int soundo=44100;

void FCEUD_PrintError(char *s)
{
 puts(s);
}

#define CONFIGITEMS 14
static CFGSTRUCT fceuconfig[CONFIGITEMS]={
        {"sound",&soundo,0,sizeof(soundo)},
        {"vmode",&FCEUDvmode,0,sizeof(FCEUDvmode)},
        {"joybmap",joyBMap,2,sizeof(joyBMap)},
        {"joy",&joy,0,sizeof(joy)},
        {"ntsctint",&ntsctint,0,sizeof(ntsctint)},
        {"ntschue",&ntschue,0,sizeof(ntschue)},
        {"ntsccol",&ntsccol,0,sizeof(ntsccol)},
        {"f8bit",&f8bit,0,sizeof(f8bit)},
	{"joymulti",&joymulti,0,sizeof(joymulti)},
        {"InputType",InputType,2,sizeof(InputType)},
        {"powerpadside",&powerpadside,0,sizeof(powerpadside)},
        {"FCEUDemuloptions",&FCEUDemuloptions,0,sizeof(FCEUDemuloptions)},
        {"srendline",&FCEUDsrendline,0,sizeof(FCEUDsrendline)},
        {"erendline",&FCEUDerendline,0,sizeof(FCEUDerendline)}
};

static void SaveConfig(void)
{	
        sprintf(TempArray,"%s\\fceu.cfg",BaseDirectory);
        DriverInterface(DES_GETNTSCTINT,&ntsctint);
        DriverInterface(DES_GETNTSCHUE,&ntschue);
        SaveFCEUConfig(TempArray,fceuconfig,CONFIGITEMS);
}

static void LoadConfig(void)
{
        sprintf(TempArray,"%s\\fceu.cfg",BaseDirectory);
        LoadFCEUConfig(TempArray,fceuconfig,CONFIGITEMS);
        if(ntsctint>=0) DriverInterface(DES_SETNTSCTINT,&ntsctint);
        if(ntschue>=0) DriverInterface(DES_SETNTSCHUE,&ntschue);
}

static void CreateDirs(void)
{
 sprintf(TempArray,"%s\\fcs",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s\\snaps",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s\\gameinfo",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s\\sav",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s\\cheats",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
}

static void GetBaseDirectory(char *s)
{
 int x;

 for(x=strlen(s);x>=0;x--)
 {
  if(s[x]=='/' || s[x]=='\\')
  {
   strncpy(BaseDirectory,s,x);
   break;
  }
 }

 BaseDirectory[x]=0;

 FCEUI_SetBaseDirectory(BaseDirectory);
}

static void SetSignals(void (*t)(int))
{
  int sigs[11]={SIGINT,SIGTERM,SIGHUP,SIGPIPE,SIGSEGV,SIGFPE,SIGKILL,SIGALRM,SIGABRT,SIGUSR1,SIGUSR2};
  int x;
  for(x=0;x<11;x++)
   signal(sigs[x],t);
}

static void CloseStuff(int signum)
{
	DriverKill();
        printf("\nSignal %d has been caught and dealt with...\n",signum);
        switch(signum)
        {
         case SIGINT:printf("How DARE you interrupt me!\n");break;
         case SIGTERM:printf("MUST TERMINATE ALL HUMANS\n");break;
         case SIGHUP:printf("Reach out and hang-up on someone.\n");break;
         case SIGPIPE:printf("The pipe has broken!  Better watch out for floods...\n");break;
         case SIGSEGV:printf("Iyeeeeeeeee!!!  A segmentation fault has occurred.  Have a fluffy day.\n");break;
         case SIGFPE:printf("Those darn floating points.  Ne'er know when they'll bite!\n");break;
         case SIGALRM:printf("Don't throw your clock at the meowing cats!\n");break;
         case SIGABRT:printf("Abort, Retry, Ignore, Fail?\n");break;
         case SIGUSR1:
         case SIGUSR2:printf("Killing your processes is not nice.\n");break;
        }
        exit(1);
}

static void DoArgs(int argc, char *argv[])
{
        static char *cortab[4]={"none","gamepad","zapper","powerpad"};
        static int cortabi[4]={DII_SETCONTROL_NONE,DII_SETCONTROL_GAMEPAD,
                               DII_SETCONTROL_ZAPPER,DII_SETCONTROL_POWERPAD};
	int x;
	static char inputa[2][32];
        static int docheckie[4];

        static ARGPSTRUCT FCEUArgs[15]={
         {"-vmode",0,&FCEUDvmode,0},{"-ntsccol",0,&ntsccol,0},
         {"-pal",&docheckie[0],0,0},{"-sound",0,&soundo,0},
         {"-f8bit",0,&f8bit,0},
	 {"-joymulti",0,&joymulti,0},
         {"-input1",0,inputa[0],1},{"-input2",0,inputa[1],1},

         {"-joy",0,&joy,0},

	 {"-gg",&docheckie[1],0,0},
	 {"-no8lim",0,&FCEUDemuloptions,0x8001},{"-subase",&docheckie[3],&FCEUDemuloptions,0x8002},
	 {"-vsync",0,&FCEUDemuloptions,0x8004},
	 {"-slstart",0,&FCEUDsrendline,0},{"-slend",0,&FCEUDerendline,0},
	};

        inputa[0][0]=inputa[1][0]=0;
        memset(docheckie,0,sizeof(docheckie));

        ParseArguments(argc, argv, FCEUArgs, 15);

	if(docheckie[0])
	 FCEUI_SetVidSystem(1);
	if(docheckie[1])
	 FCEUI_SetGameGenie(1);

        FCEUI_DisableSpriteLimitation(FCEUDemuloptions&1);
        FCEUI_SaveExtraDataUnderBase(FCEUDemuloptions&2);

        if(FCEUDsrendline<0 || FCEUDsrendline>239) FCEUDsrendline=0;
        if(FCEUDerendline<FCEUDsrendline || FCEUDerendline>239) FCEUDerendline=239;

        FCEUI_SetFirstRenderedLine(FCEUDsrendline);
        FCEUI_SetLastRenderedLine(FCEUDerendline);
	DriverInterface(DES_NTSCCOL,&ntsccol);

        if(!joy) memset(joyBMap,0,4);
	for(x=0;x<2;x++)
	{
	 int y;

         if(!inputa[x][0])
	  continue;

	 for(y=0;y<4;y++)	 
	 {
	  if(!strncmp(cortab[y],inputa[x],8))
	  {
	   InputType[x]=cortabi[y];
	   if(y==3)
	   {
	    powerpadside&=~(1<<x);
	    powerpadside|=((((inputa[x][8])-'a')&1)^1)<<x;
	   }
	  }
	 }
	}	
}

#include "usage.h"

int main(int argc, char *argv[])
{
	int ret;

        puts("\nStarting FCE Ultra "VERSION_STRING"...\n");

	if(!(ret=FCEUI_Initialize()))
         return(1);

        GetBaseDirectory(argv[0]);
	CreateDirs();
        if(argc<=1) 
        {
         ShowUsage(argv[0]);
         return 1;
        }
        LoadConfig();
        DoArgs(argc-2,&argv[1]);

        if(soundo)
        {
	 if(soundo==1)
          soundo=44100;

         soundo=InitSB(soundo,f8bit?0:1);
         FCEUI_Sound(soundo);
        }

        if(!FCEUI_LoadGame(argv[argc-1]))
        {
         ret=0;
         goto dk;
        }

        if(!DriverInitialize())
        {
         ret=0;
         goto dk;
        }
	FCEUI_Emulate();

	dk:
	DriverKill();
        return(ret?0:1);
}

static int DriverInitialize(void)
{
   SetSignals((void *)CloseStuff);

   if(joy)
    InitJoystick();

   if(!InitVideo()) return 0;
   if(!InitKeyboard()) return 0;
   keyinit=1;
   InitOtherInput();
   return 1;
}

static void DriverKill(void)
{
 SaveConfig();
 SetSignals(SIG_IGN);

 if(keyinit)
  keyboard_close();
 KillVideo();
 if(soundo) 
  KillSB(); 
}

void FCEUD_WriteSoundData(int32 *Buffer, int Count, int Check)
{
 WriteSBSound(Buffer,Count,Check,NoWaiting);
}

void DOSMemSet(uint32 A, uint8 V, uint32 count)
{
 uint32 x;

 _farsetsel(_dos_ds);
 for(x=0;x<count;x++)
  _farnspokeb(A+x,V); 
  
}

