#include <dpmi.h>

#include "../../driver.h"

int InitMouse(void)
{
 __dpmi_regs regs;

 memset(&regs,0,sizeof(regs));
 regs.x.ax=0;
 __dpmi_int(0x33,&regs);
 if(regs.x.ax!=0xFFFF)
  return(0);

 memset(&regs,0,sizeof(regs));
 regs.x.ax=0x7;
 regs.x.cx=0;           // Min X
 regs.x.dx=260;         // Max X
 __dpmi_int(0x33,&regs);

 memset(&regs,0,sizeof(regs));
 regs.x.ax=0x8;
 regs.x.cx=0;           // Min Y
 regs.x.dx=260;         // Max Y
 __dpmi_int(0x33,&regs);

 memset(&regs,0,sizeof(regs));
 regs.x.ax=0xF;
 regs.x.cx=8;           // Mickey X
 regs.x.dx=8;           // Mickey Y
 __dpmi_int(0x33,&regs);

 memset(&regs,0,sizeof(regs));
 regs.x.ax=0x2;
 __dpmi_int(0x33,&regs);

 return(1);
}

uint32 GetMouseData(uint32 *x, uint32 *y)
{
 __dpmi_regs regs;

 memset(&regs,0,sizeof(regs));
 regs.x.ax=0x3;
 __dpmi_int(0x33,&regs);

 *x=regs.x.cx;
 *y=regs.x.dx;
 return(regs.x.bx&3);
}
