/*
	VGA access on DJGPP
	bero
*/

#include	<dpmi.h>

#define TEXT            3
#define G320x200x256 0x13

static void vga_waitretrace(void)
{
  while(inp(0x3DA)&0x08);
  while(!(inp(0x3DA)&0x08));
}

void vga_setmode(int mode)
{
        __dpmi_regs regs;
        memset(&regs,0,sizeof(regs));
        regs.x.ax = mode;
         
        __dpmi_int(0x10,&regs);
}

void vga_setpalette(int index, int red, int green, int blue)
{
	outp(0x3c8,index);
	outp(0x3c9,red);
	outp(0x3c9,green);
	outp(0x3c9,blue);
}

