#include "../common/config.h"
#include "../common/args.h"

static char BaseDirectory[2048];

static void BaseDirInit(void)
{
 #ifdef UNIX
 char *ol;
 char TempArray[2048];

 ol=getenv("HOME");
 BaseDirectory[0]=0;
 if(ol)
 {
  strncpy(BaseDirectory,ol,2047);
  BaseDirectory[2047]=0;
  strcat(BaseDirectory,"/.fceultra");
  FCEUI_SetBaseDirectory(BaseDirectory);
 }

 mkdir(BaseDirectory,S_IRWXU);
 sprintf(TempArray,"%s/fcs",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/snaps",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/gameinfo",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/sav",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 sprintf(TempArray,"%s/cheats",BaseDirectory);
 mkdir(TempArray,S_IRWXU);
 #else
 #endif
}
/* PK: added joystick-related stuff */
extern int joy[4];
extern int joyBMap[4];
#define CONFIGITEMS 6
static CFGSTRUCT fceuconfig[CONFIGITEMS]={
        {"xres",&_xres,0,sizeof(_xres)},
        {"yres",&_yres,0,sizeof(_yres)},
        {"bpp",&_bpp,0,sizeof(_bpp)},
        {"fullscreen",&_fullscreen,0,sizeof(_fullscreen)},
	{"joy",joy,2,sizeof(joy)},
	{"joybmap",joyBMap,2,sizeof(joyBMap)},
};


#define GetConFN(x) sprintf(x,"%s"PSS"fceusdl.cfg",BaseDirectory);

static void LoadConfig(void)
{
 char tmp[2048];

 GetConFN(tmp);
 LoadFCEUConfig(tmp,fceuconfig,CONFIGITEMS);
}

static void SaveConfig(void)
{
 char tmp[2048];

 GetConFN(tmp);
 SaveFCEUConfig(tmp,fceuconfig,CONFIGITEMS);
}


/* PK: added joyx args */
static const char UsageString[]="
Options:\n\
-xres	x	Set horizontal resolution to x for full screen mode.\n\
-yres	x	Set vertical resolution to x for full screen mode.\n\
-bpp	x	Set bits per pixel to x for full screen mode.\n\
-fullscreen x	Select full screen mode if x is non zero.\n\
-sline	x	Set lirst scanline to draw to x.\n\
-eline	x	Set last scanline to draw to x.\n\
-joyx	y	Use joystick y as virtual joystick x.\n\
";

static int ParseArgs(int argc, char *argv[])
{
 if(argc<=1)
 {
  printf("Usage is as follows:\n%s <options> filename\n",argv[0]);
  puts(UsageString);
  return(0);
 }

 if(argc>2)
 {
  /* PK: added joyx args */
  static ARGPSTRUCT FCEUArgs[10]=
  {
   {"-xres",0,&_xres,0},
   {"-yres",0,&_yres,0},
   {"-bpp",0,&_bpp,0},
   {"-fullscreen",0,&_fullscreen,0},   
   {"-sline",0,&_sline,0},
   {"-eline",0,&_eline,0},
   {"-joy1",0,&joy[0],0},
   {"-joy2",0,&joy[1],0},
   {"-joy3",0,&joy[2],0},
   {"-joy4",0,&joy[3],0},
  };
  ParseArguments(argc-2, &argv[1], FCEUArgs, 10);
 }
 return(1);
}
