#include <stdio.h>
#include <SDL.h>

#include "sdl.h"

static int InputType[2]={DII_SETCONTROL_GAMEPAD,DII_SETCONTROL_ZAPPER};
static void *InputDPtr[2];


static uint32 JSreturn;

static int DIPS=0;
static int JoySwap=0;

#define KEY(__a) keys[SDLK_##__a]
static uint8 keyonce[SDLK_LAST];	// Dunno if this is right...
#define keyonly(__a,__z) {if(KEY(__a)){if(!keyonce[SDLK_##__a]) {keyonce[SDLK_##__a]=1;__z}}else{keyonce[SDLK_##__a]=0;}}

/* PK */
#include "joystick.c"

uint8 *keys;

#include "gamepad.h"
#include "zapper.h"
#include "powerpad.h"

static void UpdateCommandKeys(void)
{

 NoWaiting=0;
 if(KEY(BACKQUOTE))
  NoWaiting=1;

 if(sdlgametype&DSM_SPECIALSYSTEM_FDS)
 {
  keyonly(s,DriverInterface(DES_FDSSELECT,0);)
  keyonly(i,DriverInterface(DES_FDSINSERT,0);)
  keyonly(e,DriverInterface(DES_FDSEJECT,0);)
 }
 if(!(sdlgametype&DSM_SPECIALSYSTEM_NSF))
 {
  keyonly(F9,DriverInterface(DES_SAVESNAP,0);)
 }
 else
 {
  keyonly(LEFT,DriverInterface(DES_NSFDEC,0);)
  keyonly(RIGHT,DriverInterface(DES_NSFINC,0);)
  if( KEY(RETURN)) DriverInterface(DES_NSFRES,0);
  if( KEY(UP)) DriverInterface(DES_NSFINC,0);
  if( KEY(DOWN)) DriverInterface(DES_NSFDEC,0);
 }
 if(sdlgametype&DSM_SPECIALSYSTEM_VSUNISYSTEM)
 {
   keyonly(c,DriverInterface(DES_VSUNICOIN,0);)
   keyonly(d,DIPS^=1;DriverInterface(DES_DISPMESSAGE,(DIPS&1)?"Dip switches modifyable.":"Dip switches not modifyable.");)
   keyonly(v,DriverInterface(DES_VSUNITOGGLEDIPVIEW,0);)
   if(!(DIPS&1)) goto DIPSless;
   keyonly(1,DriverInterface(DES_VSUNIDIPSET,(void *)1);)
   keyonly(2,DriverInterface(DES_VSUNIDIPSET,(void *)2);)
   keyonly(3,DriverInterface(DES_VSUNIDIPSET,(void *)3);)
   keyonly(4,DriverInterface(DES_VSUNIDIPSET,(void *)4);)
   keyonly(5,DriverInterface(DES_VSUNIDIPSET,(void *)5);)
   keyonly(6,DriverInterface(DES_VSUNIDIPSET,(void *)6);)
   keyonly(7,DriverInterface(DES_VSUNIDIPSET,(void *)7);)
   keyonly(8,DriverInterface(DES_VSUNIDIPSET,(void *)8);)
 }
 else
 {
  keyonly(h,DriverInterface(DES_NTSCSELHUE,0);)
  keyonly(t,DriverInterface(DES_NTSCSELTINT,0);)
  if(KEY(KP_MINUS) || KEY(MINUS)) DriverInterface(DES_NTSCDEC,0);
  if(KEY(KP_PLUS) || KEY(EQUALS)) DriverInterface(DES_NTSCINC,0);

  DIPSless:
  keyonly(0,DriverInterface(DES_SELECTSTATE,(void *)0);)
  keyonly(1,DriverInterface(DES_SELECTSTATE,(void *)1);)
  keyonly(2,DriverInterface(DES_SELECTSTATE,(void *)2);)
  keyonly(3,DriverInterface(DES_SELECTSTATE,(void *)3);)
  keyonly(4,DriverInterface(DES_SELECTSTATE,(void *)4);)
  keyonly(5,DriverInterface(DES_SELECTSTATE,(void *)5);)
  keyonly(6,DriverInterface(DES_SELECTSTATE,(void *)6);)
  keyonly(7,DriverInterface(DES_SELECTSTATE,(void *)7);)
  keyonly(8,DriverInterface(DES_SELECTSTATE,(void *)8);)
  keyonly(9,DriverInterface(DES_SELECTSTATE,(void *)9);)
 }

 keyonly(F5,DriverInterface(DES_SAVESTATE,0);)
 keyonly(F7,DriverInterface(DES_LOADSTATE,0);)
 keyonly(F10,DriverInterface(DES_RESET,0);)
 keyonly(F11,DriverInterface(DES_POWER,0);)

 if(KEY(F12) || KEY(ESCAPE)) FCEUI_CloseGame();

}

void FCEUD_UpdateInput(void)
{
 uint32 JS;
 int x;
 int t=0;

 SDL_PumpEvents();
 keys=SDL_GetKeyState(0);
 UpdateCommandKeys();

 for(x=0;x<2;x++)
  switch(InputType[x])
  {
   case DII_SETCONTROL_GAMEPAD:t|=1;break;
   case DII_SETCONTROL_ZAPPER:t|=2;break;
   case DII_SETCONTROL_POWERPAD:powerpadbuf[x]=UpdatePPadData(x);break;
  }
  if(t&1)
  {
   JS=KeyboardGamepad();

   /* PK */
   JS |= (uint32)GetJSOr();

   JSreturn=(JS&0xFF000000)|(JS&0xFF)|((JS&0xFF0000)>>8)|((JS&0xFF00)<<8);
  }
  if(t&2)
   GetMouseData();

}

void InitializeSDLInput(void)
{
   int t;
   int x;

   for(t=0,x=0;x<2;x++)
   {
    switch(InputType[x])
    {
     case DII_SETCONTROL_POWERPAD:InputDPtr[x]=&powerpadbuf[x];break;
     case DII_SETCONTROL_GAMEPAD:InputDPtr[x]=((uint8 *)&JSreturn)+(x<<1);break;     
     case DII_SETCONTROL_ZAPPER:InputDPtr[x]=MouseData;
				if(Settings.fullscreen)
				{
                                 DriverInputInterface(DII_SETCONTROLATTRIB,x,1,0);
				 SDL_ShowCursor(0);
				}
				else
                                 DriverInputInterface(DII_SETCONTROLATTRIB,x,0,0);
                                break;
    }
    DriverInputInterface(DII_SETCONTROL,x,InputType[x],InputDPtr[x]);
   }
   InitJoysticks();
}
