#include <stdio.h>
#include <stdlib.h>

#include <sys/stat.h>
#include <sys/types.h>

#include <string.h>

#include <SDL.h>


#include "sdl.h"

DSETTINGS Settings={800,600,8,0,8,239};

int NoWaiting=0;
int sdlgametype;
void FCEUD_SendMessage(int msg)
{
 switch(msg)
 {
  case DSM_RESETSPECIAL: sdlgametype=0;break;
  case DSM_SPECIALSYSTEM_VSUNISYSTEM:
  case DSM_SPECIALSYSTEM_NSF:
  case DSM_SPECIALSYSTEM_FDS: sdlgametype=msg;break;
 }
}


void FCEUD_PrintError(char *s)
{
 puts(s);
}

#include "fs.h"		// "mkdir"s, base directory stuff, config loading/saving
			//  argument parsing

int main(int argc, char *argv[])
{
 puts("Starting FCE Ultra "VERSION_STRING"...\n");

 FCEUI_Initialize();
 
 /* PK: Need to init joystick stuff too */
 if(SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK)) //|SDL_INIT_AUDIO)==-1)
 {
  printf("Could not initialize SDL: %s.\n", SDL_GetError());
  return(-1);
 }

 BaseDirInit();
 
 /* PK: load config goodies */
 LoadConfig();

 if(!(ParseArgs(argc,argv)))
  return(-1);
 
 InitializeSDLVideo();
 InitializeSDLSound();
 InitializeSDLInput();

 if(FCEUI_LoadGame(argv[argc-1]))
  FCEUI_Emulate();

 SaveConfig();

 SDL_Quit();

 return(0);
}
