#include <stdio.h>
#include <string.h>
#include <SDL.h>

#include "sdl.h"
#include "../common/vidblit.h"

SDL_Surface *screen;

static int bpp;
static int tlines;


static void CleanSurface(void)
{
 uint32 x;

 x=screen->pitch*screen->h;

 if(SDL_MUSTLOCK(screen))
  SDL_LockSurface(screen);

 if(bpp>8)
  memset((uint8*)screen->pixels, 0, x);
 else
  memset((uint8*)screen->pixels, 0x80, x);

 if(SDL_MUSTLOCK(screen))
  SDL_UnlockSurface(screen);

 SDL_UpdateRect(screen, 0, 0, 0, 0);
}

int InitializeSDLVideo(void)
{
 const SDL_VideoInfo *vinf;
 int flags=0;


 tlines=_eline-_sline+1;

 vinf=SDL_GetVideoInfo();

 if(vinf->hw_available)
  flags|=SDL_HWSURFACE;

 if(_fullscreen)
 {
  flags|=SDL_FULLSCREEN;
  if(_bpp==8)
   flags|=SDL_HWPALETTE;
 }
 else
  if(vinf->vfmt->BitsPerPixel==8)
   flags|=SDL_HWPALETTE;

 if(_fullscreen)
  screen = SDL_SetVideoMode(_xres, _yres, _bpp, flags);
 else
  screen = SDL_SetVideoMode(256, tlines, 0, flags);

 if(!screen)
 {
  puts("Error");
  return(0);
 }

 bpp=screen->format->BitsPerPixel;
 if(bpp>8)
  InitBlitToHigh(bpp, screen->format->Rmask, screen->format->Gmask, screen->format->Bmask);
 CleanSurface();

 SDL_WM_SetCaption("FCE Ultra","FCE Ultra");
 return 1;
}

static SDL_Color psdl[256];
static int paletterefresh;

void FCEUD_SetPalette(uint8 index, uint8 r, uint8 g, uint8 b)
{

 psdl[index].r=r;
 psdl[index].g=g;
 psdl[index].b=b;

 paletterefresh=1;
}

void FCEUD_GetPalette(uint8 index, uint8 *r, uint8 *g, uint8 *b)
{
 *r=psdl[index].r;
 *g=psdl[index].g;
 *b=psdl[index].b;
}

static void RedoPalette(void)
{
 SDL_SetPalette(screen,SDL_PHYSPAL,psdl,0,256);
}

void FCEUD_BlitScreen(uint8 *XBuf)
{
 uint8 *dest;
 int xo=0,yo=0;

 if(paletterefresh)
 {
  if(bpp>8)
   SetPaletteBlitToHigh((uint8 *)psdl);
  else
   RedoPalette();
  paletterefresh=0;
 }

 XBuf+=_sline*272;

 if(SDL_MUSTLOCK(screen))
  SDL_LockSurface(screen);

 dest=screen->pixels;

 if(_fullscreen)
 {
  xo=(((screen->w-256))>>1);
  dest+=xo*(bpp>>3);
  if(screen->h>=tlines)
  {
   yo=((screen->h-tlines)>>1);
   dest+=yo*screen->pitch;
  }
 }

 if(bpp>8)
  Blit8ToHigh(XBuf,dest, 256, tlines, screen->pitch);
 else
  Blit8To8(XBuf,dest, 256, tlines, screen->pitch);

 if(SDL_MUSTLOCK(screen))
  SDL_UnlockSurface(screen);

 if(_fullscreen)
  SDL_UpdateRect(screen, xo, yo, 256, tlines);
 else
  SDL_UpdateRect(screen, 0, 0, 256, tlines);
}
