static int InputType[2]={DII_SETCONTROL_GAMEPAD,DII_SETCONTROL_GAMEPAD};
static int joymulti=0;
static void *InputDPtr[2];
static uint32 JSreturn;
int NoWaiting=0;

static void GetMouseData(void);


static int InitKeyboard(void)
{
  if(keyboard_init()==-1) 
  {
   puts("Error initializing keyboard.");
   return 0;
  }
  keyboard_translatekeys(TRANSLATE_CURSORKEYS | TRANSLATE_DIAGONAL);
  winit|=2;
  return 1;
}

static void DoCheatSeq(void)
{
 keyboard_close();
 vga_setmode(TEXT);

 DoConsoleCheatConfig();
 InitVideo();
 InitKeyboard();
}


#ifdef LINUX
#include "joystick.c"
#endif

static char *keys;
static int DIPS=0;
static uint8 keyonce[256];
#define KEY(__a) keys[SCANCODE_##__a]
#define keyonly(__a,__z) {if(KEY(__a)){if(!keyonce[SCANCODE_##__a]) {keyonce[SCANCODE_##__a]=1;__z}}else{keyonce[SCANCODE_##__a]=0;}}
static int JoySwap=0;

static int KeyboardUpdate(void)
{
  if(!keyboard_update()) 
   if(keys)
    return 0;

  keys=keyboard_getstate();

  keyonly(F3,LockConsole();)  
  keyonly(F4,UnlockConsole();)

  NoWaiting=0;
  if(KEY(GRAVE))
   NoWaiting=1;

  if(gametype&DSM_SPECIALSYSTEM_FDS)
  {
   keyonly(S,DriverInterface(DES_FDSSELECT,0);)
   keyonly(I,DriverInterface(DES_FDSINSERT,0);)
   keyonly(E,DriverInterface(DES_FDSEJECT,0);)
  }
 if(!(gametype&DSM_SPECIALSYSTEM_NSF))
 {
  keyonly(F9,DriverInterface(DES_SAVESNAP,0);)
 }
 else
 {
  keyonly(CURSORLEFT,DriverInterface(DES_NSFDEC,0);)
  keyonly(CURSORRIGHT,DriverInterface(DES_NSFINC,0);)
  if( KEY(ENTER)) DriverInterface(DES_NSFRES,0);
  if( KEY(CURSORUP)) DriverInterface(DES_NSFINC,0);
  if( KEY(CURSORDOWN)) DriverInterface(DES_NSFDEC,0);
 }

 keyonly(F2,DoCheatSeq();)
 keyonly(F5,DriverInterface(DES_SAVESTATE,0);)
 keyonly(F7,DriverInterface(DES_LOADSTATE,0);)
 keyonly(F10,DriverInterface(DES_RESET,0);)
 keyonly(F11,DriverInterface(DES_POWER,0);)
 if(KEY(F12) || KEY(ESCAPE)) FCEUI_CloseGame();

 if(gametype&DSM_SPECIALSYSTEM_VSUNISYSTEM)
 {
   keyonly(C,DriverInterface(DES_VSUNICOIN,0);)
   keyonly(V,DIPS^=1;DriverInterface(DES_VSUNITOGGLEDIPVIEW,0);)
   if(!(DIPS&1)) goto DIPSless;
   keyonly(1,DriverInterface(DES_VSUNIDIPSET,(void *)1);)
   keyonly(2,DriverInterface(DES_VSUNIDIPSET,(void *)2);)
   keyonly(3,DriverInterface(DES_VSUNIDIPSET,(void *)3);)
   keyonly(4,DriverInterface(DES_VSUNIDIPSET,(void *)4);)
   keyonly(5,DriverInterface(DES_VSUNIDIPSET,(void *)5);)
   keyonly(6,DriverInterface(DES_VSUNIDIPSET,(void *)6);)
   keyonly(7,DriverInterface(DES_VSUNIDIPSET,(void *)7);)
   keyonly(8,DriverInterface(DES_VSUNIDIPSET,(void *)8);)
 }
 else
 {
  keyonly(H,DriverInterface(DES_NTSCSELHUE,0);)
  keyonly(T,DriverInterface(DES_NTSCSELTINT,0);)
  if(KEY(KEYPADMINUS) || KEY(MINUS)) DriverInterface(DES_NTSCDEC,0);
  if(KEY(KEYPADPLUS) || KEY(EQUAL)) DriverInterface(DES_NTSCINC,0);

  DIPSless:
  keyonly(0,DriverInterface(DES_SELECTSTATE,(void *)0);)
  keyonly(1,DriverInterface(DES_SELECTSTATE,(void *)1);)
  keyonly(2,DriverInterface(DES_SELECTSTATE,(void *)2);)
  keyonly(3,DriverInterface(DES_SELECTSTATE,(void *)3);)
  keyonly(4,DriverInterface(DES_SELECTSTATE,(void *)4);)
  keyonly(5,DriverInterface(DES_SELECTSTATE,(void *)5);)
  keyonly(6,DriverInterface(DES_SELECTSTATE,(void *)6);)
  keyonly(7,DriverInterface(DES_SELECTSTATE,(void *)7);)
  keyonly(8,DriverInterface(DES_SELECTSTATE,(void *)8);)
  keyonly(9,DriverInterface(DES_SELECTSTATE,(void *)9);)
 }
 return 1;
}

static uint32 KeyboardDodo(void)
{
 uint32 JS=0;

 if(!(gametype&DSM_SPECIALSYSTEM_NSF))
 {
  int x,y;
  x=y=0;
  keyonly(CAPSLOCK,
                   {
                    char tmp[64];
                    JoySwap=(JoySwap+8)%32;
                    sprintf(tmp,"Joystick %d selected.",(JoySwap>>3)+1);
                    DriverInterface(DES_DISPMESSAGE,tmp);
                   })

  if(KEY(LEFTALT) || KEY(X))        JS|=JOY_A<<JoySwap;
  if(KEY(LEFTCONTROL) || KEY(SPACE) || KEY(Z) ) JS |=JOY_B<<JoySwap;
  if(KEY(ENTER))       JS |= JOY_START<<JoySwap;
  if(KEY(TAB))         JS |= JOY_SELECT<<JoySwap;
  if(KEY(CURSORDOWN))  y|= JOY_DOWN;
  if(KEY(CURSORUP))    y|= JOY_UP;
  if(KEY(CURSORLEFT))  x|= JOY_LEFT;
  if(KEY(CURSORRIGHT)) x|= JOY_RIGHT;
  if(y!=(JOY_DOWN|JOY_UP)) JS|=y<<JoySwap;
  if(x!=(JOY_LEFT|JOY_RIGHT)) JS|=x<<JoySwap;
 }
 return JS;
}

static int powerpadsc[2][12]={
                              {
                               SCANCODE_O,SCANCODE_P,SCANCODE_BRACKET_LEFT,
                               SCANCODE_BRACKET_RIGHT,SCANCODE_K,SCANCODE_L,SCANCODE_SEMICOLON,SCANCODE_APOSTROPHE,
                               SCANCODE_M,SCANCODE_COMMA,SCANCODE_PERIOD,SCANCODE_SLASH
                              },
                              {
                               SCANCODE_O,SCANCODE_P,SCANCODE_BRACKET_LEFT,
                               SCANCODE_BRACKET_RIGHT,SCANCODE_K,SCANCODE_L,SCANCODE_SEMICOLON,SCANCODE_APOSTROPHE,
                               SCANCODE_M,SCANCODE_COMMA,SCANCODE_PERIOD,SCANCODE_SLASH
                              }
                             };

static uint32 powerpadbuf[2];
static int powerpadside=0;

static uint32 UpdatePPadData(int w)
{
 static const char shifttableA[12]={8,9,0,1,11,7,4,2,10,6,5,3};
 static const char shifttableB[12]={1,0,9,8,2,4,7,11,3,5,6,10};
 uint32 r=0;
 int *ppadtsc=powerpadsc[w];
 int x;

 if(powerpadside&(1<<w))
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableA[x];
 }
 else
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableB[x];
 }
 return r;
}
void FCEUD_UpdateInput(void)
{
  int x;
  int t=0;
  static uint32 KeyBJS=0;
  uint32 JS;
  int b;

  b=KeyboardUpdate();

  for(x=0;x<2;x++)
   switch(InputType[x])
   {
    case DII_SETCONTROL_GAMEPAD:t|=1;break;
    case DII_SETCONTROL_ZAPPER:t|=2;break;
    case DII_SETCONTROL_POWERPAD:powerpadbuf[x]=UpdatePPadData(x);break;
   }
  if(t&1)
  {
   if(b)
    KeyBJS=KeyboardDodo();
   JS=KeyBJS;
   #ifdef LINUX
   if(joy[0]|joy[1]|joy[2]|joy[3])
    JS|=(uint32)GetJSOr();
   #endif
   JSreturn=(JS&0xFF000000)|(JS&0xFF)|((JS&0xFF0000)>>8)|((JS&0xFF00)<<8);
  }
  if(t&2)
   GetMouseData();
}
static uint32 MouseData[3];

static void InitMouse(void)
{
    vga_setmousesupport(1);
    mouse_setxrange(0,260);
    mouse_setyrange(0,260);
    mouse_setscale(1);
}

static void InitOtherInput(void)
{
   int t;
   int x;
   int attrib;

   DriverInputInterface(DII_SETMULTI,0,joymulti,0);

   for(t=0,x=0;x<2;x++)
   {
    attrib=0;
    switch(InputType[x])
    {
     case DII_SETCONTROL_POWERPAD:InputDPtr[x]=&powerpadbuf[x];break;
     case DII_SETCONTROL_GAMEPAD:InputDPtr[x]=((uint8 *)&JSreturn)+(x<<1);break;     
     case DII_SETCONTROL_ZAPPER:InputDPtr[x]=MouseData;
                                t|=1;
                                attrib=1;
                                break;
    }
    DriverInputInterface(DII_SETCONTROL,x,InputType[x],InputDPtr[x]);
    DriverInputInterface(DII_SETCONTROLATTRIB,x,attrib,0);
   }
   if(t)
    InitMouse();

}

static void GetMouseData(void)
{
 int z;
 mouse_update();
 MouseData[0]=mouse_getx();
 MouseData[1]=mouse_gety();
 z=mouse_getbutton();
 MouseData[2]=((z&MOUSE_LEFTBUTTON)?1:0)|((z&MOUSE_RIGHTBUTTON)?2:0);
}
