static __inline__ void port_out(int value, int port)
{
    __asm__ volatile ("outb %0,%1"
	      ::"a" ((unsigned char) value), "d"((unsigned short) port));
}

static __inline__ void port_outw(int value, int port)
{
    __asm__ volatile ("outw %0,%1"
	     ::"a" ((unsigned short) value), "d"((unsigned short) port));
}

static __inline__ void port_outl(int value, int port)
{
    __asm__ volatile ("outl %0,%1"
             ::"a" ((unsigned long)value), "d" ((unsigned short) port));
}

static __inline__ int port_in(int port)
{
    unsigned char value;
    __asm__ volatile ("inb %1,%0"
		      :"=a" (value)
		      :"d"((unsigned short) port));
    return value;
}

static __inline__ int port_inw(int port)
{
    unsigned short value;
    __asm__ volatile ("inw %1,%0"
		      :"=a" (value)
		      :"d"((unsigned short) port));
    return value;
}

static __inline__ int port_inl(int port)
{
    unsigned int value;
    __asm__ volatile("inl %1,%0" :
               	     "=a" (value) :
                     "d" ((unsigned short)port));
    return value;
}

#define inb port_in
#define inw port_inw
#define inl port_inl
#define outb(port, value) port_out(value, port)
#define outw(port, value) port_outw(value, port)
#define outl(port, value) port_outl(value, port)

#define outportb outb
#define inportb inb
#define outportw outw
#define inportw inw
#define inp inb
#define outp outb

