/** EMULib Emulation Library *********************************/
/**                                                         **/
/**                         ComUnix.c                       **/
/**                                                         **/
/** This file contains standard communication routines for  **/
/** Unix using TCP/IP via sockets.                          **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1997-1998                 **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/

#define Port 0xFCE
int RocketSocket=-1;

int FCEUD_NetworkConnect(void)
{
  struct sockaddr_in Addr;
  struct hostent *Host;
  int Socket,AddrLength,Socket1;

  /* Clear the address structure */
  memset(&Addr,0,sizeof(Addr));
 
if(netplay==2)
{
 if(!(Host=gethostbyname(netplayhost))) return(0);

 /* Set fields of the address structure */
 memcpy(&Addr.sin_addr,Host->h_addr,Host->h_length);
 Addr.sin_family = AF_INET;
 Addr.sin_port   = htons(Port);

 /* Create a socket */
 if((Socket=socket(AF_INET,SOCK_STREAM,0))<0) return(0);
 printf("Attempting to connect to %s...\n",netplayhost);

 if(connect(Socket,(struct sockaddr *)&Addr,sizeof(Addr))>=0)
 {
    /* Succesfully connected as client */
    RocketSocket=Socket;
    return(1);
  }

  /* Failed to connect as a client */
  close(Socket);
  return(0);
}
	/* Become a server, since no server was specified to connect to. */

  /* Set fields of the address structure */
  Addr.sin_addr.s_addr = htonl(INADDR_ANY);
  Addr.sin_family      = AF_INET;
  Addr.sin_port        = htons(Port);

  /* Create a socket */
  if((Socket=socket(AF_INET,SOCK_STREAM,0))<0) return(0);

  /* Bind socket */
  if(bind(Socket,(struct sockaddr *)&Addr,sizeof(Addr))<0)
  { close(Socket);return(0); }

  /* Listen for two connects, incoming and outgoing */
  listen(Socket,2);

  /* Accepting connections... */
  AddrLength=sizeof(Addr);
  printf("Acceptings connections on port %d...\n",Port);
  Socket1=accept(Socket,(struct sockaddr *)&Addr,&AddrLength);
  close(Socket);

  /* An error occurred while listening */
  if(Socket1<0) return(0);

  /* Client connected succesfully */
  RocketSocket=Socket1;
  return(1);
}

/** NetworkRecvByte() ****************************************/
/** Receive a single byte from a socket. Returns 0 on       **/
/** failure, or 1 on success.                               **/
/*************************************************************/

int FCEUD_NetworkRecvByte(unsigned char *Value)
{ 
  return(recv(RocketSocket,Value,1,0)==1);
}

/** NetworkSendByte() ****************************************/
/** Send a single byte to a socket. Returns 0 on failure,   **/
/** or 1 on success.                                        **/
/*************************************************************/

int FCEUD_NetworkSendByte(unsigned char *Value)
{ 
 return(send(RocketSocket,Value,1,0)==1); 
}

void FCEUD_NetworkClose(void)
{
 if(RocketSocket>0) shutdown(RocketSocket,2);
 RocketSocket=-1;
}
