#include <stdio.h>
#include <string.h>
#include <vga.h>

#include "../../driver.h"
#include "io.h"
#include "video.h"
#include "main.h"


int FCEUDvmode=1;
int FCEUDsrendline=8;
int FCEUDerendline=239;

#ifdef FRAMESKIP
int FCEUDfskip=0;
#endif

static int vidready=0;
static int conlock=0;

void LockConsole(void)
{
 if(!conlock)
 {
  vga_lockvc();
  conlock=1;
  DriverInterface(DES_DISPMESSAGE,"Console locked.");
 }
}

void UnlockConsole(void)
{
 if(conlock)
 {
  vga_unlockvc();
  conlock=0;
  DriverInterface(DES_DISPMESSAGE,"Console unlocked.");
 }
}


/*      Part of the VGA low-level mass register setting code derived from
	code by \Firebug\.
*/

typedef struct {
  uint8 p;
  uint8 i;
  uint8 v;
} vgareg;

vgareg v256x240[] =
{
        { 0xc2, 0x0, 0xe3},
        { 0xd4, 0x0, 0x4f},
        { 0xd4, 0x1, 0x3f},
        { 0xd4, 0x2, 0x40},
        { 0xd4, 0x3, 0x92},
        { 0xd4, 0x4, 0x44},
        { 0xd4, 0x5, 0x10},
        { 0xd4, 0x6, 0x0a},
        { 0xd4, 0x7, 0x3e},
        { 0xd4, 0x8, 0x00},
        { 0xd4, 0x9, 0x41},
        { 0xd4, 0xa, 0x00},
        { 0xd4, 0xb, 0x00},
        { 0xd4, 0xc, 0x00},
        { 0xd4, 0xd, 0x00},
        { 0xd4, 0xe, 0x00},
        { 0xd4, 0xf, 0x00},
        { 0xd4, 0x10, 0xea},
        { 0xd4, 0x11, 0xac},
        { 0xd4, 0x12, 0xdf},
        { 0xd4, 0x13, 0x20},
        { 0xd4, 0x14, 0x40},
        { 0xd4, 0x15, 0xe7},
        { 0xd4, 0x16, 0x06},
        { 0xd4, 0x17, 0xa3},
        { 0xc4, 0x1, 0x1},
        { 0xc4, 0x4, 0xe},
        { 0xce, 0x5, 0x40},
        { 0xce, 0x6, 0x5},
        { 0xc0, 0x10, 0x41},
        { 0xc0, 0x13, 0x0}
};

vgareg v256x224S[] =
{
        { 0xc2, 0x0, 0xe3},
        { 0xd4, 0x0, 0x5f},
        { 0xd4, 0x1, 0x3f},
        { 0xd4, 0x2, 0x40},
        { 0xd4, 0x3, 0x82},
        { 0xd4, 0x4, 0x4e},
        { 0xd4, 0x5, 0x96},
        { 0xd4, 0x6, 0x5},
        { 0xd4, 0x7, 0x1},
        { 0xd4, 0x8, 0x0},
        { 0xd4, 0x9, 0x40},
        { 0xd4, 0x10, 0xea},
        { 0xd4, 0x11, 0xac},
        { 0xd4, 0x12, 0xdf},
        { 0xd4, 0x13, 0x20},
        { 0xd4, 0x14, 0x40},
        { 0xd4, 0x15, 0xe7},
        { 0xd4, 0x16, 0x6},
        { 0xd4, 0x17, 0xe3},
        { 0xc4, 0x1, 0x1},
        { 0xc4, 0x4, 0xe},
        { 0xce, 0x5, 0x40},
        { 0xce, 0x6, 0x5},
        { 0xc0, 0x10, 0x41},
        { 0xc0, 0x13, 0x0}
};

vgareg v256x256[] =
{
        { 0xc2, 0x0, 0xe3},
        { 0xd4, 0x0, 0x5f},
        { 0xd4, 0x1, 0x3f},
        { 0xd4, 0x2, 0x40},
        { 0xd4, 0x3, 0x82},
        { 0xd4, 0x4, 0x4a},
        { 0xd4, 0x5, 0x9a},
        { 0xd4, 0x6, 0x23},
        { 0xd4, 0x7, 0xb2},
        { 0xd4, 0x8, 0x0},
        { 0xd4, 0x9, 0x61},
        { 0xd4, 0x10, 0xa},
        { 0xd4, 0x11, 0xac},
        { 0xd4, 0x12, 0xff},
        { 0xd4, 0x13, 0x20},
        { 0xd4, 0x14, 0x40},
        { 0xd4, 0x15, 0x7},
        { 0xd4, 0x16, 0x1a},
        { 0xd4, 0x17, 0xa3},
        { 0xc4, 0x1, 0x1},
        { 0xc4, 0x4, 0xe},
        { 0xce, 0x5, 0x40},
        { 0xce, 0x6, 0x5},
        { 0xc0, 0x10, 0x41},
        { 0xc0, 0x13, 0x0}

};

vgareg v256x256S[] =
{
  { 0xc2, 0x00, 0xe3},{ 0xd4, 0x00, 0x5F},{ 0xd4, 0x01, 0x3f},
  { 0xd4, 0x02, 0x40},{ 0xd4, 0x03, 0x82},{ 0xd4, 0x04, 0x4a},
  { 0xd4, 0x05, 0x9a},{ 0xd4, 0x06, 0x23},{ 0xd4, 0x07, 0x15},
  { 0xd4, 0x08, 0x00},{ 0xd4, 0x09, 0x60},{ 0xd4, 0x10, 0x0a},
  { 0xd4, 0x11, 0xac},{ 0xd4, 0x12, 0xff},{ 0xd4, 0x13, 0x20},
  { 0xd4, 0x14, 0x40},{ 0xd4, 0x15, 0x07},{ 0xd4, 0x16, 0x1a},
  { 0xd4, 0x17, 0xa3},{ 0xc4, 0x01, 0x01},{ 0xc4, 0x04, 0x0e},
  { 0xce, 0x05, 0x40},{ 0xce, 0x06, 0x05},{ 0xc0, 0x10, 0x41},
  { 0xc0, 0x13, 0x00}
};

void SetBorder(void)
{
 if(!conlock) 
  vga_lockvc();
 inportb(0x3da);
 outportb(0x3c0,(0x11|0x20));
 outportb(0x3c0,0x80);
 if(!conlock) 
  vga_unlockvc();
}

static void VGAPortSet(vgareg R)
{
  int p,i,v;

  p=0x300|R.p;
  i=R.i;
  v=R.v;

  switch(p)
  {
    case 0x3C0: inportb(0x3DA);
                outportb(0x3C0,i|0x20);
                outportb(0x3C0,v);
                break;
    case 0x3C2:
    case 0x3C3: outportb(p, v);
                break;
    case 0x3C4:
    case 0x3CE:
    case 0x3D4:
    default:    outportb(p,i);
                outportb(p+1,v);
                break;
  }
}

void TweakVGA(int VGAMode)
{
  int I;

  if(!conlock)
   vga_lockvc();

  outportb(0x3C8,0x00);
  for(I=0;I<768;I++) outportb(0x3C9,0x00);

  outportb(0x3D4,0x11);
  I=inportb(0x3D5)&0x7F;
  outportb(0x3D4,0x11);
  outportb(0x3D5,I);

  switch(VGAMode)
  {
    case 1:  for(I=0;I<25;I++) VGAPortSet(v256x240[I]);break;
    case 2:  for(I=0;I<25;I++) VGAPortSet(v256x256[I]);break;
    case 3:  for(I=0;I<25;I++) VGAPortSet(v256x256S[I]);break;
    case 6:  for(I=0;I<25;I++) VGAPortSet(v256x224S[I]);break;
    default: break;
  }

  outportb(0x3da,0);
  if(!conlock) 
   vga_unlockvc();
}


static uint8 palettedbr[256],palettedbg[256],palettedbb[256];

static void FlushPalette(void)
{
 int x;
 for(x=0;x<256;x++)
 {
  int z=x;
  if(FCEUDvmode==4 || FCEUDvmode==5 || FCEUDvmode==7) z^=0x80;
  vga_setpalette(z,palettedbr[x]>>2,palettedbg[x]>>2,palettedbb[x]>>2);
 }
}

void FCEUD_SetPalette(uint8 index, uint8 r, uint8 g, uint8 b)
{
  palettedbr[index]=r;
  palettedbg[index]=g;
  palettedbb[index]=b;
  if(vidready)
  {
   if(FCEUDvmode==4 || FCEUDvmode==5 || FCEUDvmode==7) index^=0x80;
   vga_setpalette(index,r>>2,g>>2,b>>2);
  }
}


void FCEUD_GetPalette(uint8 i, uint8 *r, uint8 *g, uint8 *b)
{
 *r=palettedbr[i];
 *g=palettedbg[i];
 *b=palettedbb[i];
}

static void vcfix(void)
{
 int z;

 if(!conlock)
  vga_lockvc();
 z=inportb(0x3cc);
 if(!conlock) 
  vga_unlockvc();
 if(z!=0xe3)		// Common value in all tweaked video modes(and not in 320x200 mode).
 {
  TweakVGA(FCEUDvmode);
  SetBorder();
  FlushPalette();
 }
}

static uint8 *ScreenLoc;

int InitVideo(void)
{
 vidready=0;
 switch(FCEUDvmode)
 {
  default:
  case 1:
  case 2:
  case 3:
  case 6:
	 vga_setmode(G320x200x256);
	 vidready|=1;
         ScreenLoc=vga_getgraphmem();
         TweakVGA(FCEUDvmode);
         SetBorder();
         memset(ScreenLoc,128,256*256);
         break;
  case 4:
  case 5:
         if(!(vga_getmodeinfo(G640x480x256)->flags & CAPABLE_LINEAR))
         {
          puts("Video:  No linear addressing mode available!");
          return 0;
         }
         if(vga_setmode(G640x480x256)==-1)
         {
          puts("Video:  Could not set 640x480x8bpp video mode!");
          return 0;
         }
	 vidready|=1;

         vga_setpage(0);
         if(vga_setlinearaddressing()!=-1)
          ScreenLoc=vga_getgraphmem();
         else
         {
          puts("Video:  Could not set linear addressing!");
          return 0;
         }
         memset(ScreenLoc,0,640*480);
         break;
  case 7:vga_setmode(G320x240x256V);
         vga_setlinearaddressing();
         ScreenLoc=vga_getgraphmem();
         memset(ScreenLoc,0,320*240);
         break;
 }
 vidready|=2;
 FlushPalette(); // Needed for cheat console code(and it isn't a bad thing to do anyway...).
 return 1;
}

void KillVideo(void)
{
 if(vidready)
 {
  vga_setmode(TEXT);
  vidready=0;
 }
}



void FCEUD_BlitScreen(uint8 *XBuf)
{
 static int conto=0;
 uint8 *dest;
 int tlines;

 #ifdef FRAMESKIP
 FCEUI_FrameSkip(FCEUDfskip);
 #endif

 if(FCEUDemuloptions&4 && !NoWaiting)
  vga_waitretrace();

 tlines=FCEUDerendline-FCEUDsrendline+1;

 dest=ScreenLoc;

 if(FCEUDvmode!=4 && FCEUDvmode!=5 && FCEUDvmode!=7)
 {
  conto=(conto+1)&0x3F;
  if(!conto) vcfix();
 }
 switch(FCEUDvmode)
 {
  case 1:dest+=(((240-tlines)>>1)<<8);break;
  case 2:
  case 3:dest+=(((256-tlines)>>1)<<8);break;
  case 4:
  case 5:dest+=(((240-tlines)>>1)*640+((640-512)>>1));break;
  case 6:if(tlines>224) tlines=224;dest+=(((224-tlines)>>1)<<8);break;
  case 7:dest+=(((240-tlines)>>1)*320)+32;break;
 }

 XBuf+=(FCEUDsrendline<<8)+(FCEUDsrendline<<4);

 if(FCEUDvmode==5)
 {
  asm volatile(
     "xorl %%edx, %%edx\n\t"
     "koop1:\n\t"
     "movb $128,%%al     \n\t"
     "koop2:\n\t"
     "movb 1(%%esi),%%dl\n\t"
     "shl  $16,%%edx\n\t"
     "movb (%%esi),%%dl\n\t"
     "xorl $0x00800080,%%edx\n\t"
     "movl %%edx,(%%edi)\n\t"
     "addl $2,%%esi\n\t"
     "addl $4,%%edi\n\t"
     "decb %%al\n\t"
     "jne koop2\n\t"

     "addl $16,%%esi\n\t"
     "addl $768,%%edi\n\t"
     "decb %%bl\n\t"
     "jne koop1\n\t"
     :
     : "S" (XBuf), "D" (dest), "b" (tlines)
     : "%al", "%edx", "%cc" );
 }
 else if(FCEUDvmode==4)
 {
  asm volatile(
     "yoop1:\n\t"
     "movb $128,%%al     \n\t"
     "yoop2:\n\t"
     "movb 1(%%esi),%%dh\n\t"
     "movb %%dh,%%dl\n\t"
     "shl  $16,%%edx\n\t"
     "movb (%%esi),%%dl\n\t"
     "movb %%dl,%%dh\n\t"               // Ugh
     "xorl $0x80808080,%%edx\n\t"
     "movl %%edx,(%%edi)\n\t"
     "addl $2,%%esi\n\t"
     "addl $4,%%edi\n\t"
     "decb %%al\n\t"
     "jne yoop2\n\t"

     "addl $16,%%esi\n\t"
     "addl $768,%%edi\n\t"
     "decb %%bl\n\t"
     "jne yoop1\n\t"
     :
     : "S" (XBuf), "D" (dest), "b" (tlines)
     : "%al", "%edx", "%cc" );
 }
 else if(FCEUDvmode==7)
 {
  asm volatile(
     "goop81:\n\t"
     "movl $32,%%eax\n\t"
     "goop82:\n\t"
     "movl (%%esi),%%edx\n\t"
     "movl 4(%%esi),%%ecx\n\t"
     "xorl $0x80808080,%%edx\n\t"
     "xorl $0x80808080,%%ecx\n\t"
     "movl %%edx,(%%edi)\n\t"
     "movl %%ecx,4(%%edi)\n\t"
     "addl $8,%%esi\n\t"
     "addl $8,%%edi\n\t"
     "decl %%eax\n\t"
     "jne goop82\n\t"
     "addl $64,%%edi\n\t"
     "addl $16,%%esi\n\t"
     "decb %%bl\n\t"
     "jne goop81\n\t"
     :
     : "S" (XBuf), "D" (dest), "b" (tlines)
     : "%eax","%cc","%edx","%ecx" );
 }
 else
 {
  #ifdef MOO
  uint32 *S=XBuf,*D=dest;
  int y;

  for(y=tlines;y;y--,S+=4)
  {
   int x;
   for(x=32;x;x--,S+=2,D+=2)
   { *D=*S; *(D+1)=*(S+1);}
  }  
  #endif

  asm volatile(
     "goop1:\n\t"
     "movl $32,%%eax\n\t"
     "goop2:\n\t"
     "movl (%%esi),%%edx\n\t"
     "movl 4(%%esi),%%ecx\n\t"
     "movl %%edx,(%%edi)\n\t"
     "movl %%ecx,4(%%edi)\n\t"
     "addl $8,%%esi\n\t"
     "addl $8,%%edi\n\t"
     "decl %%eax\n\t"
     "jne goop2\n\t"
     "addl $16,%%esi\n\t"
     "decb %%bl\n\t"
     "jne goop1\n\t"
     :
     : "S" (XBuf), "D" (dest), "b" (tlines)
     : "%eax","%cc","%edx","%ecx" );
 }
}


