/****************************************************************/
/*			FCE Ultra				*/
/*								*/
/*	This file contains routines for reading/writing the     */
/*	configuration file, and for getting arguments		*/
/*								*/
/****************************************************************/

#define SetValue(x,y,z) SetValueR(x,y,&z,sizeof(z))
#define SetValueString(x,y,z) SetValueR(x,y,z,strlen(z)+1)
#define SetValueArray(x,y,z,c) SetValueR(x,y,z,c)

#define GetValue(x,y,z) GetValueR(x,y,&z,sizeof(z))
#define GetValueString(x,y,z,c) GetValueR(x,y,z,0-c)
#define GetValueArray(x,y,z,c) GetValueR(x,y,z,c)

int FReadString(FILE *fp, char *str, int n)
{
 int x=0,z;
 for(;;)
 {
  z=fgetc(fp);
  str[x]=z;
  x++;
  if(z<=0) break;
  if(x>=n) return 0;
 }
 if(z<0) return 0;
 return 1;
}

void GetValueR(FILE *fp, char *str, void *v, int c)
{
 char buf[256];
 int s;

 while(FReadString(fp,buf,256))
 {
  fread(&s,1,4,fp);
  if(!strcmp(str, buf))
  {
   if(c<0)
   {    
    c=0-c;
    if(s>c)
     goto gogl;
    goto rodo;
   }
   else
    if(s>c || c<s)
    {
     gogl:
     fseek(fp,s,SEEK_CUR);
     continue;
    }
   rodo:
   fread((uint8*)v,1,c,fp);
  }
  else
   fseek(fp,s,SEEK_CUR);
 }
 fseek(fp,4,SEEK_SET);
}

void SetValueR(FILE *fp, char *str, void *v, int c)
{
 fwrite(str,1,strlen(str)+1,fp);
 fwrite((uint8*)&c,1,4,fp);
 fwrite((uint8*)v,1,c,fp);
}

void SaveConfig(char *filename)
{
FILE *fp;
int x;
char gorf[16];
fp=fopen(filename,"wb");
if(fp==NULL) return;

x=0xFCEFCE;
fwrite(&x,1,4,fp);

SetValue(fp,"palyo",palyo);
SetValue(fp,"genie",genie);
SetValue(fp,"fs",fullscreen);
SetValue(fp,"vgamode",vmod);
SetValue(fp,"sound",soundo);

SetValue(fp,"joy1",joy[0]);
SetValue(fp,"joy2",joy[1]);
SetValue(fp,"joy3",joy[2]);
SetValue(fp,"joy4",joy[3]);

for(x=0;x<4;x++)
 {
  sprintf(gorf,"joyA%d",x);
  SetValue(fp,gorf,joyA[x]);
 }
for(x=0;x<4;x++)
 {
  sprintf(gorf,"joyB%d",x);
  SetValue(fp,gorf,joyB[x]);
 }
for(x=0;x<4;x++)
 {
  sprintf(gorf,"joySelect%d",x);
  SetValue(fp,gorf,joySelect[x]);
 }
for(x=0;x<4;x++)
 {
  sprintf(gorf,"joyStart%d",x);
  SetValue(fp,gorf,joyStart[x]);
 }

DriverInterface(DES_GETNTSCTINT,&x);
SetValue(fp,"ntsctint",x);
DriverInterface(DES_GETNTSCHUE,&x);
SetValue(fp,"ntschue",x);
SetValue(fp,"ntsccol",ntsccol);
SetValueString(fp,"gfsdir",gfsdir);
SetValue(fp,"winsizemul",winsizemul);
SetValue(fp,"soundoptions",soundoptions);
SetValue(fp,"eoptions",eoptions);
SetValue(fp,"soundbufsize",soundbufsize);
SetValueArray(fp,"cpalette",cpalette,192);

SetValueArray(fp,"InputType",InputType,2*sizeof(int));
SetValue(fp,"keyben",keybEnable);

SetValueArray(fp,"keybm0",keyBMap[0],8*sizeof(int));
SetValueArray(fp,"keybm1",keyBMap[1],8*sizeof(int));
SetValueArray(fp,"keybm2",keyBMap[2],8*sizeof(int));
SetValueArray(fp,"keybm3",keyBMap[3],8*sizeof(int));

SetValue(fp,"ppaside",powerpadside);

SetValue(fp,"vmcx",vmodes[0].x);
SetValue(fp,"vmcy",vmodes[0].y);
SetValue(fp,"vmcb",vmodes[0].bpp);
SetValue(fp,"vmcf",vmodes[0].flags);
SetValue(fp,"vmcxs",vmodes[0].xscale);
SetValue(fp,"vmcys",vmodes[0].yscale);

SetValue(fp,"joyOptions",joyOptions);
SetValueArray(fp,"joyUp",joyUp,4*sizeof(int));
SetValueArray(fp,"joyDown",joyDown,4*sizeof(int));
SetValueArray(fp,"joyLeft",joyLeft,4*sizeof(int));
SetValueArray(fp,"joyRight",joyRight,4*sizeof(int));

SetValue(fp,"srendline",srendline);
SetValue(fp,"erendline",erendline);
SetValue(fp,"JoyMulti",JoyMulti);
SetValue(fp,"soundrate",soundrate);
fclose(fp);
}

void LoadConfig(char *filename)
{
FILE *fp;
char gorf[16];
int x;

fp=fopen(filename,"rb");
if(fp==NULL) return;

fread(&x,1,4,fp);
if(x!=0xFCEFCE) return;

GetValue(fp,"palyo",palyo);
palyo&=1;
FCEUI_SetVidSystem(palyo);

GetValue(fp,"genie",genie);
genie&=1;
FCEUI_SetGameGenie(genie);
GetValue(fp,"fs",fullscreen);
fullscreen&=1;
GetValue(fp,"vgamode",vmod);
GetValue(fp,"sound",soundo);
soundo&=1;

GetValue(fp,"joy1",joy[0]);
GetValue(fp,"joy2",joy[1]);
GetValue(fp,"joy3",joy[2]);
GetValue(fp,"joy4",joy[3]);
for(x=0;x<4;x++)
 {
  sprintf(gorf,"joyA%d",x);
  GetValue(fp,gorf,joyA[x]);
 }
for(x=0;x<4;x++)
 {
  sprintf(gorf,"joyB%d",x);
  GetValue(fp,gorf,joyB[x]);
 }
for(x=0;x<4;x++)
 {
  sprintf(gorf,"joySelect%d",x);
  GetValue(fp,gorf,joySelect[x]);
 }
for(x=0;x<4;x++)
 {
  sprintf(gorf,"joyStart%d",x);
  GetValue(fp,gorf,joyStart[x]);
 }

GetValue(fp,"ntsccol",ntsccol);
DriverInterface(DES_NTSCCOL,&ntsccol);
GetValue(fp,"ntsctint",x);
DriverInterface(DES_SETNTSCTINT,&x);
GetValue(fp,"ntschue",x);
DriverInterface(DES_SETNTSCHUE,&x);
GetValueString(fp,"gfsdir",gfsdir,2048);
GetValue(fp,"winsizemul",winsizemul);
GetValue(fp,"soundoptions",soundoptions);
GetValue(fp,"eoptions",eoptions);
GetValue(fp,"soundbufsize",soundbufsize);
GetValueArray(fp,"cpalette",cpalette,192);

GetValueArray(fp,"InputType",InputType,2*sizeof(int));
GetValue(fp,"keyben",keybEnable);
GetValueArray(fp,"keybm0",keyBMap[0],8*sizeof(int));
GetValueArray(fp,"keybm1",keyBMap[1],8*sizeof(int));
GetValueArray(fp,"keybm2",keyBMap[2],8*sizeof(int));
GetValueArray(fp,"keybm3",keyBMap[3],8*sizeof(int));
GetValueArray(fp,"ppasc0",powerpadsc[0],12*sizeof(int));
GetValueArray(fp,"ppasc1",powerpadsc[1],12*sizeof(int));
GetValue(fp,"ppaside",powerpadside);

GetValue(fp,"vmcx",vmodes[0].x);
GetValue(fp,"vmcy",vmodes[0].y);
GetValue(fp,"vmcb",vmodes[0].bpp);
GetValue(fp,"vmcf",vmodes[0].flags);
GetValue(fp,"vmcxs",vmodes[0].xscale);
GetValue(fp,"vmcys",vmodes[0].yscale);

GetValue(fp,"joyOptions",joyOptions);
GetValueArray(fp,"joyUp",joyUp,4*sizeof(int));
GetValueArray(fp,"joyDown",joyDown,4*sizeof(int));
GetValueArray(fp,"joyLeft",joyLeft,4*sizeof(int));
GetValueArray(fp,"joyRight",joyRight,4*sizeof(int));
GetValue(fp,"srendline",srendline);
GetValue(fp,"erendline",erendline);
GetValue(fp,"JoyMulti",JoyMulti);
GetValue(fp,"soundrate",soundrate);
fclose(fp);
}
