GUID joyGUID[64];

static int joycounter;

LPDIRECTINPUTDEVICE2 lpJoy[4]={0,0,0,0};

int JoyXMax[4];
int JoyXMin[4];

int JoyYMax[4];
int JoyYMin[4];

DIJOYSTATE2 JoyStatus;

static void ShowDIJErr(int w, char *s)
{
 char tempo[128];
 sprintf(tempo,"DirectInput: Joystick %d: %s",w+1,s);
 FCEUD_PrintError(tempo);
}

void JoyAutoRestore(HRESULT ddrval,LPDIRECTINPUTDEVICE2 lpJJoy)
{
   switch(ddrval)
    {
     case DIERR_INPUTLOST:
     case DIERR_NOTACQUIRED:
                           IDirectInputDevice2_Acquire(lpJJoy);
                           break;
    }
}
int GetJoystickButton(int x)
{
 int errc=0;
 int z;

 if(lpJoy[x])
 {
   doagaino:
   if(errc>8) return(-1);

   ddrval=IDirectInputDevice2_Poll(lpJoy[x]);
   if(ddrval!=DD_OK) {JoyAutoRestore(ddrval,lpJoy[x]);errc++;goto doagaino;}

   ddrval=IDirectInputDevice2_GetDeviceState(lpJoy[x],sizeof(JoyStatus),&JoyStatus);
   if(ddrval!=DD_OK) {JoyAutoRestore(ddrval,lpJoy[x]);errc++;goto doagaino;}

   for(z=0;z<128;z++)
    if(JoyStatus.rgbButtons[z]&0x80)
     return z;
 }
 return(-1);
}

uint32 GetJSOr(void)
{
unsigned long ret;
int x;
ret=0;

for(x=0;x<4;x++)
 {
 if(lpJoy[x])
  {

   ddrval=IDirectInputDevice2_Poll(lpJoy[x]);
   if(ddrval!=DD_OK) JoyAutoRestore(ddrval,lpJoy[x]);

   ddrval=IDirectInputDevice2_GetDeviceState(lpJoy[x],sizeof(JoyStatus),&JoyStatus);
   if(ddrval!=DD_OK) JoyAutoRestore(ddrval,lpJoy[x]);

   if(joyOptions[x]&1)
   {
    if(JoyStatus.rgbButtons[joyUp[x]&127]&0x80) ret|=JOY_UP<<(x<<3);
    if(JoyStatus.rgbButtons[joyDown[x]&127]&0x80) ret|=JOY_DOWN<<(x<<3);
    if(JoyStatus.rgbButtons[joyLeft[x]&127]&0x80) ret|=JOY_LEFT<<(x<<3);
    if(JoyStatus.rgbButtons[joyRight[x]&127]&0x80) ret|=JOY_RIGHT<<(x<<3);
   }
   else
   {
    if(JoyStatus.lX>=JoyXMax[x])
     ret|=JOY_RIGHT<<(x<<3);
    else if(JoyStatus.lX<=JoyXMin[x])
     ret|=JOY_LEFT<<(x<<3);

    if(JoyStatus.lY>=JoyYMax[x])
     ret|=JOY_DOWN<<(x<<3);
    else if(JoyStatus.lY<=JoyYMin[x])
     ret|=JOY_UP<<(x<<3);
   }
   if(JoyStatus.rgbButtons[joyA[x]&127]&0x80) ret|=1<<(x<<3);
   if(JoyStatus.rgbButtons[joyB[x]&127]&0x80) ret|=2<<(x<<3);
   if(JoyStatus.rgbButtons[joySelect[x]&127]&0x80) ret|=4<<(x<<3);
   if(JoyStatus.rgbButtons[joyStart[x]&127]&0x80) ret|=8<<(x<<3);
  }
 }
return ret;
}

void KillJoystick(int w)
{
 if(lpJoy[w])
 {
  IDirectInputDevice2_Unacquire(lpJoy[w]);
  IDirectInputDevice2_Release(lpJoy[w]);
  lpJoy[w]=0;
 }
}
HRESULT IDirectInput_CreateDevice2(LPDIRECTINPUT pdi,
                                   REFGUID rguid,
                                   LPDIRECTINPUTDEVICE2 *ppdev2,
                                   LPUNKNOWN punkOuter)
{
    LPDIRECTINPUTDEVICE pdev;
    HRESULT hres;

    hres = IDirectInput_CreateDevice(pdi, rguid, &pdev, punkOuter);

    if (SUCCEEDED(hres)) {
    hres = pdev->lpVtbl->QueryInterface(pdev,
                       &IID_IDirectInputDevice2,
                              (LPVOID *)ppdev2);
    IDirectInputDevice_Release(pdev);
    } else {
    *ppdev2 = 0;
    }
    return hres;
}


void KillJoysticks(void)
{
 int x;
 for(x=0;x<4;x++)
  KillJoystick(x);
}

BOOL CALLBACK JoystickFound(LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef)
{
   if(joycounter<64)
   {
    joyGUID[joycounter]=lpddi->guidInstance;
    joycounter++;
    if(pvRef)
    {
     SendDlgItemMessage(pvRef,106,CB_ADDSTRING,0,(LPARAM)(LPSTR)lpddi->tszProductName);
     SendDlgItemMessage(pvRef,112,CB_ADDSTRING,0,(LPARAM)(LPSTR)lpddi->tszProductName);
    }
    return DIENUM_CONTINUE;
   }
   else
    return 0;   
}

void InitJoystick(int w, HWND wnd)
{
  if(joy[w])
  {
   if(joy[w]>joycounter)
   {
    ShowDIJErr(w,"Not found."); 
    joy[w]=0;
    return;
   }
   ddrval=IDirectInput_CreateDevice2(lpDI, &joyGUID[joy[w]-1],&lpJoy[w],0);
   if(ddrval != DI_OK)
   {   
    ShowDIJErr(w,"Error creating device.");
    joy[w]=0;
    return;
   }
   ddrval=IDirectInputDevice2_SetCooperativeLevel(lpJoy[w],wnd,DISCL_FOREGROUND|DISCL_NONEXCLUSIVE);
   if (ddrval != DI_OK)
   {
    ShowDIJErr(w,"Error setting cooperative level.");
    KillJoystick(w);
    joy[w]=0;
    return;
   }
   ddrval=IDirectInputDevice2_SetDataFormat(lpJoy[w],&c_dfDIJoystick2);
   if (ddrval != DI_OK)
   {
    ShowDIJErr(w,"Error setting data format.");
    KillJoystick(w);
    joy[w]=0;
    return;
   }

   {
    DIPROPRANGE diprg;
    int r;

    memset(&diprg,0,sizeof(DIPROPRANGE));
    diprg.diph.dwSize=sizeof(DIPROPRANGE);
    diprg.diph.dwHeaderSize=sizeof(DIPROPHEADER);
    diprg.diph.dwHow=DIPH_BYOFFSET;
    diprg.diph.dwObj=DIJOFS_X;
    ddrval=IDirectInputDevice2_GetProperty(lpJoy[w],DIPROP_RANGE,&diprg.diph);
    if(ddrval!=DI_OK)
    {
     ShowDIJErr(w,"Error getting X axis range.");
     joy[w]=0;
     KillJoystick(w);
     joy[w]=0;
     return;
    }
    r=diprg.lMax-diprg.lMin;
    JoyXMax[w]=diprg.lMax-(r>>2);
    JoyXMin[w]=diprg.lMin+(r>>2);

    memset(&diprg,0,sizeof(DIPROPRANGE));
    diprg.diph.dwSize=sizeof(DIPROPRANGE);
    diprg.diph.dwHeaderSize=sizeof(DIPROPHEADER);
    diprg.diph.dwHow=DIPH_BYOFFSET;
    diprg.diph.dwObj=DIJOFS_Y;
    ddrval=IDirectInputDevice2_GetProperty(lpJoy[w],DIPROP_RANGE,&diprg.diph);
    if(ddrval!=DI_OK)
    {
     ShowDIJErr(w,"Error getting X axis range.");
     KillJoystick(w);
     joy[w]=0;
     return;
    }
    r=diprg.lMax-diprg.lMin;
    JoyYMax[w]=diprg.lMax-(r>>2);
    JoyYMin[w]=diprg.lMin+(r>>2);
   }

  }
}

void InitJoysticks(void)
{
 int x;

 joycounter=0;
 IDirectInput_EnumDevices(lpDI, DIDEVTYPE_JOYSTICK,JoystickFound,0,DIEDFL_ATTACHEDONLY);
 
 for(x=0;x<4;x++)
  InitJoystick(x,hAppWnd);
}
static void SetJoyCoopWindow(HWND wnd)
{
 int x;

 for(x=0;x<4;x++)
  if(lpJoy[x])
  {
   IDirectInputDevice2_Unacquire(lpJoy[x]);
   IDirectInputDevice2_SetCooperativeLevel(lpJoy[x],wnd,DISCL_FOREGROUND|DISCL_NONEXCLUSIVE);
   IDirectInputDevice2_Acquire(lpJoy[x]);
  }
}


static int joyconport;

BOOL CALLBACK JoyConCallB(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  char tempo[64];
  int x;
  switch(uMsg) {
   case WM_INITDIALOG:
                SetJoyCoopWindow(hwndDlg);

                SendDlgItemMessage(hwndDlg,106,CB_ADDSTRING,0,(LPARAM)(LPSTR)"<none>");
                SendDlgItemMessage(hwndDlg,112,CB_ADDSTRING,0,(LPARAM)(LPSTR)"<none>");

                sprintf(tempo,"Virtual Gamepad %d",joyconport+1);
                SetDlgItemText(hwndDlg,102,tempo);
                sprintf(tempo,"Virtual Gamepad %d",joyconport+3);
                SetDlgItemText(hwndDlg,104,tempo);

                for(x=0;x<=2;x+=2)
                {
                 SetDlgItemInt(hwndDlg,200+(x<<2),joySelect[x+joyconport],0);
                 SetDlgItemInt(hwndDlg,201+(x<<2),joyStart[x+joyconport],0);
                 SetDlgItemInt(hwndDlg,202+(x<<2),joyB[x+joyconport],0);
                 SetDlgItemInt(hwndDlg,203+(x<<2),joyA[x+joyconport],0);

                 SetDlgItemInt(hwndDlg,204+(x<<2),joyUp[x+joyconport],0);
                 SetDlgItemInt(hwndDlg,205+(x<<2),joyDown[x+joyconport],0);
                 SetDlgItemInt(hwndDlg,206+(x<<2),joyLeft[x+joyconport],0);
                 SetDlgItemInt(hwndDlg,207+(x<<2),joyRight[x+joyconport],0);

                }
                joycounter=0;
                IDirectInput_EnumDevices(lpDI, DIDEVTYPE_JOYSTICK,JoystickFound,hwndDlg,DIEDFL_ATTACHEDONLY);

                SendDlgItemMessage(hwndDlg,106,CB_SETCURSEL,joy[0+joyconport],(LPARAM)(LPSTR)0);
                SendDlgItemMessage(hwndDlg,112,CB_SETCURSEL,joy[2+joyconport],(LPARAM)(LPSTR)0);
                
                if(joyOptions[joyconport]&1)
                 CheckDlgButton(hwndDlg,300,BST_CHECKED);
                if(joyOptions[joyconport+2]&1)
                 CheckDlgButton(hwndDlg,301,BST_CHECKED);               
                break;
   case WM_CLOSE:
   case WM_QUIT: goto gornk;
   case WM_COMMAND:
                if(HIWORD(wParam)==EN_SETFOCUS)
                {
                 switch(LOWORD(wParam))
                 {
                  int z;

                  case 200 ... 207:
                           z=GetJoystickButton(joyconport);
                           if(z!=-1)
                            SetDlgItemInt(hwndDlg,LOWORD(wParam),z,0);
                           break;
                  case 208 ... 215:
                           z=GetJoystickButton(2+joyconport);
                           if(z!=-1)
                            SetDlgItemInt(hwndDlg,LOWORD(wParam),z,0);
                           break;
                 }
                }
                if(HIWORD(wParam)==CBN_SELENDOK)
                {
                 switch(LOWORD(wParam))
                 {
                  case 106:
                   KillJoystick(joyconport);
                   joy[0+(joyconport)]=SendDlgItemMessage(hwndDlg,106,CB_GETCURSEL,0,(LPARAM)(LPSTR)0);
                   InitJoystick(joyconport,hwndDlg);
                   SendDlgItemMessage(hwndDlg,106,CB_SETCURSEL,joy[0+joyconport],(LPARAM)(LPSTR)0);
                   break;
                  case 112:
                   KillJoystick(2+joyconport);
                   joy[2+(joyconport)]=SendDlgItemMessage(hwndDlg,112,CB_GETCURSEL,0,(LPARAM)(LPSTR)0);
                   InitJoystick(2+joyconport,hwndDlg);                                      
                   SendDlgItemMessage(hwndDlg,112,CB_SETCURSEL,joy[2+joyconport],(LPARAM)(LPSTR)0);
                   break;
                 }
                }

                if(!(wParam>>16))
                switch(wParam&0xFFFF)
                {
                 case 1:
                        gornk:

                        for(x=0;x<=2;x+=2)
                        {
                         joySelect[x+(joyconport)]=GetDlgItemInt(hwndDlg,200+(x<<2),0,0);
                         joyStart[x+(joyconport)]=GetDlgItemInt(hwndDlg,201+(x<<2),0,0);
                         joyB[x+(joyconport)]=GetDlgItemInt(hwndDlg,202+(x<<2),0,0);
                         joyA[x+(joyconport)]=GetDlgItemInt(hwndDlg,203+(x<<2),0,0);

                         joyUp[x+(joyconport)]=GetDlgItemInt(hwndDlg,204+(x<<2),0,0);
                         joyDown[x+(joyconport)]=GetDlgItemInt(hwndDlg,205+(x<<2),0,0);
                         joyLeft[x+(joyconport)]=GetDlgItemInt(hwndDlg,206+(x<<2),0,0);
                         joyRight[x+(joyconport)]=GetDlgItemInt(hwndDlg,207+(x<<2),0,0);
                        }
                        if(IsDlgButtonChecked(hwndDlg,300)==BST_CHECKED)
                         joyOptions[joyconport]|=1;
                        else
                         joyOptions[joyconport]&=~1;
                        if(IsDlgButtonChecked(hwndDlg,301)==BST_CHECKED)
                         joyOptions[joyconport+2]|=1;
                        else
                         joyOptions[joyconport+2]&=~1;                        
                        EndDialog(hwndDlg,0);
                        SetJoyCoopWindow(hAppWnd);
                        break;
               }
              }
  return 0;
}

void ConfigJoystickies(int port)
{
 joyconport=port;
 DialogBox(fceu_hInstance,"JOYCONFIG",hAppWnd,JoyConCallB); 
}

