LPDIRECTINPUTDEVICE lpdid=0;

int InitDInput(void)
{
 ddrval=DirectInputCreate(fceu_hInstance,DIRECTINPUT_VERSION,&lpDI,0);
 if(ddrval!=DI_OK)
 {
  FCEUD_PrintError("DirectInput: Error creating DirectInput object.");
  return 0;
 }
 return 1;
}

static int _zoit;

static void KeyboardClose(void)
{
 if(lpdid) IDirectInputDevice_Unacquire(lpdid);
 lpdid=0;
}

static char keys[256];
static void KeyboardUpdateState(void)
{
 ddrval=IDirectInputDevice_GetDeviceState(lpdid,256,keys);
 switch(ddrval)
  {
   case DIERR_INPUTLOST:
   case DIERR_NOTACQUIRED:
                         IDirectInputDevice_Acquire(lpdid);
                         break;
  }
}

int KeyboardInitialize(void)
{

 ddrval=IDirectInput_CreateDevice(lpDI, &GUID_SysKeyboard,&lpdid,0);
 if(ddrval != DI_OK)
 {
  FCEUD_PrintError("DirectInput: Error creating keyboard device.");
  return 0;
 }

 ddrval=IDirectInputDevice_SetCooperativeLevel(lpdid, hAppWnd,DISCL_FOREGROUND|DISCL_NONEXCLUSIVE);
 if(ddrval != DI_OK)
 {
  FCEUD_PrintError("DirectInput: Error setting keyboard cooperative level.");
  return 0;
 }

 ddrval=IDirectInputDevice_SetDataFormat(lpdid,&c_dfDIKeyboard);
 if(ddrval != DI_OK)
 {
  FCEUD_PrintError("DirectInput: Error setting keyboard data format.");
  return 0;
 }

 ddrval=IDirectInputDevice_Acquire(lpdid);
 if(ddrval != DI_OK)
 {
  FCEUD_PrintError("DirectInput: Error acquiring keyboard.");
  return 0;
 }
 return 1;
}

static int DIPS=0;
static uint8 keyonce[256];
#define KEY(__a) keys[SCANCODE_##__a]
#define keyonly(__a,__z) {if(KEY(__a)){if(!keyonce[SCANCODE_##__a]) {keyonce[SCANCODE_##__a]=1;__z}} else{keyonce[SCANCODE_##__a]=0;}}

static void KeyboardUpdate(void)
{ 
 KeyboardUpdateState();

 NoWaiting=0;
 if(KEY(GRAVE))
  NoWaiting=1;

 if(gameloaded)
 {
  if(gametype&DSM_SPECIALSYSTEM_FDS)
  {
   keyonly(S,DriverInterface(DES_FDSSELECT,0);)
   keyonly(I,DriverInterface(DES_FDSINSERT,0);)
   keyonly(E,DriverInterface(DES_FDSEJECT,0);)
  }

  if(!(gametype&DSM_SPECIALSYSTEM_NSF))
  {
   keyonly(F9,DriverInterface(DES_SAVESNAP,0);)
  }

  keyonly(F5,DriverInterface(DES_SAVESTATE,0);)
  keyonly(F7,DriverInterface(DES_LOADSTATE,0);)

  if(gametype&DSM_SPECIALSYSTEM_VSUNISYSTEM)
  {
   keyonly(C,DriverInterface(DES_VSUNICOIN,0);)
   keyonly(V,DIPS^=1;DriverInterface(DES_VSUNITOGGLEDIPVIEW,0);)
   if(!(DIPS&1)) goto DIPSless;
   keyonly(1,DriverInterface(DES_VSUNIDIPSET,(void *)1);)
   keyonly(2,DriverInterface(DES_VSUNIDIPSET,(void *)2);)
   keyonly(3,DriverInterface(DES_VSUNIDIPSET,(void *)3);)
   keyonly(4,DriverInterface(DES_VSUNIDIPSET,(void *)4);)
   keyonly(5,DriverInterface(DES_VSUNIDIPSET,(void *)5);)
   keyonly(6,DriverInterface(DES_VSUNIDIPSET,(void *)6);)
   keyonly(7,DriverInterface(DES_VSUNIDIPSET,(void *)7);)
   keyonly(8,DriverInterface(DES_VSUNIDIPSET,(void *)8);)
  }
  else
  {
   keyonly(H,DriverInterface(DES_NTSCSELHUE,0);)
   keyonly(T,DriverInterface(DES_NTSCSELTINT,0);)
   if(KEY(KEYPADMINUS) || KEY(MINUS)) DriverInterface(DES_NTSCDEC,0);
   if(KEY(KEYPADPLUS) || KEY(EQUAL)) DriverInterface(DES_NTSCINC,0);

   DIPSless:
   keyonly(0,DriverInterface(DES_SELECTSTATE,(void *)0);)
   keyonly(1,DriverInterface(DES_SELECTSTATE,(void *)1);)
   keyonly(2,DriverInterface(DES_SELECTSTATE,(void *)2);)
   keyonly(3,DriverInterface(DES_SELECTSTATE,(void *)3);)
   keyonly(4,DriverInterface(DES_SELECTSTATE,(void *)4);)
   keyonly(5,DriverInterface(DES_SELECTSTATE,(void *)5);)
   keyonly(6,DriverInterface(DES_SELECTSTATE,(void *)6);)
   keyonly(7,DriverInterface(DES_SELECTSTATE,(void *)7);)
   keyonly(8,DriverInterface(DES_SELECTSTATE,(void *)8);)
   keyonly(9,DriverInterface(DES_SELECTSTATE,(void *)9);)
  }
 }
}

static uint32 KeyboardDodo(void)
{
 uint32 JS=0;

 if(!(gametype&DSM_SPECIALSYSTEM_NSF))
 {
  int x,y,u,b;

  keyonly(F9,DriverInterface(DES_SAVESNAP,0);)

  for(u=0;u<4;u++)
  {
   if(keybEnable&(1<<u))
   {
    int *tmpo=keyBMap[u];
    x=y=0;

    for(b=3;b>=0;b--)
     if(keys[tmpo[b]]) JS|=(1<<b)<<(u<<3);

    if(keys[tmpo[4]])    y|= JOY_UP;
    if(keys[tmpo[5]])  y|= JOY_DOWN;
    if(keys[tmpo[6]])  x|= JOY_LEFT;
    if(keys[tmpo[7]]) x|= JOY_RIGHT;

    if(y!=(JOY_DOWN|JOY_UP)) JS|=y<<(u<<3);
    if(x!=(JOY_LEFT|JOY_RIGHT)) JS|=x<<(u<<3);
   }
  }
 }
 return JS;
}

static uint32 UpdatePPadData(int w)
{
 static const char shifttableA[12]={8,9,0,1,11,7,4,2,10,6,5,3};
 static const char shifttableB[12]={1,0,9,8,2,4,7,11,3,5,6,10};
 uint32 r=0;
 int *ppadtsc=powerpadsc[w];
 int x;

 if(powerpadside&(1<<w))
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableA[x];
 }
 else
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableB[x];
 }
 return r;
}


static int inkeyloop=0;

BOOL CALLBACK KeyConCallB(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  int x,y;
  char tempo[64];

  switch(uMsg) {
   case WM_USER+666:
                   if(inkeyloop)
                   {
                    SetDlgItemInt(hwndDlg,inkeyloop,lParam,0);
                    inkeyloop=0;
                   }                   
                   break;
   case WM_INITDIALOG:
                sprintf(tempo,"Virtual Gamepad %d",_zoit+1);
                SetDlgItemText(hwndDlg,302,tempo);
                sprintf(tempo,"Virtual Gamepad %d",_zoit+3);
                SetDlgItemText(hwndDlg,311,tempo);

                for(x=0;x<2;x++)
                {
                 for(y=0;y<8;y++)
                  SetDlgItemInt(hwndDlg,600+y+x*10,keyBMap[_zoit+(x<<1)][y],0);
                 if(keybEnable&(1<<((x<<1)+_zoit)))
                  CheckDlgButton(hwndDlg,320+x,BST_CHECKED);
                }
                break;
   case WM_CLOSE:
   case WM_QUIT: goto gornk;
   case WM_COMMAND:
                  if(!(wParam>>16))
                  {
                   wParam&=0xFFFF;
                   if((wParam>=600 && wParam<=607) || (wParam>=610 && wParam<=617))
                    inkeyloop=wParam;
                   else switch(wParam)
                   {                    
                    case 1:
                           gornk:
                           for(x=0;x<2;x++)
                           {
                            for(y=0;y<8;y++)
                             keyBMap[_zoit+(x<<1)][y]=GetDlgItemInt(hwndDlg,600+y+x*10,0,0);

                            if(IsDlgButtonChecked(hwndDlg,320+x)==BST_CHECKED)
                             keybEnable|=(1<<((x<<1)+_zoit));
                            else
                             keybEnable&=~(1<<((x<<1)+_zoit));
                           }

                           EndDialog(hwndDlg,0);
                           break;
                   }  
                  }
              }
  return 0;
}

BOOL CALLBACK KeyPPConCallB(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  int x;
  char tempo[64];

  switch(uMsg) {
   case WM_USER+666:
                   if(inkeyloop)
                   {
                    SetDlgItemInt(hwndDlg,inkeyloop,lParam,0);
                    inkeyloop=0;
                   }                   
                   break;
   case WM_INITDIALOG:
                for(x=0;x<12;x++)
                 SetDlgItemInt(hwndDlg,500+x,powerpadsc[_zoit][x],0);
                CheckDlgButton(hwndDlg,300+((powerpadside>>_zoit)&1),BST_CHECKED);
                sprintf(tempo,"Virtual Power Pad %d",_zoit+1);
                SetDlgItemText(hwndDlg,302,tempo);
                break;
   case WM_CLOSE:
   case WM_QUIT: goto gornk;
   case WM_COMMAND:
                  if(!(wParam>>16))
                  {                   
                   wParam&=0xFFFF;
                   if(wParam>=500 && wParam<=511)
                    inkeyloop=wParam;
                   else switch(wParam)
                   {                    
                    case 1:
                           gornk:
                           for(x=0;x<12;x++)
                            powerpadsc[_zoit][x]=GetDlgItemInt(hwndDlg,500+x,0,0);
                           powerpadside&=~(1<<_zoit);
                           if(IsDlgButtonChecked(hwndDlg,301)==BST_CHECKED)
                            powerpadside|=1<<_zoit;
                           EndDialog(hwndDlg,0);
                           break;
                   }  
                  }
              }
  return 0;
}

HHOOK hHook;
static LRESULT CALLBACK FilterFunc(int nCode, WORD wParam, DWORD lParam)
{
 MSG FAR *ptrMsg;
 LPARAM tmpo;

 if(nCode>=0)
 {
  if(nCode==MSGF_DIALOGBOX)
  {
   ptrMsg=(MSG FAR *)lParam;
   if(ptrMsg->message==WM_KEYDOWN || ptrMsg->message==WM_SYSKEYDOWN)
   {
    tmpo=((ptrMsg->lParam>>16)&0x7F)|((ptrMsg->lParam>>17)&0x80);
    PostMessage(GetParent(ptrMsg->hwnd),WM_USER+666,0,tmpo);
    if(inkeyloop) return 1;
   }
  }
 }
 return CallNextHookEx(hHook,nCode,wParam,lParam);
}


static void ConfigKeyboardie(int port)
{
 _zoit=port;

 hHook=SetWindowsHookEx(WH_MSGFILTER,(HOOKPROC)FilterFunc,fceu_hInstance,GetCurrentThreadId());
 DialogBox(fceu_hInstance,"KEYCONFIG",hAppWnd,KeyConCallB);
 UnhookWindowsHookEx(hHook);
}

static void ConfigKeyboardiePowerpad(int port)
{
 _zoit=port;

 hHook=SetWindowsHookEx(WH_MSGFILTER,(HOOKPROC)FilterFunc,fceu_hInstance,GetCurrentThreadId());
 DialogBox(fceu_hInstance,"KEYPPCONFIG",hAppWnd,KeyPPConCallB);
 UnhookWindowsHookEx(hHook);
}
