#include <stdio.h>
#include <windows.h>
#include <windowsx.h>
#include <winsock.h>
#include <mmsystem.h>
#include <directx.h>
#include <dir.h>
#include <commctrl.h>
#undef byte
#include "../../driver.h"
#include "keyscan.h"


void ResetVideo(void);
void ShowCursorAbs(int w);
void HideFWindow(int h);
int SetMainWindowStuff(void);
int GetClientAbsRect(LPRECT lpRect);
void UpdateFCEUWindow(void);
static void CreateInputStuff(void);

LPDIRECTINPUT lpDI;
HINSTANCE fceu_hInstance;
HRESULT  ddrval;
HANDLE ThreadHandle;

static char TempArray[2048];
static char _BaseDirectory[2048];

void CreateDirs(void)
{
 mkdir(_BaseDirectory);
 sprintf(TempArray,"%s\\fcs",_BaseDirectory);
 mkdir(TempArray);
 sprintf(TempArray,"%s\\snaps",_BaseDirectory);
 mkdir(TempArray);
 sprintf(TempArray,"%s\\gameinfo",_BaseDirectory);
 mkdir(TempArray);
 sprintf(TempArray,"%s\\sav",_BaseDirectory);
 mkdir(TempArray);
 sprintf(TempArray,"%s\\cheats",_BaseDirectory);
 mkdir(TempArray);
}

static char gfsdir[2048];
void GetBaseDirectory(void)
{
 int x;
 _BaseDirectory[0]=0;
 GetModuleFileName(0,(LPTSTR)_BaseDirectory,2047);

 for(x=strlen(_BaseDirectory);x>=0;x--)
 {
  if(_BaseDirectory[x]=='\\' || _BaseDirectory[x]=='/')
   {_BaseDirectory[x]=0;break;}
 }
 FCEUI_SetBaseDirectory(_BaseDirectory);
}

void BlockingCheck(void)
{
  MSG msg;
  while( PeekMessage( &msg, 0, 0, 0, PM_NOREMOVE ) ) {
     if( GetMessage( &msg, 0,  0, 0)>0 )
     {
     TranslateMessage(&msg);
     DispatchMessage(&msg);          
     }
   } 
}

#define JOY_A   1
#define JOY_B   2
#define JOY_SELECT      4
#define JOY_START       8
#define JOY_UP  0x10
#define JOY_DOWN        0x20
#define JOY_LEFT        0x40
#define JOY_RIGHT       0x80

int JoyMulti=0;
int joyOptions[4]={0,0,0,0};
int joyA[4]={1,1,1,1};
int joyB[4]={0,0,0,0};
int joySelect[4]={2,2,2,2};
int joyStart[4]={3,3,3,3};
int joyUp[4]={4,4,4,4};
int joyDown[4]={5,5,5,5};
int joyLeft[4]={6,6,6,6};
int joyRight[4]={7,7,7,7};

int joy[4]={0,0,0,0};


int keyBMap[4][8]={
                   {SCANCODE_LEFTALT,SCANCODE_LEFTCONTROL,SCANCODE_TAB,SCANCODE_ENTER,SCANCODE_CURSORUP,SCANCODE_CURSORDOWN,SCANCODE_CURSORLEFT,SCANCODE_CURSORRIGHT},
                   {SCANCODE_LEFTALT,SCANCODE_LEFTCONTROL,SCANCODE_TAB,SCANCODE_ENTER,SCANCODE_CURSORUP,SCANCODE_CURSORDOWN,SCANCODE_CURSORLEFT,SCANCODE_CURSORRIGHT},
                   {SCANCODE_LEFTALT,SCANCODE_LEFTCONTROL,SCANCODE_TAB,SCANCODE_ENTER,SCANCODE_CURSORUP,SCANCODE_CURSORDOWN,SCANCODE_CURSORLEFT,SCANCODE_CURSORRIGHT},
                   {SCANCODE_LEFTALT,SCANCODE_LEFTCONTROL,SCANCODE_TAB,SCANCODE_ENTER,SCANCODE_CURSORUP,SCANCODE_CURSORDOWN,SCANCODE_CURSORLEFT,SCANCODE_CURSORRIGHT}
                  };
int keybEnable=1;

HWND hAppWnd=0;


//static int fkeys[];
#define FFK_SAVESTATE   0
#define FFK_LOADSTATE   1
#define FFK_RESET       2
#define FFK_POWER       3
#define FFK_FASTF       4
#define FFK_FDSSEL      5
#define FFK_FDSINS      6
#define FFK_FDSEJ       7
#define FFK_SNAPSHOT    8
#define FFK_VSCOIN      9
#define FFK_VSTOGDS     10
#define FFK_VSVIEWDIP   11
#define FFK_VSDIP1      12
#define FFK_VSDIP2      13
#define FFK_VSDIP3      14
#define FFK_VSDIP4      15
#define FFK_VSDIP5      16
#define FFK_VSDIP6      17
#define FFK_VSDIP7      18
#define FFK_VSDIP8      19
#define FFK_HUESEL      20
#define FFK_TINTSEL     21
#define FFK_NTSCDEC     22
#define FFK_NTSCINC     23

#define FFK_STATE0      24
#define FFK_STATE1      25
#define FFK_STATE2      26
#define FFK_STATE3      27
#define FFK_STATE4      28
#define FFK_STATE5      29
#define FFK_STATE6      30
#define FFK_STATE7      31
#define FFK_STATE8      32
#define FFK_STATE9      33


#define FFK_NSFFASTINC  34
#define FFK_NSFFASTDEC  35
#define FFK_NSFSTART    36
#define FFK_NSFDEC      37
#define FFK_NSFINC      38

#define FFK_EXIT        39
#define FFK_TOGMENU     40
#define FFK_FSTOG       41

static int NoWaiting=0;
static int soundflush=0;
static int genie=0;
static int palyo=0;
static int windowedfailed;
static int WindowXC=1<<30,WindowYC;
static int winsizemul=1;
static int winwidth,winheight;
static int fullscreen=0;
static volatile int nofocus=0;
static int soundrate=44100;
static int soundbufsize=2048;
static int soundoptions=0;
static int eoptions=0;

static unsigned int srendline=8;
static unsigned int erendline=239;
static unsigned int totallines;

static void UpdateRendBounds(void)
{
 totallines=erendline-srendline+1;
 FCEUI_SetFirstRenderedLine(srendline);
 FCEUI_SetLastRenderedLine(erendline);
 //sprintf(TempArray,"%d",totallines);
 //FCEUD_PrintError(TempArray);
}

#define EO_BGRUN         1
#define EO_VSYNC         2
#define EO_CPALETTE      4
#define EO_NOSPRLIM      8
#define EO_BSAV         16
#define EO_FSAFTERLOAD  32
#define EO_FOAFTERSTART 64

static uint8 cpalette[192];
static int vmod=1;
static int soundo=1;
static int ntsccol=0,ntsctint,ntschue;

void FCEUD_PrintError(char *s)
{
 if(fullscreen) ShowCursorAbs(1);
 MessageBox(0,s,"FCE Ultra Error",MB_ICONERROR|MB_OK|MB_SETFOREGROUND|MB_TOPMOST);
 if(fullscreen)ShowCursorAbs(0);
}

void ShowAboutBox(void)
{
 sprintf(TempArray,"FCE Ultra "VERSION_STRING"\n\nhttp://fceultra.sourceforge.net\n\n"__TIME__"\n"__DATE__"\n""gcc "__VERSION__);
 MessageBox(hAppWnd,TempArray,"About FCE Ultra",MB_OK);
}

static int InputType[2]={DII_SETCONTROL_GAMEPAD,DII_SETCONTROL_GAMEPAD};
static void *InputDPtr[2];
static uint32 JSreturn;
static uint32 mousedata[3];
static int gametype;

static uint32 powerpadbuf[2];
static int powerpadside=0;
static int powerpadsc[2][12]={
                              {
                               SCANCODE_O,SCANCODE_P,SCANCODE_BRACKET_LEFT,
                               SCANCODE_BRACKET_RIGHT,SCANCODE_K,SCANCODE_L,SCANCODE_SEMICOLON,SCANCODE_APOSTROPHE,
                               SCANCODE_M,SCANCODE_COMMA,SCANCODE_PERIOD,SCANCODE_SLASH
                              },
                              {
                               SCANCODE_O,SCANCODE_P,SCANCODE_BRACKET_LEFT,
                               SCANCODE_BRACKET_RIGHT,SCANCODE_K,SCANCODE_L,SCANCODE_SEMICOLON,SCANCODE_APOSTROPHE,
                               SCANCODE_M,SCANCODE_COMMA,SCANCODE_PERIOD,SCANCODE_SLASH
                              }
                             };

void FCEUD_SendMessage(int msg)
{
 switch(msg)
 {
  case DSM_RESETSPECIAL: gametype=0;break;
  case DSM_SPECIALSYSTEM_VSUNISYSTEM:
  case DSM_SPECIALSYSTEM_NSF:
  case DSM_SPECIALSYSTEM_FDS: gametype=msg;break;
 }
}

static int exiting=0;
static int gameloaded=0;

void DoFCEUExit(void)
{
 exiting=1;
 if(gameloaded)
  FCEUI_CloseGame();
}

static int changerecursive=0;
#include "joystick.c"
#include "keyboard.c"
#include "netplay.c"
#include "cheat.c"
#include "sound.c"
#include "video.c"
#include "window.c"
#include "config.c"

static void CreateInputStuff(void)
{ 
   int x;

   DriverInputInterface(DII_SETMULTI,0,JoyMulti,0);

   for(x=0;x<2;x++)
   {
    int TAttrib=0;
    switch(InputType[x])
    {
     case DII_SETCONTROL_POWERPAD:InputDPtr[x]=&powerpadbuf[x];break;
     case DII_SETCONTROL_GAMEPAD:InputDPtr[x]=((uint8 *)&JSreturn)+(x<<1);
				 break;
     case DII_SETCONTROL_ZAPPER:InputDPtr[x]=mousedata;
				TAttrib=fullscreen;
                                break;
    }
    DriverInputInterface(DII_SETCONTROL,x,InputType[x],InputDPtr[x]);
    DriverInputInterface(DII_SETCONTROLATTRIB,x,TAttrib,0);
   }   
}

static void DestroyInputStuff(void)
{
   KillJoysticks();
   KeyboardClose();
}

void FCEUD_UpdateInput(void)
{
  int x;
  uint32 JS;
  int t=0;

  KeyboardUpdate();

  for(x=0;x<2;x++)
   switch(InputType[x])
   {
    case DII_SETCONTROL_GAMEPAD:t|=1;break;
    case DII_SETCONTROL_ZAPPER:t|=2;break;
    case DII_SETCONTROL_POWERPAD:powerpadbuf[x]=UpdatePPadData(x);break;
   }
  if(t&1)
  {
   JS=KeyboardDodo();
   if(joy[0]|joy[1]|joy[2]|joy[3])
    JS|=(uint32)GetJSOr();
   JSreturn=(JS&0xFF000000)|(JS&0xFF)|((JS&0xFF0000)>>8)|((JS&0xFF00)<<8);   
  }
  if(t&2)  
   GetMouseData(&mousedata[0], &mousedata[1], &mousedata[2]);
}

int DriverInitialize(void)
{
  int t;
  t=1;
  if(!InitializeDDraw()) return 0; 
  soundo=InitSound();

  if(!SetVideoMode())
   {
   if(!fullscreen)
    {
     fullscreen=1;
     if(!SetVideoMode())
      return 0;
    }
   else
    return 0;
   }
  KeyboardInitialize();
  InitJoysticks();
  CreateInputStuff();
  return 1;
}

static void DriverKill(void)
{ 
 sprintf(TempArray,"%s/fceu.cfg",_BaseDirectory);
 SaveConfig(TempArray);
 DestroyInputStuff();
 ResetVideo();
 if(soundo) TrashSound();
 CloseWave();
}


int main(int argc,char *argv[])
{
  char *t;

  fceu_hInstance=GetModuleHandle(0);
  CreateMainWindow();
  if(!FCEUI_Initialize())
   goto doexito;

  if(!InitDInput())
   goto doexito;

  GetBaseDirectory();
  CreateDirs();

  sprintf(TempArray,"%s\\fceu.cfg",_BaseDirectory);
  LoadConfig(TempArray);

  DoVideoConfigFix();
  DoMiscConfigFix();

  if(eoptions&EO_CPALETTE)
   FCEUI_SetPaletteArray(cpalette);

  t=0;
  if(argc>1)
   t=argv[1];
  if(!t) fullscreen=0;

  DriverInitialize();
  UpdateMenu();

  if(t)
  {
   if(!FCEUI_LoadGame(t))
    goto doexito;
   gameloaded=1;
  }
  else if(eoptions&EO_FOAFTERSTART)
   LoadNewGamey();

  doloopy:
  UpdateFCEUWindow();
  if(gameloaded)
  {
   FCEUI_Emulate();
   RedrawWindow(hAppWnd,0,0,RDW_ERASE|RDW_INVALIDATE);
   StopSound();
  }
  Sleep(50);
  if(!exiting)
   goto doloopy;

  doexito:
  DriverKill();
  return(0);
}
