static int16 MoBuffer[2048];
static int wsize=0;
void WriteWaveData(int32 *Buffer, int Count, int Check)
{
  int P;

  if(Check)
  {
   for(P=0;P<Count;P++)
    { 
     int32 mixer;
     mixer=Buffer[P];
     if(mixer>32767) mixer=32767;
     if(mixer<-32768) mixer=-32768;
     MoBuffer[P]=mixer;
    }
  }
  else
  {
   for(P=0;P<Count;P++)
    MoBuffer[P]=Buffer[P];
  }
 wsize+=fwrite(MoBuffer,1,Count<<1,soundlog);
}

static int CloseWave(void)
{
 int s;

 if(!soundlog) return 0;
 s=ftell(soundlog)-8;
 fseek(soundlog,4,SEEK_SET);
 fputc(s&0xFF,soundlog);
 fputc((s>>8)&0xFF,soundlog);
 fputc((s>>16)&0xFF,soundlog);
 fputc((s>>24)&0xFF,soundlog);

 fseek(soundlog,0x28,SEEK_SET);
 s=wsize;
 fputc(s&0xFF,soundlog);
 fputc((s>>8)&0xFF,soundlog);
 fputc((s>>16)&0xFF,soundlog);
 fputc((s>>24)&0xFF,soundlog);

 fclose(soundlog);
 soundlog=0;
 return 1;
}
int WriteWaveHeader(FILE *fp)
{
 int r;
 fputs("RIFF",fp);
 fseek(fp,4,SEEK_CUR);  // Skip size
 fputs("WAVEfmt ",fp);
 fputc(0x10,fp);
 fputc(0,fp);
 fputc(0,fp);
 fputc(0,fp);

 fputc(1,fp);           // PCM
 fputc(0,fp);
 fputc(1,fp);           // Monophonic
 fputc(0,fp);

 r=44100;
 fputc(r&0xFF,fp);
 fputc((r>>8)&0xFF,fp);
 fputc((r>>16)&0xFF,fp);
 fputc((r>>24)&0xFF,fp);
 r<<=1;
 fputc(r&0xFF,fp);
 fputc((r>>8)&0xFF,fp);
 fputc((r>>16)&0xFF,fp);
 fputc((r>>24)&0xFF,fp);
 fputc(2,fp);
 fputc(0,fp);
 fputc(16,fp);
 fputc(0,fp);

 fputs("data",fp);
 fseek(fp,4,SEEK_CUR);

 return 1;
}

int StartSoundLog(char *str)
{
  soundlog=fopen(str,"wb");
  if(soundlog)
   return WriteWaveHeader(soundlog);
  else
   return 0;
}
int CreateSoundSave(void)
{
 const char filter[]="MS WAVE(*.wav)\0*.wav\0";
 char nameo[2048];
 OPENFILENAME ofn;

 if(soundlog)
  {
   CloseWave();
   return 0;
  }

 memset(&ofn,0,sizeof(ofn));
 ofn.lStructSize=sizeof(ofn);
 ofn.hInstance=fceu_hInstance;
 ofn.lpstrTitle="Log Sound As...";
 ofn.lpstrFilter=filter;
 nameo[0]=0;
 ofn.lpstrFile=nameo;
 ofn.nMaxFile=256;
 ofn.Flags=OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
 if(GetSaveFileName(&ofn))
  return StartSoundLog(nameo);
 return 0;
}
