static void ConfigMisc(void);
static void ConfigPalette(void);
static void ConfigInput(void);

HMENU fceumenu=0;
static int _pork;
void ShowCursorAbs(int w)
{
 static int stat=0;
 if(w)
 {
  if(stat==-1) {stat++; ShowCursor(1);}
 }
 else
 {
  if(stat==0) {stat--; ShowCursor(0);}
 }
}


void UpdateMenu(void)
{
 static int *polo[2]={&genie,&palyo};
 static int polo2[2]={114,115};
 int x;

 for(x=0;x<2;x++)
  CheckMenuItem(fceumenu,polo2[x],*polo[x]?MF_CHECKED:MF_UNCHECKED);
 if(eoptions&EO_BGRUN)
  CheckMenuItem(fceumenu,112,MF_CHECKED);
 else
  CheckMenuItem(fceumenu,112,MF_UNCHECKED);
 if(eoptions&EO_VSYNC)
  CheckMenuItem(fceumenu,120,MF_CHECKED);
 else
  CheckMenuItem(fceumenu,120,MF_UNCHECKED);
}
void InitMenu(void)
{
 fceumenu=GetMenu(hAppWnd);  
}
static int tog=0;
void ShowMenu(int h)
{
  if(h)
   {
   SetWindowLong(hAppWnd,GWL_STYLE,WS_THICKFRAME|WS_BORDER|WS_CAPTION);
   SetMenu(hAppWnd,0);
   ShowWindow(hAppWnd, 1);
   }
  else
   {
   SetWindowLong(hAppWnd,GWL_STYLE,WS_OVERLAPPEDWINDOW);
   SetMenu(hAppWnd,fceumenu);
   ShowWindow(hAppWnd, 1);
   }
}
void HideFWindow(int h)
{
 if(h)
 {
   RECT bo;

   GetWindowRect(hAppWnd,&bo);
   WindowXC=bo.left;
   WindowYC=bo.top;

   SetWindowLong(hAppWnd,GWL_STYLE,WS_POPUP);
   SetMenu(hAppWnd,0);
   ShowWindow(hAppWnd, 1);
 }
 else
 {
  ShowMenu(tog);
 }
}

void ToggleHideMenu(void)
{ 
 if(!fullscreen)
 {
  tog^=1;
  ShowMenu(tog);
  SetMainWindowStuff();
 }
}


void LoadNewGamey(void)
{
 const char filter[]="All usable files(*.nes,*.nsf,*.fds,*.unf,*.zip,*.gz)\0*.nes;*.nsf;*.fds;*.unf;*.zip;*.gz\0All non-compressed usable files(*.nes,*.nsf,*.fds,*.unf)\0*.nes;*.nsf;*.fds;*.unf\0All files (*.*)\0*.*\0";
 char nameo[2048];
 OPENFILENAME ofn;
 memset(&ofn,0,sizeof(ofn));
 ofn.lStructSize=sizeof(ofn);
 ofn.hInstance=fceu_hInstance;
 ofn.lpstrTitle="FCE Ultra Open File...";
 ofn.lpstrFilter=filter;
 nameo[0]=0;
 ofn.lpstrFile=nameo;
 ofn.nMaxFile=256;
 ofn.Flags=OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY; //OFN_EXPLORER|OFN_ENABLETEMPLATE|OFN_ENABLEHOOK;
 ofn.lpstrInitialDir=gfsdir;
 if(GetOpenFileName(&ofn))
 {
  strncpy(gfsdir,ofn.lpstrFile,ofn.nFileOffset);
  gfsdir[ofn.nFileOffset]=0;
  if(FCEUI_LoadGame(nameo))
  {
   gameloaded=1;
   if(eoptions&EO_FSAFTERLOAD)
    SetFSVideoMode();
  }
  else
  {
   gameloaded=0;
   StopSound();
  }
 }
}

static uint32 mousex,mousey,mouseb;
int GetMouseData(uint32 *x, uint32 *y, uint32 *b)
{
 *x=mousex;
 *y=mousey;
 if(!fullscreen)
  {*x/=winsizemul;*y/=winsizemul;}
 *y+=srendline;
 *b=((mouseb==MK_LBUTTON)?1:0)|((mouseb==MK_RBUTTON)?2:0);
 return fullscreen;
}

static int sizchange=0;
static int vchanged=0;

LRESULT FAR PASCAL AppWndProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
  // this is where we receive all message concerning this window
  // we can either process a message or pass it on to the default
  // message handler of windows
  switch(msg) {   
    case WM_LBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
                  mouseb=wParam;
                  goto proco;
    case WM_MOUSEMOVE:
                  {
                   mousex=LOWORD(lParam);
                   mousey=HIWORD(lParam);
                  }
                  goto proco;
    case WM_SIZING:
                 sizchange=1;
                 goto proco;
    case WM_DISPLAYCHANGE:
                if(!fullscreen && !changerecursive)
                 vchanged=1;
                goto proco;
    case WM_COMMAND:
                if(!(wParam>>16))
                 switch(wParam&0xFFFF)
                 {
                  case 400:
                           ConfigVideo();
                           break;
                  case 101:ConfigCheats();break;
                  case 119:ConfigMisc();break;
                  case 111:ToggleHideMenu();break;
                  case 112:eoptions^=EO_BGRUN;UpdateMenu();break;
                  case 120:eoptions^=EO_VSYNC;UpdateMenu();break;
                  case 113:StopSound();ConfigSound();
                           break;
                  case 114:genie^=1;FCEUI_SetGameGenie(genie);UpdateMenu();break;
                  case 115:palyo^=1;FCEUI_SetVidSystem(palyo);UpdateMenu();break;
                  case 118:StopSound();ConfigPalette();break;
                  case 116:StopSound();ConfigInput();break;
                  case 117:StopSound();ConfigNetplay();break;
                  case 200:DriverInterface(DES_RESET,0);break;
                  case 201:DriverInterface(DES_POWER,0);break;
                  case 258:
                           if(gameloaded)
                           {
                            FCEUI_CloseGame();                            
                            gameloaded=0;
                           }
                           break;
                  case 256:StopSound();LoadNewGamey();break;
                  case 257:
                           {
                            MENUITEMINFO mi;
                            char *str;
             
                            StopSound();
                            if(CreateSoundSave())
                             str="Stop Sound Logging";
                            else
                             str="Log Sound As...";
                            memset(&mi,0,sizeof(mi));
                            mi.fMask=MIIM_DATA|MIIM_TYPE;
                            mi.cbSize=sizeof(mi);
                            GetMenuItemInfo(fceumenu,257,0,&mi);                           
                            mi.fMask=MIIM_DATA|MIIM_TYPE;
                            mi.cbSize=sizeof(mi);
                            mi.dwTypeData=str;
                            mi.cch=strlen(str);
                            SetMenuItemInfo(fceumenu,257,0,&mi);
                            
                           }
                           break;
                  case 259:DoFCEUExit();break;
                  case 300:DriverInterface(DES_SAVESTATE,0);break;
                  case 301:DriverInterface(DES_LOADSTATE,0);break;
                  case 150:StopSound();ShowAboutBox();break;
                 }              
                 break;                
    case WM_SYSKEYDOWN:
               if(wParam==VK_F10)
               {
                if(!(lParam&0x40000000))
                 DriverInterface(DES_RESET,0);
                break;
               }
               goto proco;
    case WM_KEYDOWN:
              if(gameloaded)
               if(gametype&DSM_SPECIALSYSTEM_NSF)
                switch(wParam)
                {
                 case VK_UP:DriverInterface(DES_NSFINC,0);break;
                 case VK_DOWN:DriverInterface(DES_NSFDEC,0);break;
                 case VK_RETURN:DriverInterface(DES_NSFRES,0);break;

                 case VK_LEFT:if(!(lParam&0x40000000)) DriverInterface(DES_NSFDEC,0); break;
                 case VK_RIGHT:if(!(lParam&0x40000000)) DriverInterface(DES_NSFINC,0); break;
                }

               if(!(lParam&0x40000000))
                switch( wParam )
                {
                  case VK_F11:DriverInterface(DES_POWER,0);break;                
                  case VK_F12:DoFCEUExit();break;
                  case VK_F3:ToggleHideMenu();break;
                  case VK_F4:       fullscreen^=1;
                                    UpdateMenu();
                                    changerecursive=1;
                                    if(!SetVideoMode())
                                     {fullscreen^=1;SetVideoMode();}
                                    changerecursive=0;
                                    break;
                }               
                goto proco;
    case WM_ENTERMENULOOP:StopSound();goto proco;
    case WM_EXITMENULOOP:goto proco;
    case WM_CLOSE:
    case WM_DESTROY:
    case WM_QUIT:DoFCEUExit();break;
    case WM_ACTIVATEAPP:       
       if((BOOL)wParam)
       {
        nofocus=0;
       }
       else
       {
        nofocus=1;
       }
    default:
      // We didn't process the message so let Windows do it
      proco:
      return DefWindowProc(hWnd,msg,wParam,lParam);
   }
  // We processed the message and there
  // is no processing by Windows necessary
  return 0L;
}

void UpdateFCEUWindow(void)
{
  int w,h;
  RECT wrect;

  if(vchanged && !fullscreen && !changerecursive && !nofocus)
  {
   SetVideoMode();
   vchanged=0;
  }

  if(sizchange && !fullscreen)
  {   
   GetWindowRect(hAppWnd,&wrect);
   h=wrect.bottom-wrect.top;
   w=wrect.right-wrect.left;
   if(w!=winwidth)
    winsizemul=(w-(winwidth-256*winsizemul)+128)>>8;
   else
   if(h!=winheight)
    winsizemul=(h-(winheight-totallines*winsizemul)+(totallines>>1))>>8;

   if(winsizemul<1)
    winsizemul=1;
   SetMainWindowStuff();
  }
  sizchange=0;

  BlockingCheck();
}

int CreateMainWindow(void)
{
  WNDCLASSEX winclass;

  winclass.cbSize=sizeof(WNDCLASSEX);
  winclass.style=CS_OWNDC|CS_HREDRAW|CS_VREDRAW;
  winclass.lpfnWndProc=AppWndProc;
  winclass.cbClsExtra=0;
  winclass.cbWndExtra=0;
  winclass.hInstance=fceu_hInstance;
  winclass.hIcon=LoadIcon(fceu_hInstance, "ICON_1");
  winclass.hIconSm=LoadIcon(fceu_hInstance, "ICON_1");
  winclass.hCursor=LoadCursor(NULL, IDC_ARROW);
  winclass.hbrBackground=GetStockObject(BLACK_BRUSH);
  winclass.lpszMenuName="FCEUMENU";
  winclass.lpszClassName="FCEULTRA";

  if(!RegisterClassEx(&winclass))
    return FALSE;
  hAppWnd = CreateWindowEx(0,"FCEULTRA","FCE Ultra",
  			WS_OVERLAPPEDWINDOW,          // Style of Window
                        CW_USEDEFAULT,CW_USEDEFAULT,256,240,  // Position and Size of Window
  			NULL,NULL,fceu_hInstance,  // Handle of Parent Window, Menu and Instance
  			NULL );
  ShowWindow(hAppWnd, 1);
  InitMenu();
  return 1;
}

int SetMainWindowStuff(void)
{
  RECT crect;
  RECT wrect;
  int cx,cy,wx,wy;

  GetWindowRect(hAppWnd,&wrect);
  if(WindowXC!=1<<30)
  {
   wrect.right+=(WindowXC-wrect.left);
   wrect.bottom+=(WindowYC-wrect.top);
   wrect.left=WindowXC;
   wrect.top=WindowYC;
   WindowXC=1<<30;
  }
  cx=256*winsizemul;
  cy=totallines*winsizemul;

  SetWindowPos(hAppWnd,HWND_TOP,wrect.left,wrect.top,cx,cy,SWP_SHOWWINDOW);
  GetClientRect(hAppWnd,&crect);

  wx=(cx<<1)-crect.right;
  wy=(cy<<1)-crect.bottom;

  SetWindowPos(hAppWnd,HWND_TOP,wrect.left,wrect.top,wx,wy,SWP_SHOWWINDOW);

  winwidth=wx;
  winheight=wy;

  return 1;
}

int GetClientAbsRect(LPRECT lpRect)
{
  POINT point;
  point.x=point.y=0;
  if(!ClientToScreen(hAppWnd,&point)) return 0;

  lpRect->top=point.y;
  lpRect->bottom=point.y+totallines*winsizemul;
  lpRect->left=point.x;
  lpRect->right=point.x+256*winsizemul;
  return 1;
}


void LoadPaletteFile(void)
{
 FILE *fp;
 const char filter[]="All usable files(*.pal)\0*.pal\0All files (*.*)\0*.*\0";
 char nameo[2048];
 OPENFILENAME ofn;
 memset(&ofn,0,sizeof(ofn));
 ofn.lStructSize=sizeof(ofn);
 ofn.hInstance=fceu_hInstance;
 ofn.lpstrTitle="FCE Ultra Open Palette File...";
 ofn.lpstrFilter=filter;
 nameo[0]=0;
 ofn.lpstrFile=nameo;
 ofn.nMaxFile=256;
 ofn.Flags=OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
 ofn.lpstrInitialDir=0;
 if(GetOpenFileName(&ofn))
 {
  if((fp=fopen(nameo,"rb")))
  {
   fread(cpalette,1,192,fp);
   fclose(fp);
   FCEUI_SetPaletteArray(cpalette);
   eoptions|=EO_CPALETTE;
  }
  else
   FCEUD_PrintError("Error opening palette file!");
 }
}

BOOL CALLBACK PaletteConCallB(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch(uMsg) {
   case WM_INITDIALOG:                
                if(ntsccol)
                 CheckDlgButton(hwndDlg,100,BST_CHECKED);
                SendDlgItemMessage(hwndDlg,500,TBM_SETRANGE,1,MAKELONG(0,128));
                SendDlgItemMessage(hwndDlg,501,TBM_SETRANGE,1,MAKELONG(0,128));
                DriverInterface(DES_GETNTSCTINT,&ntsctint);
                DriverInterface(DES_GETNTSCHUE,&ntschue);
                SendDlgItemMessage(hwndDlg,500,TBM_SETPOS,1,ntsctint);
                SendDlgItemMessage(hwndDlg,501,TBM_SETPOS,1,ntschue);
                break;
   case WM_CLOSE:
   case WM_QUIT: goto gornk;
   case WM_COMMAND:
                if(!(wParam>>16))
                switch(wParam&0xFFFF)
                {
                 case 100:ntsccol^=1;DriverInterface(DES_NTSCCOL,&ntsccol);break;
                 case 200:
                          LoadPaletteFile();
                          break;
                 case 201:FCEUI_SetPaletteArray(0);
                          eoptions&=~EO_CPALETTE;
                          break;
                 case 1:
                        gornk:
                        ntsctint=SendDlgItemMessage(hwndDlg,500,TBM_GETPOS,0,(LPARAM)(LPSTR)0);
                        ntschue=SendDlgItemMessage(hwndDlg,501,TBM_GETPOS,0,(LPARAM)(LPSTR)0);
                        EndDialog(hwndDlg,0);
                        break;
               }
              }
  return 0;
}

BOOL CALLBACK GPConCallB(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch(uMsg) {
   case WM_INITDIALOG:                
                if(JoyMulti)
                 CheckDlgButton(hwndDlg,200,BST_CHECKED);
                break;
   case WM_CLOSE:
   case WM_QUIT: goto gornk;
   case WM_COMMAND:
                if(!(wParam>>16))
                switch(wParam&0xFFFF)
                {
                 case 107:ConfigJoystickies(_pork);break;
                 case 106:ConfigKeyboardie(_pork);break;
                 case 1:
                        gornk:
                        JoyMulti=0;
                        if(IsDlgButtonChecked(hwndDlg,200)==BST_CHECKED)
                         JoyMulti=1;
                        EndDialog(hwndDlg,0);
                        break;
               }
              }
  return 0;
}

static void ConfigGamePad(int port)
{
  _pork=port;
  DialogBox(fceu_hInstance,"GAMEPADCONFIG",hAppWnd,GPConCallB);
}

BOOL CALLBACK InputConCallB(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  static const void (*boopar[4])(int port)={0,(void*)ConfigGamePad,0,(void *)ConfigKeyboardiePowerpad};
  int x;
  
  switch(uMsg) {
   case WM_INITDIALOG:                
                for(x=0;x<2;x++)
                {
                 SendDlgItemMessage(hwndDlg,104+x,CB_ADDSTRING,0,(LPARAM)(LPSTR)"<none>");
                 SendDlgItemMessage(hwndDlg,104+x,CB_ADDSTRING,0,(LPARAM)(LPSTR)"Gamepad");
                 SendDlgItemMessage(hwndDlg,104+x,CB_ADDSTRING,0,(LPARAM)(LPSTR)"Zapper");
                 SendDlgItemMessage(hwndDlg,104+x,CB_ADDSTRING,0,(LPARAM)(LPSTR)"Power Pad");
                 SendDlgItemMessage(hwndDlg,104+x,CB_SETCURSEL,InputType[x],(LPARAM)(LPSTR)0);
                }
                break;
   case WM_CLOSE:
   case WM_QUIT: goto gornk;
   case WM_COMMAND:
                if(!(wParam>>16))
                switch(wParam&0xFFFF)
                {
                 case 107:
                 case 106:
                  {
                   int t=(wParam&0xFFFF)-106;
                   x=SendDlgItemMessage(hwndDlg,104+t,CB_GETCURSEL,0,(LPARAM)(LPSTR)0);
                   if(boopar[x])
                    boopar[x](t);
                  }
                  break;
                 case 1:
                        gornk:
                        InputType[0]=SendDlgItemMessage(hwndDlg,104,CB_GETCURSEL,0,(LPARAM)(LPSTR)0);;
                        InputType[1]=SendDlgItemMessage(hwndDlg,105,CB_GETCURSEL,0,(LPARAM)(LPSTR)0);                        
                        EndDialog(hwndDlg,0);
                        break;
               }
              }
  return 0;
}

static void ConfigPalette(void)
{
  DialogBox(fceu_hInstance,"PALCONFIG",hAppWnd,PaletteConCallB);
  DriverInterface(DES_SETNTSCTINT,&ntsctint);
  DriverInterface(DES_SETNTSCHUE,&ntschue);
}



static void ConfigInput(void)
{
  DialogBox(fceu_hInstance,"INPUTCONFIG",hAppWnd,InputConCallB);
  CreateInputStuff();
}

BOOL CALLBACK MiscConCallB(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch(uMsg) {
   case WM_INITDIALOG:                
                if(eoptions&EO_NOSPRLIM)
                 CheckDlgButton(hwndDlg,100,BST_CHECKED);
                if(eoptions&EO_BSAV)
                 CheckDlgButton(hwndDlg,101,BST_CHECKED);
                if(eoptions&EO_FOAFTERSTART)
                 CheckDlgButton(hwndDlg,102,BST_CHECKED);
                break;
   case WM_CLOSE:
   case WM_QUIT: goto gornk;
   case WM_COMMAND:
                if(!(wParam>>16))
                switch(wParam&0xFFFF)
                {
                 case 1:
                        gornk:
                        if(IsDlgButtonChecked(hwndDlg,100)==BST_CHECKED)
                         eoptions|=EO_NOSPRLIM;
                        else
                         eoptions&=~EO_NOSPRLIM;
                        if(IsDlgButtonChecked(hwndDlg,101)==BST_CHECKED)
                         eoptions|=EO_BSAV;
                        else
                         eoptions&=~EO_BSAV;
                        if(IsDlgButtonChecked(hwndDlg,102)==BST_CHECKED)
                         eoptions|=EO_FOAFTERSTART;
                        else
                         eoptions&=~EO_FOAFTERSTART;
                        EndDialog(hwndDlg,0);
                        break;
               }
              }
  return 0;
}

void DoMiscConfigFix(void)
{
  FCEUI_DisableSpriteLimitation(eoptions&EO_NOSPRLIM);
  FCEUI_SaveExtraDataUnderBase(eoptions&EO_BSAV);
}

static void ConfigMisc(void)
{
  DialogBox(fceu_hInstance,"MISCCONFIG",hAppWnd,MiscConCallB);  
  DoMiscConfigFix();
}

