/*	Contains file I/O functions that write/read data    */
/*	LSB first.				            */


#include <stdio.h>
#include "types.h"
#include "endian.h"

#include "../stdfile.h"

static uint8 s[4];

int write16(uint16 b, FILE *fp)
{
 s[0]=b;
 s[1]=b>>8;
 return((fwrite(s,1,2,fp)<2)?0:2);
}

int write32(uint32 b, FILE *fp)
{
 s[0]=b;
 s[1]=b>>8;
 s[2]=b>>16;
 s[3]=b>>24;
 return((fwrite(s,1,4,fp)<4)?0:4);
}

int read32(void *Bufo, FILE *fp)
{
 uint32 buf;
 if(fread(&buf,1,4,fp)<4)
  return 0;
 #ifdef LSB_FIRST
 *(uint32*)Bufo=buf;
 #else
 *(uint32*)Bufo=((buf&0xFF)<<24)|((buf&0xFF00)<<8)|((buf&0xFF0000)>>8)|((buf&0xFF000000)>>24);
 #endif
 return 1;
}

int read16(char *d, FILE *fp)
{
 #ifdef LSB_FIRST
 return((fread(d,1,2,fp)<2)?0:2);
 #else
 int ret;
 ret=fread(d+1,1,1,fp);
 ret+=fread(d,1,1,fp);
 return ret<2?0:2;
 #endif
}

