/*
        Portable Family Computer Emulator
	1998 by BERO bero@geocities.co.jp
        FCE Ultra
        1998-2001 Xodnizel xodnizel@home.com
*/


#include        <string.h>
#include	<stdio.h>
#include	<stdlib.h>

#include	"m6502.h"
#include	"fce.h"
#include	"sound.h"
#include        "svga.h"
#include	"netplay.h"
#include	"general.h"
#include	"endian.h"
#include	"version.h"
#include        "memory.h"

#include	"cart.h"
#include	"nsf.h"
#include	"fds.h"
#include	"ines.h"
#include	"unif.h"
#include        "cheat.h"

#include	"state.h"
#include        "video.h"
#include	"input.h"
#include	"file.h"
#include	"crc32.h"

#include "../stdfile.h"

#define Pal     (PALRAM)

static void FetchSpriteData(void);
static void FASTAPASS(1) RefreshLine(uint8 *target);
static void PRefreshLine(void);
static void FASTAPASS(1) RefreshSprite(uint8 *target);


int MMC5Hack;
uint32 MMC5HackVROMMask;
uint8 *MMC5HackExNTARAMPtr;
uint8 *MMC5HackVROMPTR;
uint8 MMC5HackCHRMode=0; 

uint8 *MMC5SPRVPage[8];
uint8 *MMC5BGVPage[8];


uint8 VRAMBuffer,PPUGenLatch;

uint8 *vnapage[4];
uint8 PPUNTARAM;
uint8 PPUCHRRAM;

static int tosprite=256;

#ifdef FRAMESKIP
int FrameSkip = 0;
#endif

int GameAttributes;
void (*GameInterface)(int h);

void FP_FASTAPASS(1) (*PPU_hook)(uint32 A);

void (*GameStateRestore)(int version);
void (*GameHBIRQHook)(void);

readfunc ARead[0x10000];
writefunc BWrite[0x10000];
static readfunc *AReadG;
static writefunc *BWriteG;
static int RWWrap=0;

char nothing[8192];

DECLFW(BNull)
{

}

DECLFR(ANull)
{
 return(M.DB);
}

int AllocGenieRW(void)
{
 if(!(AReadG=FCEU_malloc(0x8000*sizeof(readfunc))))
  return 0;
 if(!(BWriteG=FCEU_malloc(0x8000*sizeof(writefunc))))
  return 0;
 RWWrap=1;
 return 1;
}

void FlushGenieRW(void)
{
 int32 x;

 if(RWWrap)
 {
  for(x=0;x<0x8000;x++)
  {
   ARead[x+0x8000]=AReadG[x];
   BWrite[x+0x8000]=BWriteG[x];
  }
  free(AReadG);
  free(BWriteG);
  AReadG=0;
  BWriteG=0;
  RWWrap=0;
 }
}

void * FASTAPASS(1) GetReadHandler(int32 a)
{
  if(a>=0x8000 && RWWrap)
   return AReadG[a-0x8000];
  else
   return ARead[a];
}

void FASTAPASS(3) SetReadHandler(int32 start, int32 end, readfunc func)
{
  int32 x;

  if(!func)
   func=(void *)ANull;

  if(RWWrap)
   for(x=end;x>=start;x--)
   {
    if(x>=0x8000)
     AReadG[x-0x8000]=func;
    else
     ARead[x]=func;
   }
  else

   for(x=end;x>=start;x--)
    ARead[x]=func;
}

void * FASTAPASS(1) GetWriteHandler(int32 a)
{
  if(RWWrap && a>=0x8000)
   return BWriteG[a-0x8000];
  else
   return BWrite[a];
}

void FASTAPASS(3) SetWriteHandler(int32 start, int32 end, writefunc func)
{
  int32 x;

  if(!func)
   func=(void *)BNull;

  if(RWWrap)
   for(x=end;x>=start;x--)
   {
    if(x>=0x8000)
     BWriteG[x-0x8000]=func;
    else
     BWrite[x]=func;
   }
  else
   for(x=end;x>=start;x--)
    BWrite[x]=func;
}

uint8 vtoggle=0;
uint8 XOffset=0;

dpair __TempAddr;
dpair __RefreshAddr;

static int maxsprites=8;

/* scanline is equal to the current visible scanline we're on. */

int scanline;
static uint32 scanlines_per_frame;
static int IPeriod, HPeriod;

uint8 PPU[4];
uint8 PPUSPL;

uint8 GameMemBlock[131072];
uint8 NTARAM[0x800],PALRAM[0x20],SPRAM[0x100],SPRBUF[0x100];
uint8 RAM[0x800];

uint8 PAL=0;

#define MMC5SPRVRAMADR(V)      &MMC5SPRVPage[(V)>>10][(V)]
#define MMC5BGVRAMADR(V)      &MMC5BGVPage[(V)>>10][(V)]
#define	VRAMADR(V)	&VPage[(V)>>10][(V)]
 
DECLFW(BRAML)
{  
        RAM[A]=V;
}

DECLFW(BRAMH)
{
        RAM[A&0x7FF]=V;
}

DECLFR(ARAML)
{
        return RAM[A];
}

DECLFR(ARAMH)
{
        return RAM[A&0x7FF];
}

           
DECLFR(A2002)
{
                        uint8 ret;
                        ret = PPU_status;
                        vtoggle=0;
                        PPU_status&=0x7F;
                        return ret|(PPUGenLatch&0x1F);
}

DECLFR(A200x)
{
                        return PPUGenLatch;
}

DECLFR(A2007)
{
                        uint8 ret;
			uint32 tmp=RefreshAddr&0x3FFF;

                        PPUGenLatch=ret=VRAMBuffer;

                        if(tmp<0x2000) 
			{
			 VRAMBuffer=VPage[tmp>>10][tmp];
			 if(PPU_hook) PPU_hook(tmp);
			}
                        else 
			{
			 VRAMBuffer=vnapage[(tmp>>10)&0x3][tmp&0x3FF];
			}
                        if (INC32) RefreshAddr+=32;
                        else RefreshAddr++;
                        return ret;
}

DECLFW(B2000)
{
                PPUGenLatch=V;
                PPU[0]=V;
		__TempAddr.W.l.B.h&=0xF3;
		__TempAddr.W.l.B.h|=(V&3)<<2;
}

DECLFW(B2001)
{
                  PPUGenLatch=V;
 	          PPU[1]=V;
}

DECLFW(B2002)
{
                 PPUGenLatch=V;
}

DECLFW(B2003)
{
                PPUGenLatch=V;
                PPU[3]=V;
		PPUSPL=V&0x7;
}

DECLFW(B2004)
{
                PPUGenLatch=V;
                //SPRAM[PPU[3]++]=V;
		if(PPUSPL&8)
		{
		 if(PPU[3]>=8)
  		  SPRAM[PPU[3]]=V;
		}
		else
		{
		 //printf("$%02x:$%02x\n",PPUSPL,V);
		 SPRAM[PPUSPL]=V;
		 PPUSPL++;
		}
		PPU[3]++;
}

DECLFW(B2005)
{
		uint32 tmp=TempAddr;

		PPUGenLatch=V;
		if (!vtoggle)
                {
		 tmp&=0xFFE0;
		 tmp|=V>>3;
                 XOffset=V&7;
                }
                else
                {
                 tmp&=0x8C1F;
                 tmp|=((V&~0x7)<<2);
		 tmp|=(V&7)<<12;
                }

		TempAddr=tmp;
                vtoggle^=1;
}

DECLFW(B2006)
{
                       PPUGenLatch=V;
                       if(!vtoggle)
                       {
                        __TempAddr.W.l.B.h=V&0x3f;
                       }
                       else
                       {
		        __TempAddr.W.l.B.l=V;
                        RefreshAddr=TempAddr;
                       }
                      vtoggle^=1;
}

DECLFW(B2007)
{  
			uint32 tmp=RefreshAddr&0x3FFF;

                        PPUGenLatch=V;

                        if(tmp>=0x3F00)
                        {
                        // hmmm....
                        if(!(tmp&0xf))
                         PALRAM[0x00]=PALRAM[0x04]=PALRAM[0x08]=PALRAM[0x0C]=
                         PALRAM[0x10]=PALRAM[0x14]=PALRAM[0x18]=PALRAM[0x1c]=V&0x3f;
                        else if(tmp&3) PALRAM[(tmp&0x1f)]=V&0x3f;
                        }
                        else if(tmp<0x2000)
                        {
                          if(PPUCHRRAM&(1<<(tmp>>10)))
                            VPage[tmp>>10][tmp]=V;
                          if(PPU_hook) PPU_hook(tmp);
                        }
                        else
			{                         			
                         if(PPUNTARAM&(1<<((tmp&0xF00)>>10)))
                          vnapage[((tmp&0xF00)>>10)][tmp&0x3FF]=V;
                        }

                        if (INC32) RefreshAddr+=32;
                        else RefreshAddr++;
}


DECLFW(B4014)
{                        
	uint32 t=V<<8;
	int x; //,s;

	//printf("$%04x:$%02x, $%02x, %d\n",A,V,M.PC.W,scanline);
	//if(!PPU[3])
	// for(x=0;x<256;x++)
	//  SPRAM[x]=ARead[t+x](t+x);
	//else
	for(x=0;x<256;x++)
	 B2004(0x2004,ARead[t+x](t+x));
 	//for(x=0,s=PPU[3];x<256;x++,s++)
	//SPRAM[s&0xFF]=ARead[t+x](t+x);
	//	SPRAM[8]=0;
	//	SPRAM[12]=0;
	//	SPRAM[16]=0;
	//	SPRAM[20]=0;
	Add6502Cycle(512);
}

#ifdef FRAMESKIP
/* To use frameskip, PutImage() calls FCEUI_FrameSkip() with
   the number of frames to skip before the next call. */
void FCEUI_FrameSkip(int skip)
{
	FrameSkip=skip;
}
#endif

static void FASTAPASS(1) BGRender(uint8 *target)
{
	uint32 tem;
        RefreshLine(target);
        if(!(PPU[1]&2))
        {
         tem=Pal[0]|(Pal[0]<<8)|(Pal[0]<<16)|(Pal[0]<<24);
         tem|=0x40404040;
         *(uint32 *)target=*(uint32 *)(target+4)=tem;
        }
}

/*	This is called at the beginning of each visible scanline */
static void Loop6502(void)
{
	uint32 tem;
	int x;
        uint8 *target=XBuf+(scanline<<8)+(scanline<<4)+8;

        if(ScreenON || SpriteON)
        {

 	  #ifdef FRAMESKIP
	  if(FrameSkip==0) 
	  {
	  #endif
	  if(ScreenON)
	  {
  	   if(scanline>=FSettings.FirstSLine && scanline<=FSettings.LastSLine)
	    BGRender(target);
	   else
	   {
	    if(PPU_hook)
 	     PRefreshLine();
   	   }
	  }
	  else
	  {
	   tem=Pal[0]|(Pal[0]<<8)|(Pal[0]<<16)|(Pal[0]<<24);
	   tem|=0x40404040;
	   FCEU_dwmemset(target,tem,264);
	  }
	  #ifdef FRAMESKIP
	  }
	  #endif
   	  if (SpriteON && scanline)
	   RefreshSprite(target);
	  #ifdef FRAMESKIP		  
	  if(FrameSkip==0)
	  {
	  #endif
	  if(PPU[1]&0x01)
	  {
	   for(x=63;x>=0;x--)
	    *(uint32 *)&target[x<<2]=(*(uint32*)&target[x<<2])&0xF0F0F0F0;
	  }
	  if(PPU[1]&0xE0)
	  {
	   for(x=63;x>=0;x--)
	    *(uint32 *)&target[x<<2]=(*(uint32*)&target[x<<2])|0xC0C0C0C0;
	  }
	  #ifdef FRAMESKIP
	  }
	  #endif
	 }
	else
	{
	 tem=Pal[0]|(Pal[0]<<8)|(Pal[0]<<16)|(Pal[0]<<24);
	 FCEU_dwmemset(target,tem,256);
	}		
        if(InputScanlineHook)
         InputScanlineHook(target, scanline);
}

#define PAL(c)  ((c)+cc)


static void PRefreshLine(void)
{
        uint32 vofs;
        uint8 X1;

        vofs = 0;
        if (BGAdrHI) vofs = 0x1000;

        vofs+=(RefreshAddr>>12)&7;

        for(X1=33;X1;X1--)
        {
                register uint8 no;
                register uint8 zz2;
                zz2=(uint8)((RefreshAddr>>10)&3);
                no  = vnapage[zz2][(RefreshAddr&0x3ff)];
                PPU_hook((no<<4)+vofs);
                if((RefreshAddr&0x1f)==0x1f)
                 RefreshAddr^=0x41F;
                else
                 RefreshAddr++;
        }
}

/*              Total of 33 tiles(32 + 1 extra) */

static void FASTAPASS(1) RefreshLine(uint8 *target)
{
	#define vofs __vofs.DW
	dpair __vofs;
        int X1;
        register uint8 *P=target; 

	vofs=0;
	
        Pal[0]|=64;
        Pal[4]|=64;
        Pal[8]|=64;
        Pal[0xC]|=64;

	__vofs.W.l.B.h=PPU[0]&0x10;
        P-=XOffset;
        __vofs.W.l.B.h&=0x10;
        vofs+=(RefreshAddr>>12)&7;

        if(MMC5Hack && geniestage!=1)
        {
         if(MMC5HackCHRMode==1)
         {
          for(X1=33;X1;X1--,P+=8)
          {
                uint8 *C;                                   
                register uint8 cc;
                register uint8 zz,zz2;
                uint32 vadr;  
                C=MMC5HackVROMPTR;
                zz=RefreshAddr&0x1F;
                zz2=(RefreshAddr>>10)&3;
                vadr = (vnapage[zz2][RefreshAddr & 0x3ff] << 4) + vofs;
                C += (((MMC5HackExNTARAMPtr[RefreshAddr & 0x3ff]) & 0x3f & MMC5HackVROMMask) << 12) + (vadr & 0xfff);
                vadr = (MMC5HackExNTARAMPtr[RefreshAddr & 0x3ff] & 0xC0) >> 4;
                cc = vadr;

                #ifdef C80x86
                 #include "fcelineasm.h"
                #else
                 #include "fceline.h"
                #endif
                if((RefreshAddr&0x1f)==0x1f)
                 RefreshAddr^=0x41F;
                else
                 RefreshAddr++;
          }
         }
         else
         {
          for(X1=33;X1;X1--,P+=8)
          {
                uint8 *C;
                register uint8 cc;
                register uint8 zz,zz2;
                uint32 vadr;
                zz=RefreshAddr&0x1F;
		zz2=(RefreshAddr>>10)&3;                
                vadr=(vnapage[zz2][RefreshAddr&0x3ff]<<4)+vofs;               
                C = MMC5BGVRAMADR(vadr);
                cc=(uint8)((((vnapage[zz2][0x3c0+(zz>>2)+((RefreshAddr&0x380)>>4)])>>((zz&2) + ((RefreshAddr&0x40)>>4))&3)<<2));

                #ifdef C80x86
	        #include "fcelineasm.h"
		#else
		#include "fceline.h"
		#endif
                
		if((RefreshAddr&0x1f)==0x1f)
                 RefreshAddr^=0x41F;
                else
                 RefreshAddr++;
          }          
         }
        }       // End if(MMC5Hack)

        else if(PPU_hook)
        {
         for(X1=33;X1;X1--,P+=8)
         {
                uint8 *C;                                   
                register uint8 cc;
                register uint8 zz,zz2;
                uint32 vadr;  
                zz=RefreshAddr&0x1F;
                zz2=(RefreshAddr>>10)&3;
                cc=(uint8)((((vnapage[zz2][0x3c0+(zz>>2)+((RefreshAddr&0x380)>>4)])>>((zz&2) + ((RefreshAddr&0x40)>>4))&3)<<2));

                vadr=(vnapage[zz2][RefreshAddr&0x3ff]<<4)+vofs;
                C = VRAMADR(vadr);
		#ifdef C80x86
		#include "fcelineasm.h"
		PPU_hook(vadr);
		#else
	        #include "fceline.h"
	        PPU_hook(vadr);
		#endif
                if((RefreshAddr&0x1f)==0x1f)
                 RefreshAddr^=0x41F;
                else
                 RefreshAddr++;
         }
        }
        else
        {      
         for(X1=33;X1;X1--,P+=8)
         {
                uint8 *C;
                register uint8 cc;
                register uint8 zz,zz2;
                uint32 vadr;
                zz=RefreshAddr&0x1F;
		zz2=(RefreshAddr>>10)&3;
                vadr=(vnapage[zz2][RefreshAddr&0x3ff]<<4)+vofs;
                C = VRAMADR(vadr);
                cc=(uint8)((((vnapage[zz2][0x3c0+(zz>>2)+((RefreshAddr&0x380)>>4)])>>((zz&2) + ((RefreshAddr&0x40)>>4))&3)<<2));

		#ifdef C80x86
	        #include "fcelineasm.h"
		#else
		#include "fceline.h"
		#endif
                
		if((RefreshAddr&0x1f)==0x1f)
                 RefreshAddr^=0x41F;
                else
                 RefreshAddr++;
         }
        }

        #undef vofs

        Pal[0]&=63;
        Pal[4]&=63;
        Pal[8]&=63;
        Pal[0xC]&=63;

}
static INLINE void Fixit2(void)
{
   if(ScreenON || SpriteON)
   {
    uint32 rad=RefreshAddr;
    rad&=0xFBE0;
    rad|=TempAddr&0x041f;
    RefreshAddr=rad;
   }
}

static INLINE void Fixit1(void)
{
   if(ScreenON || SpriteON)
   {
    uint32 rad=RefreshAddr;

    if((rad&0x7000)==0x7000)
    {
     rad^=0x7000;
     if((rad&0x3E0)==0x3A0)
     {
      rad^=0x3A0;
      rad^=0x800;
     }
     else
     {
      if((rad&0x3E0)==0x3e0)
       rad^=0x3e0;
      else rad+=0x20;
     }
    }
    else
     rad+=0x1000;
    RefreshAddr=rad;
   }
}

/*      This is called at the beginning of all h-blanks on visible lines. */
static void DoHBlank(void)
{
 if(ScreenON || SpriteON)
  FetchSpriteData();
 if(GameHBIRQHook && (ScreenON || SpriteON))
 {
  Run6502(12);
  GameHBIRQHook();
  Run6502(25-12);
  Fixit2();
  Run6502(HPeriod-25);
 }
 else
 {
  Run6502(25);	// Tried 65, caused problems with Slalom(maybe others)
  Fixit2();
  Run6502(HPeriod-25);
 }
}

#define	V_FLIP	0x80
#define	H_FLIP	0x40
#define	SP_BACK	0x20

typedef struct {
        uint8 y,no,atr,x;
} SPR;

typedef struct {
	uint8 ca[2],atr,x;
} SPRB;

uint8 sprlinebuf[256+8];        

void FCEUI_DisableSpriteLimitation(int a)
{
 maxsprites=a?64:8;
}

static uint8 nosprites,SpriteBlurp;

static void FetchSpriteData(void)
{
	SPR *spr;
	uint8 H;
	int n,vofs;

	spr=(SPR *)SPRAM;
	H=8;

	nosprites=SpriteBlurp=0;

        vofs=(unsigned int)(PPU[0]&0x8&(((PPU[0]&0x20)^0x20)>>2))<<9;
	H+=(PPU[0]&0x20)>>2;

        if(!PPU_hook)
         for(n=63;n>=0;n--,spr++)
         {
                if((unsigned int)(scanline-spr->y)>=H) continue;

                if(nosprites<maxsprites)
                {
                 if(n==63) SpriteBlurp=1;

		 {
		  SPRB dst;
		  uint8 *C;
                  int t;
                  unsigned int vadr;

                  t = (int)scanline-(spr->y);

                  if (Sprite16)
                   vadr = ((spr->no&1)<<12) + ((spr->no&0xFE)<<4);
                  else
                   vadr = (spr->no<<4)+vofs;

                  if (spr->atr&V_FLIP)
                  {
                        vadr+=7;
                        vadr-=t;
                        vadr+=(PPU[0]&0x20)>>1;
                        vadr-=t&8;
                  }
                  else
                  {
                        vadr+=t;
                        vadr+=t&8;
                  }

		  /* Fix this geniestage hack */
      	          if(MMC5Hack && geniestage!=1) C = MMC5SPRVRAMADR(vadr);
                  else C = VRAMADR(vadr);

		  
		  dst.ca[0]=C[0];
		  dst.ca[1]=C[8];
		  dst.x=spr->x;
		  dst.atr=spr->atr;


		  *(uint32 *)&SPRBUF[nosprites<<2]=*(uint32 *)&dst;
		 }

                 nosprites++;
                }
                else
                {
                  PPU_status|=0x20;
                  break;
                }
         }
	else
         for(n=63;n>=0;n--,spr++)
         {
                if((unsigned int)(scanline-spr->y)>=H) continue;

                if(nosprites<maxsprites)
                {
                 if(n==63) SpriteBlurp=1;

                 {
                  SPRB dst;
                  uint8 *C;
                  int t;
                  unsigned int vadr;

                  t = (int)scanline-(spr->y);

                  if (Sprite16)
                   vadr = ((spr->no&1)<<12) + ((spr->no&0xFE)<<4);
                  else
                   vadr = (spr->no<<4)+vofs;

                  if (spr->atr&V_FLIP)
                  {
                        vadr+=7;
                        vadr-=t;
                        vadr+=(PPU[0]&0x20)>>1;
                        vadr-=t&8;
                  }
                  else
                  {
                        vadr+=t;
                        vadr+=t&8;
                  }

		  PPU_hook(vadr);

                  if(MMC5Hack) C = MMC5SPRVRAMADR(vadr);
                  else C = VRAMADR(vadr);
                  dst.ca[0]=C[0];
                  dst.ca[1]=C[8];
                  dst.x=spr->x;
                  dst.atr=spr->atr;


                  *(uint32 *)&SPRBUF[nosprites<<2]=*(uint32 *)&dst;
                 }

                 nosprites++;
                }
                else
                {
                  PPU_status|=0x20;
                  break;
                }
         }
}

static void FASTAPASS(1) RefreshSprite(uint8 *target)
{
	int n;
        SPRB *spr;
        uint8 *P=target;

        if(!nosprites) return;
	#ifdef FRAMESKIP
 		if(FrameSkip!=0) 
		{
 		 if(!SpriteBlurp) 
		  return;	
		 else
		  nosprites=1;
		}
	#endif

        FCEU_dwmemset(sprlinebuf,0x80808080,256);
        nosprites--;
        spr = (SPRB*)SPRBUF+nosprites;

       for(n=nosprites;n>=0;n--,spr--)
       {
        register uint8 J,c1,c2,atr;
	int x=spr->x;
        uint8 *C;
        uint8 *VB;
                
        P+=x;

        c1=((spr->ca[0]>>1)&0x55)|(spr->ca[1]&0xAA);
	c2=(spr->ca[0]&0x55)|((spr->ca[1]<<1)&0xAA);
        J=spr->ca[0]|spr->ca[1];
	atr=spr->atr;

                       if(J)
                       {        
                        if(n==0 && SpriteBlurp && !(PPU_status&0x40))
                        {  
			 int z,ze=x+8;
			 if(ze>256) {ze=256;}
			 if(ScreenON && (scanline<FSettings.FirstSLine || scanline>FSettings.LastSLine))
			  BGRender(target);

			 if(!(atr&H_FLIP))
			 {
			  for(z=x;z<ze;z++)
			  {
			   if(J&(0x80>>(z-x)))
			   {
			    if(!(target[z]&64))
			     tosprite=z;
			   }
			  }
			 }
			 else
			 {
                          for(z=x;z<ze;z++)
                          {
                           if(J&(1<<(z-x)))
                           {
                            if(!(target[z]&64))
                             tosprite=z;
                           }
                          }
			 }
			 //FCEU_DispMessage("%d, %d:%d",scanline,x,tosprite);
                        }
			C = sprlinebuf+x;
                        VB = (PALRAM+0x10)+((atr&3)<<2);
                        if(atr&SP_BACK) {
                          if (atr&H_FLIP){
                                if (J&0x02)  C[1]=VB[c1&3]|0x40;
                                if (J&0x01)  *C=VB[c2&3]|0x40;
                                c1>>=2;
                                c2>>=2;
                                if (J&0x08)  C[3]=VB[c1&3]|0x40;
                                if (J&0x04)  C[2]=VB[c2&3]|0x40;
                                c1>>=2;
                                c2>>=2;
                                if (J&0x20)  C[5]=VB[c1&3]|0x40;
                                if (J&0x10)  C[4]=VB[c2&3]|0x40;
                                c1>>=2;
                                c2>>=2;
                                if (J&0x80)  C[7]=VB[(c1)]|0x40;
                                if (J&0x40)  C[6]=VB[(c2)]|0x40;
			  }else{
                                if (J&0x02)  C[6]=VB[c1&3]|0x40;
                                if (J&0x01)  C[7]=VB[c2&3]|0x40;
                                c1>>=2;           
                                c2>>=2;
                                if (J&0x08)  C[4]=VB[c1&3]|0x40;
                                if (J&0x04)  C[5]=VB[c2&3]|0x40;
                                c1>>=2;
                                c2>>=2;
                                if (J&0x20)  C[2]=VB[c1&3]|0x40;
                                if (J&0x10)  C[3]=VB[c2&3]|0x40;
                                c1>>=2;
                                c2>>=2;
                                if (J&0x80)  *C=VB[c1]|0x40;
                                if (J&0x40)  C[1]=VB[c2]|0x40;
			  }
                        }
                        else {
                          if (atr&H_FLIP){
                                if (J&0x02) {C[1]=VB[(c1&3)];}
                                if (J&0x01) {*C=VB[(c2&3)];}
                                c1>>=2;
                                c2>>=2;
                                if (J&0x08) {C[3]=VB[(c1&3)];}
                                if (J&0x04) {C[2]=VB[(c2&3)];}
                                c1>>=2;
                                c2>>=2;
                                if (J&0x20) {C[5]=VB[c1&3];}
                                if (J&0x10) {C[4]=VB[c2&3];}
                                c1>>=2;
                                c2>>=2;
                                if (J&0x80) {C[7]=VB[(c1)];}
                                if (J&0x40) {C[6]=VB[(c2)];}
                          }else{                    
                                if (J&0x02) {C[6]=VB[(c1&3)];}
                                if (J&0x01) {C[7]=VB[(c2&3)];}
                                c1>>=2;
                                c2>>=2;
                                if (J&0x08) {C[4]=VB[(c1&3)];}
                                if (J&0x04) {C[5]=VB[(c2&3)];}
                                c1>>=2;                
                                c2>>=2;
                                if (J&0x20) {C[2]=VB[(c1&3)];}
                                if (J&0x10) {C[3]=VB[(c2&3)];}
                                c1>>=2;
                                c2>>=2;
                                if (J&0x80) {*C=VB[(c1)];}
                                if (J&0x40) {C[1]=VB[(c2)];}
			  }
                       }
                      }
         P-=x;
         }

     {
      uint8 n=((PPU[1]&4)^4)<<1;
      loopskie:
      {
       uint32 t=*(uint32 *)(sprlinebuf+n);
       if(t!=0x80808080)
       {
	#ifdef LSB_FIRST
        if(!(t&0x80))
        {
         if(!(t&0x40))       // Normal sprite
          P[n]=sprlinebuf[n];
         else if(P[n]&64)        // behind bg sprite
          P[n]=sprlinebuf[n];
        }

        if(!(t&0x8000))
        {
         if(!(t&0x4000))       // Normal sprite
          P[n+1]=(sprlinebuf+1)[n];
         else if(P[n+1]&64)        // behind bg sprite
          P[n+1]=(sprlinebuf+1)[n];
        }

        if(!(t&0x800000))
        {
         if(!(t&0x400000))       // Normal sprite
          P[n+2]=(sprlinebuf+2)[n];
         else if(P[n+2]&64)        // behind bg sprite
          P[n+2]=(sprlinebuf+2)[n];
        }

        if(!(t&0x80000000))
        {
         if(!(t&0x40000000))       // Normal sprite
          P[n+3]=(sprlinebuf+3)[n];
         else if(P[n+3]&64)        // behind bg sprite
          P[n+3]=(sprlinebuf+3)[n];
        }
	#else
        if(!(t&0x80000000))
        {
         if(!(t&0x40))       // Normal sprite
          P[n]=sprlinebuf[n];
         else if(P[n]&64)        // behind bg sprite
          P[n]=sprlinebuf[n];
        }

        if(!(t&0x800000))
        {
         if(!(t&0x4000))       // Normal sprite
          P[n+1]=(sprlinebuf+1)[n];
         else if(P[n+1]&64)        // behind bg sprite
          P[n+1]=(sprlinebuf+1)[n];
        }

        if(!(t&0x8000))
        {
         if(!(t&0x400000))       // Normal sprite
          P[n+2]=(sprlinebuf+2)[n];
         else if(P[n+2]&64)        // behind bg sprite
          P[n+2]=(sprlinebuf+2)[n];
        }

        if(!(t&0x80))
        {
         if(!(t&0x40000000))       // Normal sprite
          P[n+3]=(sprlinebuf+3)[n];
         else if(P[n+3]&64)        // behind bg sprite
          P[n+3]=(sprlinebuf+3)[n];
        }
	#endif
       }
      }
      n+=4;
      if(n) goto loopskie;
     }
}

void ResetMapping(void)
{
	int x;

        SetReadHandler(0x0000,0xFFFF,(void *)ANull);
	SetWriteHandler(0x0000,0xFFFF,(void *)BNull);

        SetReadHandler(0,0x7FF,(void *)ARAML);
        SetWriteHandler(0,0x7FF,(void *)BRAML);

        SetReadHandler(0x800,0x1FFF,(void *)ARAMH);  /* Part of a little */
        SetWriteHandler(0x800,0x1FFF,(void *)BRAMH); /* hack for a small speed boost. */

        for(x=0x2000;x<0x4000;x+=8)
        {
         ARead[x]=(void *)A200x;
         BWrite[x]=(void *)B2000;
         ARead[x+1]=(void *)A200x;
         BWrite[x+1]=(void *)B2001;
         ARead[x+2]=(void *)A2002;
         BWrite[x+2]=(void *)B2002;
         ARead[x+3]=(void *)A200x;
         BWrite[x+3]=(void *)B2003;
         ARead[x+4]=(void *)A200x;
         BWrite[x+4]=(void *)B2004;
         ARead[x+5]=(void *)A200x;
         BWrite[x+5]=(void *)B2005;
         ARead[x+6]=(void *)A200x;
         BWrite[x+6]=(void *)B2006;
         ARead[x+7]=(void *)A2007;
         BWrite[x+7]=(void *)B2007;
        }

        BWrite[0x4014]=(void *)B4014;
	InitializeInput();
        SetNESSoundMap();
}

void ResetNES(void)
{
        if(!GameLoaded || (GameAttributes&GA_NSF)) return;
        VRAMBuffer=PPU[0]=PPU[1]=PPU[2]=PPU[3]=PPUSPL=0;
        GameInterface(GI_RESETM2);
        ResetSound();
	Reset6502();
}

int GameLoaded=0;
void CloseGame(void)
{
 if(GameLoaded)
 {
  if(!(GameAttributes&GA_NSF))
   FlushGameCheats();
  #ifdef NETWORK
  if(FSettings.NetworkPlay) KillNetplay();
  #endif       
  GameInterface(GI_CLOSE);
  CloseGenie();
  GameLoaded=0;
 }
}

void ResetGameLoaded(void)
{
        if(GameLoaded) CloseGame();
	GameAttributes=0;
        GameStateRestore=0;
        PPU_hook=0;
        GameHBIRQHook=0;
	GameExpSound.Fill=0;
	GameExpSound.RChange=0;
        if(GameExpSound.Kill)
         GameExpSound.Kill();
        GameExpSound.Kill=0;
        MapIRQHook=0;
        MMC5Hack=0;
        PAL&=1;
	pale=0;
}

int FCEUI_LoadGame(char *name)
{
  int fp;
  int z;

DEBUGLOG( "FCEUI_LoadGame Start\n" );

  Exit=1;
  ResetGameLoaded();

DEBUGLOG( "FCEUI_LoadGame 1\n" );

	fp=FCEU_fopen(name,"rb");
	if(!fp)
  {
    FCEU_PrintError("Error opening \"%s\"!",name);
	  return 0;
	}

DEBUGLOG( "FCEUI_LoadGame 2\n" );

  GetFileBase(name);
DEBUGLOG( "FCEUI_LoadGame 2-1\n" );
  if((z=iNESLoad(name,fp)))
    goto endlseq;
DEBUGLOG( "FCEUI_LoadGame 2-2\n" );
  if((z=NSFLoad(fp)))
    goto endlseq;
DEBUGLOG( "FCEUI_LoadGame 2-3\n" );
  if((z=FDSLoad(name,fp)))
    goto endlseq;
DEBUGLOG( "FCEUI_LoadGame 2-4\n" );
  if((z=UNIFLoad(name,fp)))
    goto endlseq;

DEBUGLOG( "FCEUI_LoadGame 3\n" );
  FCEU_PrintError("An error occurred while loading the file.");
  FCEU_fclose(fp);
  return 0;

endlseq:
DEBUGLOG( "FCEUI_LoadGame 4\n" );
  FCEU_fclose(fp);
  GameLoaded=1;        
DEBUGLOG( "FCEUI_LoadGame 5\n" );
  FCEUD_SendMessage(DSM_RESETSPECIAL);
  if(GameAttributes&GA_NSF)
    FCEUD_SendMessage(DSM_SPECIALSYSTEM_NSF);
  if(GameAttributes&GA_FDS)
    FCEUD_SendMessage(DSM_SPECIALSYSTEM_FDS);
  if(GameAttributes&GA_VSUNI)
    FCEUD_SendMessage(DSM_SPECIALSYSTEM_VSUNISYSTEM);
  if(!(GameAttributes&GA_NSF))
  {
    SetVideoSystem(FSettings.PAL);
    if(FSettings.GameGenie)
       OpenGenie();
  }
DEBUGLOG( "FCEUI_LoadGame 6\n" );

  PowerNES();

DEBUGLOG( "FCEUI_LoadGame 7\n" );

	#ifdef NETWORK
        if(FSettings.NetworkPlay) InitNetplay();
	#endif
  SaveStateRefresh();
  if(!(GameAttributes&GA_NSF))
  {
DEBUGLOG( "FCEUI_LoadGame 8\n" );
//    LoadGamePalette();
//  LoadGameCheats();
  }
DEBUGLOG( "FCEUI_LoadGame 9\n" );
        
	ResetPalette();
  Exit=0;
DEBUGLOG( "FCEUI_LoadGame END\n" );
  return 1;
}

void SetVideoSystem(int w)
{
 if(w)
 {
  PAL=1;
  HPeriod=75;
  IPeriod=320-HPeriod;
  scanlines_per_frame=312; 
 }
 else
 {
  PAL=0;
  HPeriod = 85;
  IPeriod=256;
  scanlines_per_frame=262;
 }
 SetSoundVariables();
}

int FCEUI_Initialize(void)
{
        if(!InitVirtualVideo())
         return 0;
	memset(&FSettings,0,sizeof(FSettings));
	FSettings.FirstSLine=8;
        FSettings.LastSLine=239;

	InitCRC32();
        return 1;
}

#define harko 0xe //0xe
static INLINE void Thingo(void)
{
   Loop6502();
   if(tosprite>=256)
   { 
    Run6502(IPeriod-harko);
    Fixit1();
    Run6502(harko);
   }
   else
   {
    if(PAL) tosprite=(tosprite*IPeriod)>>8;
    if(tosprite<=240)
    {
     Run6502(tosprite);
     PPU[2]|=0x40;
     Run6502(IPeriod-tosprite-harko);
     Fixit1();
     Run6502(harko);
    }
    else
    {
     Run6502(IPeriod-harko);
     Fixit1();
     Run6502(tosprite-(IPeriod-harko));
     PPU[2]|=0x40;
     Run6502(IPeriod-tosprite);

    }
    tosprite=256;
   }

   DoHBlank();
}
#undef harko

void EmLoop(void)
{

 for(;;)
 {
  for(scanline=0;scanline<240;scanline++)
  {
   Thingo();
  }
  SetNESDeemph(PPU[1]>>5,0);
  UpdateInput();
  /* To use frameskip, PutImage() calls FCEUI_FrameSkip() with
     the number of frames to skip before the next call. */
  #ifdef FRAMESKIP
  if(FrameSkip == 0) PutImage();
  if(FrameSkip)
   FrameSkip--;
  #else
  PutImage();
  #endif
  FlushEmulateSound();

  if(Exit)
  {
   CloseGame();
   break;
  }

  ApplyPeriodicCheats();
  Run6502(IPeriod+HPeriod-20);
  PPU[2]|=0x80;
  PPU[3]=PPUSPL=0;			// Not sure if this is correct.  According
				// to Matt Conte and my own tests, it is.  Timing is probably
				// off, though.  NOTE:  Not having this here
				// breaks a Super Donkey Kong game.
  Run6502(20);
  if(VBlankON)
  {
   if(GameAttributes&GA_NSF)
    TriggerNMINSF();
   else
    TriggerNMI();
  }
  Run6502((scanlines_per_frame-242)*(IPeriod+HPeriod));

  PPU_status&=0x1f;

  Run6502(IPeriod);
  {
   static int kook=0;
   if(ScreenON || SpriteON)
    if(GameHBIRQHook)
     GameHBIRQHook();

   Run6502(HPeriod-kook);
   kook=(kook+1)&1;
  }

  if(ScreenON || SpriteON)
   RefreshAddr=TempAddr;

 }
}

#ifdef FPS
#include <sys/time.h>
uint64 frcount;
#endif
void FCEUI_Emulate(void)
{
	#ifdef FPS
        uint64 starttime,end;
        struct timeval tv;
	frcount=0;
        gettimeofday(&tv,0);
        starttime=((uint64)tv.tv_sec*1000000)+tv.tv_usec;
	#endif
	EmLoop();

        #ifdef FPS
        // Probably won't work well on Windows port; for
	// debugging/speed testing.
	{
	 int w;
	 int i,frac;
         gettimeofday(&tv,0);
         end=((uint64)tv.tv_sec*1000000)+tv.tv_usec;
	 w=frcount*10000000000/(end-starttime);
	 i=w/10000;
	 frac=w-i*10000;
//         printf("Average FPS: %d.%04d\n",i,frac);
	}
        #endif

}

void FCEUI_CloseGame(void)
{
        Exit=1;
}


void PowerNES(void) 
{
        if(!GameLoaded) return;

	FCEU_CheatResetRAM();
	FCEU_CheatAddRAM(2,0,RAM);

        GeniePower();

        VRAMBuffer=PPU[0]=PPU[1]=PPU[2]=PPU[3]=0;

        RefreshAddr=TempAddr=0;
        vtoggle = 0;

        memset(NTARAM,0x00,0x800);
        memset(PALRAM,0x00,0x20);        
        memset(RAM,0x00,0x800);
        memset(SPRAM,0x00,0x100);
        ResetMapping();
	GameInterface(GI_POWER);
        PowerSound();
	Power6502();
}
