#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "m6502.h"
#include "types.h"
#include "fce.h"
#include "gg.h"
#include "ggrom.h"
#include "memory.h"

static uint8 *GENIEROM;
static readfunc *genierb=0;
static writefunc *geniewb=0;
static uint8 *geniepb[16],*genievpb[8];

void RemoveGenieMap(void);
static void (*GBPPU_hook)(uint32 A);
static int GBMMC5Hack;


int geniestage=0;
uint8 modcon=0xFF;
uint8 genieval[3];
uint8 geniech[3];
uint8 geniemodsave[3];
uint8 *geniemodsaddr[3];
uint16 genieaddr[3];

void SetGenieROMImage(void)
{
        int x;
        geniestage=0;

        for(x=0;x<3;x++)
         geniemodsaddr[x]=0;

        if(GENIEROM) goto oko;
        if(!(GENIEROM=FCEU_malloc(1024))) return;

        for(x=0;x<4;x++)
         memcpy(GENIEROM+(x<<8),GenieData+4096,256);
        oko:
        if(!genierb)
         genierb=malloc(32768*sizeof(readfunc));
        if(!geniewb)
         geniewb=malloc(32768*sizeof(writefunc));

        geniestage=1;
}


static DECLFW(GenieWrite)
{
switch(A)
 {
 case 0x800c:
 case 0x8008:
 case 0x8004:genieval[((A-4)&0xF)>>2]=V;break;

 case 0x800b:
 case 0x8007:
 case 0x8003:geniech[((A-3)&0xF)>>2]=V;break;

 case 0x800a:
 case 0x8006:
 case 0x8002:genieaddr[((A-2)&0xF)>>2]&=0xFF00;genieaddr[((A-2)&0xF)>>2]|=V;break;

 case 0x8009:
 case 0x8005:
 case 0x8001:genieaddr[((A-1)&0xF)>>2]&=0xFF;genieaddr[((A-1)&0xF)>>2]|=(V|0x80)<<8;break;
 case 0x8000:if(!V)
             {
              if(modcon!=0xFF)
               geniestage=3;
	      else
	       geniestage=4;
              RemoveGenieMap();
             }
             else
             {
              modcon=V;
              if(V==0x71) modcon=0xFF;
             }
             break;
 }
}

void GenieFlush(void)
{
 if(geniestage==3)
 {
  int x;
  for(x=0;x<3;x++)
   if(geniemodsaddr[x])
   {
    *geniemodsaddr[x]=geniemodsave[x];
    geniemodsaddr[x]=0;
   } 
 }
}

void RemoveGenieMap(void)
{
 uint32 x;

 for(x=0x8000;x<0x10000;x++)
 {
  SetWriteHandler(x,x,geniewb[x-0x8000]);
  SetReadHandler(x,x,genierb[x-0x8000]);
 }

 for(x=0;x<16;x++)
  Page[16+x]=geniepb[x];
 for(x=0;x<8;x++)
  VPage[x]=genievpb[x];

 PPU_hook=GBPPU_hook;
 MMC5Hack=GBMMC5Hack;
}

void GenieInit(void)
{
 uint32 x;

 memset(genieval,0xFF,3);
 memset(geniech,0xFF,3);
 memset(genieaddr,0xFF,6);
 modcon=0xFF;

 for(x=0x8000;x<0x10000;x++)
 {
  geniewb[x-0x8000]=GetWriteHandler(x);
  genierb[x-0x8000]=GetReadHandler(x);
 }

 GBPPU_hook=PPU_hook;
 GBMMC5Hack=MMC5Hack;

 PPU_hook=0;
 MMC5Hack=0;

 SetWriteHandler(0x8000,0xFFFF,(void *)GenieWrite);
 SetReadHandler(0x8000,0xFFFF,(void *)APage);

 for(x=0;x<3;x++)
  if(geniemodsaddr[x])
   *geniemodsaddr[x]=geniemodsave[x];

 for(x=0;x<16;x++)
  geniepb[x]=Page[16+x];
 for(x=0;x<8;x++)
  genievpb[x]=VPage[x];

 for(x=0;x<8;x++)
  setpageptr4(0x8000+x*4096,GenieData);
 for(x=0;x<8;x++)
  VPage[x]=GENIEROM-0x400*x;
 geniestage=2;
}

