#include "m6502.h"
#include "types.h"
#include "fce.h"
#include "sound.h"
#include "netplay.h"
#include "svga.h"

#include "input.h"
#include "zapper.h"
#include "powerpad.h"

static uint8 joy_readbit,joy2_readbit;
static uint16 joy_1=0,joy_2=0;

extern int coinon;
static int JoyMulti=0;
static int JoyPortAttrib[2]={0,0};
static int JoyPortType[2]={0,0};
static void *InputDataPtr[2];
static readfunc VSUNIMSave[2];

void (*InputScanlineHook)(uint8 *buf, int line);
void (*PStrobe[2])(void);

static DECLFR(GPA4016VSUNI)
{
                uint8 ret;
		if(joy_readbit>=8)
		 ret=1;
		else
		{
                 ret = ((joy_1>>(joy_readbit))&1);
                 joy_readbit++;
		}
                return ret;
}

static DECLFR(GPA4017VSUNI)
{
                uint8 ret;
		if(joy2_readbit>=8)
		 ret=1;
		else
		{
                 ret=((joy_2>>(joy2_readbit))&1);
                 joy2_readbit++;
		}
                return ret;
}

static DECLFR(GPA4016)
{
                uint8 ret;
                if(JoyMulti) 
		{
                 ret = ((joy_1>>(joy_readbit))&1)|
                 (((joy_1>>(joy_readbit+8))&1)<<1);
                 if(joy_readbit>8) ret=0;
		}
		else
		{
                 ret = ((joy_1>>(joy_readbit))&1);
                 if(joy_readbit==19) ret|=1;
		}
                ret|=M.DB&0xE0;
		joy_readbit++;
                return ret;
}

static DECLFR(GPA4017)
{
                uint8 ret;
                if(JoyMulti)
                {
                 ret = ((joy_2>>(joy2_readbit))&1)|
                 (((joy_2>>(joy2_readbit+8))&1)<<1);
                 if(joy2_readbit>8) ret=0;
                }
                else
                {
                 ret=((joy_2>>(joy2_readbit))&1);
                 if(joy2_readbit==18) ret|=1;
		}
                ret|=M.DB&0xE0;
		joy2_readbit++;
                return ret;
}

static DECLFW(B4016)
{
                        if((PSG[0x16]&1) && (!(V&1)))
                        {
			 if(PStrobe[0])
			  PStrobe[0]();
			 if(PStrobe[1])
			  PStrobe[1]();
			}
                        PSG[0x16]=V;
}
static void GP1Strobe(void)
{
	joy_readbit=0;
}
static void GP2Strobe(void)
{
	joy2_readbit=0;
}

void UpdateInput(void)
{
	int x;
	FCEUD_UpdateInput();

	for(x=0;x<2;x++)
	{
	 switch(JoyPortType[x])
	 {
	  case DII_SETCONTROL_GAMEPAD:
		if(!x) joy_1=*(uint16 *)InputDataPtr[0];
		else joy_2=*(uint16 *)InputDataPtr[1];
		break;
	  case DII_SETCONTROL_ZAPPER:
                UpdateZapper(x,InputDataPtr[x], JoyPortAttrib[x]);
		break;
          case DII_SETCONTROL_POWERPAD:
                UpdatePowerpad(x,InputDataPtr[x]);
                break;
	 }
	}

        if(GameAttributes&GA_VSUNI)
        {
	 uint16 t=joy_1;
	 joy_1=(joy_1&0xC)|(joy_2&0xF3);
	 joy_2=(joy_2&0xC)|(t&0xF3);
	 if(coinon) coinon--;
	}
#ifdef NETWORK
	if(netplay) NetplayUpdate(&joy_1,&joy_2);
#endif
	FlushCommandQueue();
}
static DECLFR(VSUNIRead0)
{
	uint8 ret;
	ret=(VSUNIMSave[0](A))&3;
	ret|=(vsdip&3)<<3;
	if(coinon)
	 ret|=0x4;
	return ret;
}

static DECLFR(VSUNIRead1)
{
        uint8 ret;
        ret=(VSUNIMSave[1](A))&3;
        ret|=vsdip&0xFC;
        return ret;
}

static DECLFR(NoJRead)
{
	return M.DB&0xE0;
}

static void ZapBap(uint8 *buf, int line)
{
 int x;

 for(x=0;x<2;x++)
  if(JoyPortType[x]==DII_SETCONTROL_ZAPPER)
   ZapperThingy(x,buf,line);
}

static void FASTAPASS(1) SetInputStuff(int x)
{
         PStrobe[x]=0;
 	 switch(JoyPortType[x])
	 {
          default:SetReadHandler(0x4016+x,0x4016+x,NoJRead);
                  break;
	  case DII_SETCONTROL_GAMEPAD:
           if(GameAttributes&GA_VSUNI)
           {
 	    if(!x)
 	    { 
 	     PStrobe[0]=(void *)GP1Strobe;
	     SetReadHandler(0x4016,0x4016,GPA4016VSUNI);
	    }
	    else
	    {
             PStrobe[1]=(void *)GP2Strobe;
	     SetReadHandler(0x4017,0x4017,GPA4017VSUNI);
	    }
	   }
	   else
	   {
            if(!x)
            {
             PStrobe[0]=(void *)GP1Strobe;
	     SetReadHandler(0x4016,0x4016,GPA4016);
            }
            else
            {
             PStrobe[1]=(void *)GP2Strobe;
	     SetReadHandler(0x4017,0x4017,GPA4017);
            }
	   }
	  break;
	  case DII_SETCONTROL_ZAPPER:HookZapper(x);break;
          case DII_SETCONTROL_POWERPAD:HookPowerpad(x);break;
         }
        
	if(GameAttributes&GA_VSUNI)
	{
         VSUNIMSave[x]=GetReadHandler(0x4016+x);
         if(!x)
          SetReadHandler(0x4016,0x4016,VSUNIRead0);
         else
	  SetReadHandler(0x4017,0x4017,VSUNIRead1);
	}

        InputScanlineHook=0;
        if(JoyPortType[0]==DII_SETCONTROL_ZAPPER || JoyPortType[1]==DII_SETCONTROL_ZAPPER)
         InputScanlineHook=ZapBap;
}

// VS Unisystem code called after InitializeInput hooks B4016.  Need to
// rewrite code to make this more sane?

void InitializeInput(void)
{ 
        SetWriteHandler(0x4016,0x4016,B4016);
        SetInputStuff(0);
        SetInputStuff(1);
}

void DriverInputInterface(int w, int n, int arg, void *ptr)
{
 switch(w)
 {
  case DII_SETCONTROL:JoyPortAttrib[n]=0;JoyPortType[n]=arg;InputDataPtr[n]=ptr;SetInputStuff(n);break;
  case DII_SETCONTROLATTRIB:JoyPortAttrib[n]=arg;break;
  case DII_SETMULTI:JoyMulti=arg;break;
 }
}
