#ifndef __M6502H
/** M6502: portable 6502 emulator ****************************/
/**                                                         **/
/**                         M6502.h                         **/
/**                                                         **/
/** This file contains declarations relevant to emulation   **/
/** of 6502 CPU.                                            **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1996                      **/
/**               Alex Krasivsky  1996                      **/
/** Modyfied      BERO            1998                      **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/   
/**     changes to this file.                               **/
/*************************************************************/
#include "types.h"

                               /* 6502 status flags:         */
#define	C_FLAG	  0x01         /* 1: Carry occured           */
#define	Z_FLAG	  0x02         /* 1: Result is zero          */
#define	I_FLAG	  0x04         /* 1: Interrupts disabled     */
#define	D_FLAG	  0x08         /* 1: Decimal mode            */
#define	B_FLAG	  0x10         /* Break [0 on stk after int] */
#define	R_FLAG	  0x20         /* Always 1                   */
#define	V_FLAG	  0x40         /* 1: Overflow occured        */
#define	N_FLAG	  0x80         /* 1: Result is negative      */

typedef struct
{
  int ICount;
  int ICounta;
  pair PC;
  uint8 A,P,X,Y,S;     /* CPU registers and program counter   */
  uint8 PI;
  uint8 jammed;
  uint8 DB;
  uint8 IRQlow;
} M6502;

void Reset6502(void);
void Power6502(void);
void Run6502(unsigned int cycles);

extern uint32 timestamp;
void TriggerIRQ(void);
void TriggerNMI(void);

#define FCEU_IQEXT      0x01
#define FCEU_IQDPCM     0x10
#define FCEU_IQFCOUNT   0x20
#define FCEU_IQTEMP     0x80 

void FASTAPASS(1) M6502_IRQBegin(int w);
void FASTAPASS(1) M6502_IRQEnd(int w);

void TriggerNMINSF(void);

#define NTSC_CPU 1789772.7272727272727272
#define PAL_CPU 1664687.1770833333333333
extern M6502 M;

void Add6502Cycle(int x);
#define __M6502H
#endif
