#include "mapinc.h"

#define K4buf mapbyte2
#define K4buf2 mapbyte3


void FP_FASTAPASS(1) JalecoIRQHook(int a)
{
  if(IRQa)
  {
   IRQCount-=a;
   if(IRQCount<=-8)
   {
    TriggerIRQ();
    IRQCount=IRQLatch;
   }
  }
}

DECLFW(Mapper18_write)
{
	A&=0xF003;
	if(A>=0x8000 && A<=0x9001)
	{
         int x=((A>>1)&1)|((A-0x8000)>>11);

         K4buf2[x]&=(0xF0)>>((A&1)<<2);
         K4buf2[x]|=(V&0xF)<<((A&1)<<2);
         ROM_BANK8(0x8000+(x<<13),K4buf2[x]);
	}
	else if(A>=0xa000 && A<=0xd003)
	{
	 int x=((A>>1)&1)|((A-0xA000)>>11);

         K4buf[x]&=(0xF0)>>((A&1)<<2);
         K4buf[x]|=(V&0xF)<<((A&1)<<2);
         VROM_BANK1(x<<10,K4buf[x]);
	}
        else switch(A)
        {
  	 case 0xe000:IRQLatch&=0xF0;IRQLatch|=V&0x0f;break;
	 case 0xe001:IRQLatch&=0x0F;IRQLatch|=V<<4;break;
 	 case 0xe002:IRQLatch&=0xF0FF;IRQLatch|=(V&0x0f)<<8;break;
	 case 0xe003:IRQLatch&=0x0FFF;IRQLatch|=V<<12;break;

	 case 0xf000:if(V&1)IRQCount=IRQLatch;break;
	 case 0xf001://IRQCount=IRQLatch;
	             IRQa=V&1;break;

	 case 0xf002:MIRROR_SET2(V&1);
	             if(V&2) onemir(0);
         	     break;
        }
}

void Mapper18_init(void)
{
SetWriteHandler(0x8000,0xffff,(void *)Mapper18_write);
MapIRQHook=(void *)JalecoIRQHook;
}
