#include "mapinc.h"

#define dopol mapbyte1[0]
#define gorfus mapbyte1[1]
static void NamcoSound(int Count);
static void NamcoSoundHack(void);

static int32 inc;
void FP_FASTAPASS(1) NamcoIRQHook(int a)
{
  if(IRQa)
  {
   IRQCount+=a;
   if(IRQCount>=0xFFFF)
   {
    M6502_IRQBegin(FCEU_IQEXT);
    IRQa=0;
    IRQCount=0xFFFF;
   }
  }
}


DECLFR(Namco_Read4800)
{
	uint8 ret=MapperExRAM[dopol&0x7f];
	if(dopol&0x80)
	 dopol=(dopol&0x80)|((dopol++)&0x7f);
	return ret;
}

DECLFR(Namco_Read5000)
{
 return((uint8)IRQCount);
}

DECLFR(Namco_Read5800)
{
 return(IRQCount>>8);
}

static void Map19SQ(uint8 A, uint8 V)
{
 MapperExRAM[0x100+(A&0x7f)]=V;
}

static void FASTAPASS(2) DoNTARAMROM(int w, uint8 V)
{
        mapbyte2[w]=V;
        if(V>=0xE0)
	 setntamem(NTARAM+((V&1)<<10), 1, w);
        else
	{
	 V&=CHRmask1[0];
	 setntamem(VROM+(V<<10), 0, w);
	}
}

DECLFW(Mapper19_write)
{
	A&=0xF800;
	if(A>=0x8000 && A<=0xb800)
	{
	 int x=((A-0x8000)>>11);

         if(!(gorfus&0x40) && (V>=0xE0)) 
	  VRAM_BANK1(x<<10,V&7);
         else
	  VROM_BANK1(x<<10,V);
	}
	else if(A>=0xC000 && A<=0xd800)
 	 DoNTARAMROM((A-0xC000)>>11,V);
        else switch(A)
	{
        case 0x4800:if(dopol&0x40)
                    {
                     if(FSettings.SndRate)
		     {
		      NamcoSoundHack();
                      GameExpSound.Fill=(void *)NamcoSound;
		     }
                    }

		    MapperExRAM[dopol&0x7f]=V;
                    Map19SQ(dopol,V);
                    if(dopol&0x80)
                     dopol=(dopol&0x80)|((dopol++)&0x7f);
                    break;
        case 0xf800:dopol=V;break;
        case 0x5000: IRQCount&=0xFF00;IRQCount|=V;M6502_IRQEnd(FCEU_IQEXT);break;
        case 0x5800: IRQCount&=0x00ff;IRQCount|=V<<8;
                     IRQa=V&0x80;
                     M6502_IRQEnd(FCEU_IQEXT);
                     break;

        case 0xE000:
                    ROM_BANK8(0x8000,V);
                    break;
        case 0xE800:
                    gorfus=V&0xC0;
                    ROM_BANK8(0xA000,V);
                    break;
        case 0xF000:
                    ROM_BANK8(0xC000,V);
                    break;
        }
}

static int dwave=0;
static void DoNamcoSound(int32 *Wave, int Count);

static void NamcoSoundHack(void)
{
 int32 z,a;

 z=((timestamp<<16)/soundtsinc)>>4;  
 a=z-dwave;
 if(a)
  DoNamcoSound(&Wave[dwave], a);
 dwave+=a;
}

static void NamcoSound(int Count)
{
 int32 z,a;

 z=((timestamp<<16)/soundtsinc)>>4;
 a=z-dwave;
 if(a)
   DoNamcoSound(&Wave[dwave], a);
 dwave=0;
}

static uint8 PlayIndex[8];
static int32 vcount[8];

static void DoNamcoSound(int32 *Wave, int Count)
{
	int P,V;

      for(P=0;P<=8;P++)
      {
       if((MapperExRAM[0x100+0x44+(P<<3)]&0xE0) && (MapperExRAM[0x100+0x47+(P<<3)]&0xF))
       {
	uint32 freq;
	int32 vco;
	int duff,duff2,lengo,envelope;
        //uint64 ta;

        vco=vcount[P];
        freq=MapperExRAM[0x100+0x40+(P<<3)];
        freq|=MapperExRAM[0x100+0x42+(P<<3)]<<8;
        freq|=(MapperExRAM[0x100+0x44+(P<<3)]&3)<<16;

        if(!freq) continue;

        inc=(long double)(FSettings.SndRate<<15)/(((long double)freq*(440*
         (2-((MapperExRAM[0x144+(P<<3)]>>4)&1)))/(long double)15467));
	//inc=(long double)(FSettings.SndRate<<15)/( (freq*NTSC_CPU) / 
	//(0x4000000) );
        envelope=((MapperExRAM[0x100+0x47+(P<<3)]&0xF)<<18)/15;
        duff=MapperExRAM[0x100+(((MapperExRAM[0x100+0x46+(P<<3)]+PlayIndex[P])>>1)&0x3F)];
        if((MapperExRAM[0x100+0x46+(P<<3)]+PlayIndex[P])&1)
         duff>>=4;
        duff&=0xF;
        duff2=((duff-8)*envelope)>>14;
  
        lengo=((8-((MapperExRAM[0x100+0x44+(P<<3)]>>2)&3)))<<2;
//	lengo=(16-((MapperExRAM[0x144+(P<<3)]>>2)&7))<<1;
        for(V=0;V<Count OVERSAMPLE;V++)
        {
         if(vco>=inc)
         {
          PlayIndex[P]++;
          if(PlayIndex[P]>=lengo)
           PlayIndex[P]=0;
          vco-=inc;
          duff=MapperExRAM[0x100+(((MapperExRAM[0x46+(P<<3)]+PlayIndex[P])&0x3F)>>1)];
          if((MapperExRAM[0x100+0x46+(P<<3)]+PlayIndex[P])&1)
           duff>>=4;
          duff&=0xF;
          duff2=((duff-8)*envelope)>>14;
         }
          Wave[V>>4]+=duff2;
          vco+=0x8000;
        }
        vcount[P]=vco;
       }
      }
}

static void Mapper19_StateRestore(int version)
{
 int x;
 for(x=0;x<4;x++)
  DoNTARAMROM(x,mapbyte2[x]); 
}

static void M19SC(void)
{
 if(FSettings.SndRate)
  Mapper19_ESI();
}

void Mapper19_ESI(void)
{
  GameExpSound.RChange=(void *)M19SC;
  SetWriteHandler(0xf800,0xffff,(void *)Mapper19_write);
  SetWriteHandler(0x4800,0x4fff,(void *)Mapper19_write);
  SetReadHandler(0x4800,0x4fff,(void *)Namco_Read4800);
}

void Mapper19_init(void)
{
        if(!Mirroring)
        {
         DoNTARAMROM(0,0xE0);
         DoNTARAMROM(1,0xE0);
         DoNTARAMROM(2,0xE1);
         DoNTARAMROM(3,0xE1);
        }
        else
        {
         DoNTARAMROM(0,0xE0);
         DoNTARAMROM(2,0xE0);
         DoNTARAMROM(1,0xE1);
         DoNTARAMROM(3,0xE1);
        }
        VROM_BANK8(~0);
        SetWriteHandler(0x8000,0xffff,(void *)Mapper19_write);
        SetWriteHandler(0x4020,0x5fff,(void *)Mapper19_write);
        SetReadHandler(0x4800,0x4fff,(void *)Namco_Read4800);
	SetReadHandler(0x5000,0x57ff,(void *)Namco_Read5000);
	SetReadHandler(0x5800,0x5fff,(void *)Namco_Read5800);

        MapIRQHook=(void *)NamcoIRQHook;
        MapStateRestore=(void *)Mapper19_StateRestore;
        GameExpSound.RChange=(void *)M19SC;
        if(FSettings.SndRate)
         Mapper19_ESI();
        gorfus=0xFF;
}

