#include "mapinc.h"

#define rg mapbyte1
static void DoPRG(void)
{
  int32 b=((rg[0]>>1)&0xF) | ((rg[0]>>3)&0x10) | ((rg[1]&1)<<5);
  if(rg[0]&0x20)        // 16 KB
  {
   ROM_BANK16(0x8000,(b<<1)|(rg[0]&1));
   ROM_BANK16(0xC000,(b<<1)|(rg[0]&1));
  }
  else
   ROM_BANK32(b);
}

static DECLFW(Mapper226_write)
{
 rg[A&1]=V;
 DoPRG();
 if(A&1)
 {
  if(rg[1]&2)
   PPUCHRRAM=0;  // Write protected.
  else
   PPUCHRRAM=0xFF; // Not write protected.
 }
 else
  MIRROR_SET2((rg[0]>>6)&1);
}

static void M26Reset(void)
{
 rg[0]=rg[1]=0;
 DoPRG();
 PPUCHRRAM=0xFF;
 MIRROR_SET2(0);
}

static void M26Restore(int version)
{
 DoPRG();
 if(rg[1]&2)
  PPUCHRRAM=0;  // Write protected.
 else
  PPUCHRRAM=0xFF; // Not write protected.
 MIRROR_SET2((rg[0]>>6)&1);
}

void Mapper226_init(void)
{
  SetWriteHandler(0x8000,0xffff,(void *)Mapper226_write);
  MapperReset=(void *)M26Reset;
  GameStateRestore=(void *)M26Restore;
  M26Reset();
}

#ifdef OLD	// What the heck is this??
DECLFW(Mapper226_write)
{
 MIRROR_SET((A>>13)&1);
 VROM_BANK8(A&0x7F);
 if(A&0x1000)
  {
   if(A&0x40)
    {
     ROM_BANK16(0x8000,(((A>>7))<<1)+1);
     ROM_BANK16(0xC000,(((A>>7))<<1)+1);
    }
    else
    {
     ROM_BANK16(0x8000,(((A>>7))<<1));
     ROM_BANK16(0xC000,(((A>>7))<<1));
    }
  }
  else
  {
   ROM_BANK32(A>>7);
  }
}

void Mapper226_init(void)
{
  SetWriteHandler(0x8000,0xffff,(void *)Mapper226_write);
}
#endif
