#include "mapinc.h"

#define rg mapbyte1

static void DoSync(uint32 A)
{
 int32 p=((A>>3)&0xF) | ((A>>4)&0x10);

 rg[0]=A;
 rg[1]=A>>8;

 MIRROR_SET((A>>1)&1);
 if(A&1)	//32 KB
 {
  ROM_BANK32(p);
 }
 else		//16 KB
 {
  ROM_BANK16(0x8000,(p<<1)|((A&4)>>2));
  ROM_BANK16(0xc000,(p<<1)|((A&4)>>2));
 }
 if(A&0x80)
 {
  PPUCHRRAM=0;
 }
 else
 {
  PPUCHRRAM=0xFF;
  if(A&0x200)
   ROM_BANK16(0xC000,(p<<1)|7);
  else
   ROM_BANK16(0xC000,(p<<1)&(~7));
 }
}

static DECLFW(Mapper227_write)
{
 rg[A&1]=V;
 DoSync(A);
}

static void M227Reset(void)
{
 rg[0]=rg[1]=0;
 DoSync(0);
}

static void M227Restore(int version)
{
 DoSync(rg[0]|(rg[1]<<8));
}

void Mapper227_init(void)
{
  SetWriteHandler(0x8000,0xffff,(void *)Mapper227_write);
  MapperReset=(void *)M227Reset;
  GameStateRestore=(void *)M227Restore;
  M227Reset();
}
