#include "mapinc.h"

#define r1 mapbyte1[0]
#define r2 mapbyte1[1]

static void DoBS(void)
{
 if(r1&0x40)
 {
  ROM_BANK32((r1&0xE)|(r2&1));
  VROM_BANK8( ((r1&0xE)<<2) | ((r2>>4)&7) );
 }
 else
 {
  ROM_BANK32(r1&0xF);
  VROM_BANK8( ((r1&0xF)<<2) | ((r2>>4)&3) );
 }
}

static void R1Set(uint8 V)
{
 if(r1) return;
 r1=V;
 MIRROR_SET(V>>7);
 DoBS();
}

static void R2Set(uint8 V)
{
 r2=V;
 DoBS();
}

DECLFW(R1W)
{
 R1Set(V);
}

DECLFR(R1R)
{
 uint8 r=CartBR(A);
 R1Set(r);
 return r;
}

DECLFW(R2W)
{
 R2Set(V);
}

DECLFR(R2R)
{
 uint8 r=CartBR(A);
 R2Set(r);
 return r;
}

static void M15Restore(int version)
{
 DoBS();
 MIRROR_SET(r1>>7);
}

static void M15Reset(void)
{
 r1=r2=0;
 DoBS();
 MIRROR_SET(0);
}

void Mapper234_init(void)
{
        SetWriteHandler(0xff80,0xff9f,(void *)R1W);
	SetReadHandler(0xff80,0xff9f,(void *)R1R);

	SetWriteHandler(0xffe8,0xfff7,(void *)R2W);
	SetReadHandler(0xffe8,0xfff7,(void *)R2R);

	SetReadHandler(0x6000,0x7FFF,0);
	SetWriteHandler(0x6000,0x7FFF,0);

	M15Reset();
		
	GameStateRestore=(void *)M15Restore;
	MapperReset=M15Reset;
}

