#include "mapinc.h"

#define cmd mapbyte1[0]
DECLFW(Mapper248_write)
{
// if(A>=0xc000) printf("$%04x:$%02x, %d\n",A,V,scanline);
 switch(A&0xF003)
 {
  case 0xa001:MIRROR_SET(V&1);break;
  case 0xc000:IRQLatch=0xC0;break;
  case 0xc001:IRQCount=IRQLatch;break;
  case 0xe003:IRQa=1;break;
  case 0x8000:cmd=V;break;
  case 0x8001:switch(cmd&7)
	      {
	       case 0:VROM_BANK2(0x0000,V>>1);break;
	       case 1:VROM_BANK2(0x800,V>>1);break;
	       case 2:VROM_BANK1(0x1000,V);break;
	       case 3:VROM_BANK1(0x1400,V);break;
	       case 4:VROM_BANK1(0x1800,V);break;
	       case 5:VROM_BANK1(0x1c00,V);break;
	       case 6:ROM_BANK8(0x8000,V);break;
	       case 7:ROM_BANK8(0xa000,V);break;
	      }
	      break;
 }
}
static void Mapper248_hb(void)
{
 if(IRQa)
 {
         IRQCount--;
         if(IRQCount<0)
          {
	  IRQa=0;
	  TriggerIRQ();
          IRQCount=IRQLatch;
          }
 }
}

void Mapper248_init(void)
{
  SetWriteHandler(0x4020,0x6fff,(void *)Mapper248_write);
  SetWriteHandler(0x8000,0xffff,(void *)Mapper248_write);
  GameHBIRQHook=(void *)Mapper248_hb;
}

