#include "mapinc.h"


static DECLFW(Mapper40_write)
{
 switch(A&0xe000)
 {
  case 0x8000:IRQa=0;IRQCount=0;break;
  case 0xa000:IRQa=1;break;
  case 0xe000:ROM_BANK8(0xc000,V&7);break;
 }
}

static void FP_FASTAPASS(1) Mapper40IRQ(int a)
{
 if(IRQa)
 {
        if(IRQCount<4096) 
	 IRQCount+=a;
	else
        {
         IRQa=0;
         TriggerIRQ();
        }
 }
}

void Mapper40_init(void)
{
  ROM_BANK8(0x6000,(~0)-1);
  ROM_BANK8(0x8000,(~0)-3);
  ROM_BANK8(0xa000,(~0)-2);
  SetWriteHandler(0x8000,0xffff,(void *)Mapper40_write);
  SetReadHandler(0x6000,0x7fff,(void *)CartBR);
  MapIRQHook=(void *)Mapper40IRQ;
}


