#include "mapinc.h"


static DECLFW(Mapper42_write)
{
 switch(A&0xe003)
 {
  case 0xe000:mapbyte1[0]=V;ROM_BANK8(0x6000,V&0xF);break;
  case 0xe001:MIRROR_SET((V>>3)&1);break;
  case 0xe002:IRQa=V&2;if(!IRQa) IRQCount=0;break;
 }
}

static void FP_FASTAPASS(1) Mapper42IRQ(int a)
{
 if(IRQa)
 {
        if(IRQCount<24576)
         IRQCount+=a;
        else
        {
         IRQa=0;
         TriggerIRQ();
        }
 }
}

static void Mapper42_StateRestore(int version)
{
    ROM_BANK8(0x6000,mapbyte1[0]&0xF);
}


void Mapper42_init(void)
{
  ROM_BANK8(0x6000,0);
  ROM_BANK32(~0);
  SetWriteHandler(0xe000,0xffff,(void *)Mapper42_write);
  SetReadHandler(0x6000,0x7fff,(void *)CartBR);
  MapStateRestore=(void *)Mapper42_StateRestore;
  MapIRQHook=(void *)Mapper42IRQ;
}

